/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class RubyOptionsAdvancedPanel
extends AdvancedOption {
    public String getTooltip() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(RubyOptionsAdvancedPanel.class, (String)"LBL_OptionsPanelName");
    }

    public OptionsPanelController create() {
        return new Controller();
    }

    private static final class Controller
    extends OptionsPanelController {
        private JPanel panel;
        private boolean initialized = false;
        private Map<String, AdvancedOption> categoryToOption = new HashMap<String, AdvancedOption>();
        private Map<String, JComponent> categoryToPanel = new HashMap<String, JComponent>();
        private Map<String, OptionsPanelController> categoryToController = new HashMap<String, OptionsPanelController>();
        private List<String> categoriesOrdered = new ArrayList<String>();

        private Controller() {
        }

        private void init(Lookup lookup) {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            Lookup lookup2 = Lookups.forPath((String)"RubyOptionsDialog");
            for (AdvancedOption advancedOption : lookup2.lookup(new Lookup.Template(AdvancedOption.class)).allInstances()) {
                String string = advancedOption.getDisplayName();
                this.categoriesOrdered.add(string);
                this.categoryToOption.put(string, advancedOption);
                OptionsPanelController optionsPanelController = advancedOption.create();
                this.categoryToController.put(string, optionsPanelController);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.add(optionsPanelController.getComponent(lookup));
                this.categoryToPanel.put(string, jPanel);
            }
        }

        public JComponent getComponent(Lookup lookup) {
            this.init(lookup);
            if (this.panel == null) {
                this.panel = new JPanel();
                this.panel.setLayout(new GridBagLayout());
                for (String string : this.categoriesOrdered) {
                    JComponent jComponent = this.categoryToPanel.get(string);
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.anchor = 18;
                    gridBagConstraints.fill = 1;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.gridwidth = 0;
                    this.panel.add((Component)jComponent, gridBagConstraints);
                }
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                this.panel.add((Component)new JPanel(), gridBagConstraints);
            }
            return this.panel;
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void update() {
            Iterator<OptionsPanelController> iterator = this.categoryToController.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().update();
            }
        }

        public void applyChanges() {
            Iterator<OptionsPanelController> iterator = this.categoryToController.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().applyChanges();
            }
        }

        public void cancel() {
            Iterator<OptionsPanelController> iterator = this.categoryToController.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().cancel();
            }
        }

        public boolean isValid() {
            Iterator<OptionsPanelController> iterator = this.categoryToController.values().iterator();
            while (iterator.hasNext()) {
                if (iterator.next().isValid()) continue;
                return false;
            }
            return true;
        }

        public boolean isChanged() {
            Iterator<OptionsPanelController> iterator = this.categoryToController.values().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().isChanged()) continue;
                return true;
            }
            return false;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("netbeans.optionsDialog.advanced.ruby");
        }
    }
}

