/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.rubyproject.RSpecSupport;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.RubyProject;
import org.netbeans.modules.ruby.rubyproject.Util;
import org.netbeans.modules.ruby.rubyproject.rake.RakeSupport;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.RubyProjectProperties;
import org.netbeans.modules.ruby.spi.project.support.rake.ProjectGenerator;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.EditableProperties;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyProjectGenerator {
    public static final String DEFAULT_SRC_NAME = "src.dir";
    public static final String DEFAULT_TEST_SRC_NAME = "test.src.dir";
    public static final String DEFAULT_SPEC_SRC_NAME = "spec.src.dir";

    private RubyProjectGenerator() {
    }

    public static RakeProjectHelper createProject(File file, String string, String string2, RubyPlatform rubyPlatform) throws IOException {
        FileObject fileObject = FileUtil.createFolder((File)file);
        RakeProjectHelper rakeProjectHelper = RubyProjectGenerator.createBasicProjectMetadata(fileObject, string, "lib", "test", "spec", string2, rubyPlatform);
        Project project = ProjectManager.getDefault().findProject(fileObject);
        ProjectManager.getDefault().saveProject(project);
        FileObject fileObject2 = fileObject.createFolder("lib");
        fileObject.createFolder("test");
        fileObject.createFolder("spec");
        if (string2 != null) {
            RubyProjectGenerator.createFromTemplate(string2, fileObject2, "Templates/Ruby/main.rb");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("PROJECT_NAME", file.getName());
        if (RSpecSupport.hasRSpecInstalled(rubyPlatform)) {
            hashMap.put("REQUIRE_SPEC_TASK", "require 'spec/rake/spectask'\n");
            StringBuilder stringBuilder = new StringBuilder();
            RubyBaseProject rubyBaseProject = (RubyBaseProject)project.getLookup().lookup(RubyBaseProject.class);
            FileObject[] fileObjectArray = rubyBaseProject.getSourceRootFiles();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                stringBuilder.append("\"");
                stringBuilder.append(fileObjectArray[i].getName());
                stringBuilder.append("\"");
                if (i + 1 >= fileObjectArray.length) continue;
                stringBuilder.append(",");
            }
            String string3 = "\nSpec::Rake::SpecTask.new do |t|\n  t.spec_files = FileList['spec/**/*.rb']\n  t.libs << Dir[" + stringBuilder.toString() + "]\n" + "end";
            hashMap.put("SPEC_TASK_DEF", string3);
        } else {
            hashMap.put("REQUIRE_SPEC_TASK", "");
            hashMap.put("SPEC_TASK_DEF", "");
        }
        RubyProjectGenerator.createFromTemplate("Rakefile", fileObject, "Templates/Ruby/Rakefile", hashMap);
        RubyProjectGenerator.createFileWithContent(fileObject, "README", "TXT_README_Content", string);
        RubyProjectGenerator.createFileWithContent(fileObject, "LICENSE", "TXT_LICENSE_Content", string);
        RakeSupport.refreshTasks(project);
        return rakeProjectHelper;
    }

    public static RakeProjectHelper createProject(File file, final String string, final File[] fileArray, final File[] fileArray2, RubyPlatform rubyPlatform) throws IOException {
        assert (fileArray != null && fileArray2 != null) : "Package roots can't be null";
        FileObject fileObject = FileUtil.createFolder((File)file);
        final RakeProjectHelper rakeProjectHelper = RubyProjectGenerator.createBasicProjectMetadata(fileObject, string, null, null, null, null, rubyPlatform);
        final RubyProject rubyProject = (RubyProject)ProjectManager.getDefault().findProject(fileObject);
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    RubyProjectGenerator.createProjectMetadata(rubyProject, rakeProjectHelper, fileArray, fileArray2, string);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            ErrorManager.getDefault().notify((Throwable)mutexException);
        }
        RakeSupport.refreshTasks(rubyProject);
        return rakeProjectHelper;
    }

    private static void createProjectMetadata(RubyProject rubyProject, RakeProjectHelper rakeProjectHelper, File[] fileArray, File[] fileArray2, String string) throws IOException {
        Element element;
        String string2;
        EditableProperties editableProperties;
        int n;
        String string3;
        int n2;
        ReferenceHelper referenceHelper = rubyProject.getReferenceHelper();
        Element element2 = rakeProjectHelper.getPrimaryConfigurationData(true);
        Document document = element2.getOwnerDocument();
        NodeList nodeList = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/ruby-project/1", "source-roots");
        assert (nodeList.getLength() == 1);
        Element element3 = (Element)nodeList.item(0);
        nodeList = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/ruby-project/1", "test-roots");
        assert (nodeList.getLength() == 1);
        Element element4 = (Element)nodeList.item(0);
        for (n2 = 0; n2 < fileArray.length; ++n2) {
            if (n2 == 0) {
                string3 = DEFAULT_SRC_NAME;
            } else {
                String string4 = fileArray[n2].getName();
                string3 = string4 + ".dir";
            }
            n = 1;
            editableProperties = rakeProjectHelper.getProperties("nbproject/project.properties");
            while (editableProperties.containsKey((Object)string3)) {
                string3 = string + ++n + ".dir";
            }
            string2 = referenceHelper.createForeignFileReference(fileArray[n2], "ruby");
            element = document.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "root");
            element.setAttribute("id", string3);
            element3.appendChild(element);
            editableProperties = rakeProjectHelper.getProperties("nbproject/project.properties");
            editableProperties.put(string3, string2);
            rakeProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        }
        for (n2 = 0; n2 < fileArray2.length; ++n2) {
            if (!fileArray2[n2].exists()) {
                fileArray2[n2].mkdirs();
            }
            if (n2 == 0) {
                string3 = DEFAULT_TEST_SRC_NAME;
            } else {
                String string5 = fileArray2[n2].getName();
                string3 = "test." + string5 + ".dir";
            }
            n = 1;
            editableProperties = rakeProjectHelper.getProperties("nbproject/project.properties");
            while (editableProperties.containsKey((Object)string3)) {
                string3 = "test." + string + ++n + ".dir";
            }
            string2 = referenceHelper.createForeignFileReference(fileArray2[n2], "ruby");
            element = document.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "root");
            element.setAttribute("id", string3);
            element4.appendChild(element);
            editableProperties = rakeProjectHelper.getProperties("nbproject/project.properties");
            editableProperties.put(string3, string2);
            rakeProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        }
        rakeProjectHelper.putPrimaryConfigurationData(element2, true);
        ProjectManager.getDefault().saveProject((Project)rubyProject);
    }

    private static RakeProjectHelper createBasicProjectMetadata(FileObject fileObject, String string, String string2, String string3, String string4, String string5, RubyPlatform rubyPlatform) throws IOException {
        Object object;
        Element element;
        RakeProjectHelper rakeProjectHelper = ProjectGenerator.createProject((FileObject)fileObject, (String)"org.netbeans.modules.ruby.rubyproject");
        Element element2 = rakeProjectHelper.getPrimaryConfigurationData(true);
        Document document = element2.getOwnerDocument();
        Element element3 = document.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "name");
        element3.appendChild(document.createTextNode(string));
        element2.appendChild(element3);
        EditableProperties editableProperties = rakeProjectHelper.getProperties("nbproject/project.properties");
        Element element4 = document.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "source-roots");
        if (string2 != null) {
            element = document.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "root");
            element.setAttribute("id", DEFAULT_SRC_NAME);
            element4.appendChild(element);
            editableProperties.setProperty(DEFAULT_SRC_NAME, string2);
        }
        element2.appendChild(element4);
        element = document.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "test-roots");
        if (string3 != null) {
            object = document.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "root");
            object.setAttribute("id", DEFAULT_TEST_SRC_NAME);
            element.appendChild((Node)object);
            editableProperties.setProperty(DEFAULT_TEST_SRC_NAME, string3);
        }
        if (string4 != null) {
            object = document.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "root");
            object.setAttribute("id", DEFAULT_SPEC_SRC_NAME);
            element.appendChild((Node)object);
            editableProperties.setProperty(DEFAULT_SPEC_SRC_NAME, string4);
        }
        element2.appendChild(element);
        rakeProjectHelper.putPrimaryConfigurationData(element2, true);
        object = FileEncodingQuery.getDefaultEncoding();
        editableProperties.setProperty("source.encoding", ((Charset)object).name());
        editableProperties.setProperty("main.file", string5 == null ? "" : string5);
        RubyProjectProperties.storePlatform(editableProperties, rubyPlatform);
        rakeProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        Util.logUsage(RubyProjectGenerator.class, "USG_PROJECT_CREATE_RUBY", rubyPlatform.getInfo().getKind(), rubyPlatform.getInfo().getPlatformVersion(), rubyPlatform.getInfo().getGemVersion());
        return rakeProjectHelper;
    }

    private static DataObject createFromTemplate(String string, FileObject fileObject, String string2) throws IOException {
        return RubyProjectGenerator.createFromTemplate(string, fileObject, string2, null);
    }

    private static DataObject createFromTemplate(String string, FileObject fileObject, String string2, Map<String, ? extends Object> map) throws IOException {
        Object object;
        String string3;
        String string4;
        int n = string.lastIndexOf(47);
        if (n == -1) {
            string4 = string.trim();
            string3 = null;
        } else {
            string4 = string.substring(n + 1).trim();
            string3 = string.substring(0, n).trim();
        }
        if (string4.length() == 0) {
            return null;
        }
        FileObject fileObject2 = FileUtil.getConfigFile((String)string2);
        if (fileObject2 == null) {
            return null;
        }
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        FileObject fileObject3 = fileObject;
        if (string3 != null) {
            object = string3.replace('.', '/');
            fileObject3 = FileUtil.createFolder((FileObject)fileObject, (String)object);
        }
        object = DataFolder.findFolder((FileObject)fileObject3);
        string4 = Util.stripExtension(string4, ".rb");
        if (map != null) {
            return dataObject.createFromTemplate(object, string4, map);
        }
        return dataObject.createFromTemplate(object, string4);
    }

    private static void createFileWithContent(FileObject fileObject, String string, String string2, String string3) throws IOException {
        FileObject fileObject2 = fileObject.createData(string);
        RubyProjectGenerator.writeLines(fileObject2, NbBundle.getMessage(RubyProjectGenerator.class, (String)string2, (Object)string3));
    }

    private static void writeLines(FileObject fileObject, String ... stringArray) throws FileAlreadyLockedException, IOException {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(fileObject.getOutputStream(), "UTF-8"));
        for (String string : stringArray) {
            printWriter.println(string);
        }
        printWriter.close();
    }
}

