/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.sps.impl;

import java.security.acl.NotOwnerException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.SolarisPrivilegesSupport;
import org.netbeans.modules.nativeexecution.sps.impl.FetchPrivilegesTask;
import org.netbeans.modules.nativeexecution.sps.impl.RequestPrivilegesAction;
import org.netbeans.modules.nativeexecution.sps.impl.RequestPrivilegesTask;
import org.netbeans.modules.nativeexecution.support.ObservableActionListener;
import org.netbeans.modules.nativeexecution.support.TasksCachedProcessor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SPSCommonImpl
implements SolarisPrivilegesSupport {
    private static final TasksCachedProcessor<ExecutionEnvironment, List<String>> cachedPrivilegesFetcher = new TasksCachedProcessor<ExecutionEnvironment, List<String>>(new FetchPrivilegesTask(), false);
    private static final TasksCachedProcessor<RequestPrivilegesTask.RequestPrivilegesTaskParams, Boolean> cachedPrivilegesRequestor = new TasksCachedProcessor<RequestPrivilegesTask.RequestPrivilegesTaskParams, Boolean>(new RequestPrivilegesTask(), true);
    private final ExecutionEnvironment execEnv;
    private volatile boolean cancelled = false;

    protected SPSCommonImpl(ExecutionEnvironment executionEnvironment) {
        this.execEnv = executionEnvironment;
    }

    ExecutionEnvironment getExecEnv() {
        return this.execEnv;
    }

    abstract String getPID();

    @Override
    public abstract void requestPrivileges(Collection<String> var1, String var2, char[] var3) throws NotOwnerException, CancellationException;

    @Override
    public void requestPrivileges(Collection<String> collection, boolean bl) throws NotOwnerException, CancellationException {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("requestExecutionPrivileges should never be called in AWT thread");
        }
        if (bl && this.cancelled) {
            return;
        }
        if (this.hasPrivileges(collection)) {
            return;
        }
        try {
            if (!cachedPrivilegesRequestor.compute(new RequestPrivilegesTask.RequestPrivilegesTaskParams(this, collection, bl)).booleanValue()) {
                throw new NotOwnerException();
            }
            this.invalidateCache();
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
    }

    public boolean isCanceled() {
        return this.cancelled;
    }

    @Override
    public boolean hasPrivileges(Collection<String> collection) {
        if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
            this.invalidate();
            return false;
        }
        List<String> list = this.getExecutionPrivileges();
        if (list == null) {
            return false;
        }
        boolean bl = true;
        for (String string : collection) {
            if (!bl) break;
            bl &= list.contains(string);
        }
        return bl;
    }

    @Override
    public List<String> getExecutionPrivileges() {
        List<String> list = null;
        try {
            list = cachedPrivilegesFetcher.compute(this.execEnv);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return list;
    }

    @Override
    public AsynchronousAction getRequestPrivilegesAction(Collection<String> collection, final Runnable runnable) {
        RequestPrivilegesAction requestPrivilegesAction = RequestPrivilegesAction.getInstance(this, collection);
        if (runnable != null) {
            requestPrivilegesAction.addObservableActionListener(new ObservableActionListener<Boolean>(){

                @Override
                public void actionStarted(Action action) {
                }

                @Override
                public void actionCompleted(Action action, Boolean bl) {
                    if (bl != null && bl.booleanValue()) {
                        runnable.run();
                    }
                }
            });
        }
        return requestPrivilegesAction;
    }

    private void invalidateCache() {
        cachedPrivilegesFetcher.remove(this.execEnv);
    }

    @Override
    public void invalidate() {
        this.invalidateCache();
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(SPSCommonImpl.class, (String)string, (Object[])stringArray);
    }
}

