/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.api.properties.GroupValue;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.PropertySupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DesignPropertyEditor
extends PropertyEditorSupport
implements ExPropertyEditor,
InplaceEditor.Factory {
    private List<String> propertyNames;
    private WeakReference<DesignComponent> component;
    private Object tempValue;
    private PropertyValue propertyValue;
    private PropertySupport propertySupport;
    private InplaceEditor inplaceEditor;
    private String propertyDisplayName;
    private String customEditorTitle;

    public void cleanUp(DesignComponent designComponent) {
        this.propertyNames = null;
        this.tempValue = null;
        this.propertyValue = null;
        this.propertySupport = null;
        this.inplaceEditor = null;
    }

    public Boolean canEditAsText() {
        return null;
    }

    public boolean canWrite() {
        return true;
    }

    public boolean isDefaultValue() {
        if (this.propertyNames == null || this.propertyNames.isEmpty()) {
            return true;
        }
        final boolean[] blArray = new boolean[]{true};
        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                for (String string : DesignPropertyEditor.this.propertyNames) {
                    if (((DesignComponent)DesignPropertyEditor.this.component.get()).isDefaultValue(string)) continue;
                    blArray[0] = false;
                    break;
                }
            }
        });
        return blArray[0];
    }

    @Override
    public boolean supportsCustomEditor() {
        Collection collection = ActiveDocumentSupport.getDefault().getActiveComponents();
        return collection != null && collection.size() == 1;
    }

    public boolean supportsDefaultValue() {
        if (this.propertyNames == null || this.propertyNames.isEmpty()) {
            return false;
        }
        final boolean[] blArray = new boolean[]{true};
        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                for (String string : DesignPropertyEditor.this.propertyNames) {
                    PropertyDescriptor propertyDescriptor = ((DesignComponent)DesignPropertyEditor.this.component.get()).getComponentDescriptor().getPropertyDescriptor(string);
                    if (propertyDescriptor.getDefaultValue().getKind() != PropertyValue.Kind.NULL || propertyDescriptor.isAllowNull()) continue;
                    blArray[0] = false;
                    break;
                }
            }
        });
        return blArray[0];
    }

    public Object getDefaultValue() {
        if (this.propertyNames == null || this.propertyNames.isEmpty()) {
            throw new IllegalStateException("Unable to obtain default value for this property without property name");
        }
        if (!(this.tempValue instanceof GroupValue)) {
            return this.readDefaultPropertyValue(this.propertyNames.iterator().next());
        }
        GroupValue groupValue = (GroupValue)this.tempValue;
        for (String string : groupValue.getPropertyNames()) {
            ((GroupValue)this.tempValue).putValue(string, this.readDefaultPropertyValue(string));
        }
        return groupValue;
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        propertyEnv.addVetoableChangeListener(new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                DesignPropertyEditor.this.customEditorOKButtonPressed();
            }
        });
    }

    public final void resolve(DesignComponent designComponent, List<String> list, Object object, PropertySupport propertySupport, String string) {
        this.component = new WeakReference<DesignComponent>(designComponent);
        this.propertyNames = list;
        this.tempValue = object;
        super.setValue(object);
        this.propertySupport = propertySupport;
        this.propertyDisplayName = string;
    }

    public final void resolveInplaceEditor(InplaceEditor inplaceEditor) {
        this.inplaceEditor = inplaceEditor;
    }

    public InplaceEditor getInplaceEditor() {
        return this.inplaceEditor;
    }

    public String getCustomEditorTitle() {
        if (this.component == null) {
            return null;
        }
        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                DesignDocument designDocument = ((DesignComponent)DesignPropertyEditor.this.component.get()).getDocument();
                if (((DesignComponent)DesignPropertyEditor.this.component.get()).getParentComponent() == null && designDocument.getRootComponent() != DesignPropertyEditor.this.component.get()) {
                    DesignPropertyEditor.this.customEditorTitle = null;
                    return;
                }
                DesignPropertyEditor.this.customEditorTitle = InfoPresenter.getDisplayName((DesignComponent)((DesignComponent)DesignPropertyEditor.this.component.get())) + " - " + DesignPropertyEditor.this.propertyDisplayName;
            }
        });
        return this.customEditorTitle;
    }

    public void init(DesignComponent designComponent) {
    }

    public void notifyDesignChanged(DesignEvent designEvent) {
    }

    public boolean isExecuteInsideWriteTransactionUsed() {
        return true;
    }

    public boolean executeInsideWriteTransaction() {
        return true;
    }

    public void customEditorOKButtonPressed() {
    }

    public boolean isResetToDefaultAutomatically() {
        return true;
    }

    public void customEditorResetToDefaultButtonPressed() {
    }

    public final void invokeSaveToModel() {
        try {
            this.propertySupport.setValue(this.getValue());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    private PropertyValue readDefaultPropertyValue(final String string) {
        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                DesignPropertyEditor.this.propertyValue = ((DesignComponent)DesignPropertyEditor.this.component.get()).getComponentDescriptor().getPropertyDescriptor(string).getDefaultValue();
            }
        });
        return this.propertyValue;
    }

    public String getPropertyDisplayName() {
        return this.propertyDisplayName;
    }

    public List<String> getPropertyNames() {
        return this.propertyNames;
    }
}

