/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.status;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.file.FileStatus;

public class StatusInformation
extends FileInfoContainer {
    private File file;
    private FileStatus status;
    private String workingRevision;
    private String repositoryRevision;
    private String repositoryFileName;
    private String stickyDate;
    private String stickyOptions;
    private String stickyTag;
    private List tags;
    private StringBuffer symNamesBuffer;

    public StatusInformation() {
        this.setAllExistingTags(null);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public FileStatus getStatus() {
        return this.status;
    }

    public void setStatus(FileStatus fileStatus) {
        this.status = fileStatus;
    }

    public String getStatusString() {
        if (this.status == null) {
            return null;
        }
        return this.status.toString();
    }

    public void setStatusString(String string) {
        this.setStatus(FileStatus.getStatusForString(string));
    }

    public String getWorkingRevision() {
        return this.workingRevision;
    }

    public void setWorkingRevision(String string) {
        this.workingRevision = string;
    }

    public String getRepositoryRevision() {
        return this.repositoryRevision;
    }

    public void setRepositoryRevision(String string) {
        this.repositoryRevision = string;
    }

    public String getRepositoryFileName() {
        return this.repositoryFileName;
    }

    public void setRepositoryFileName(String string) {
        this.repositoryFileName = string;
    }

    public String getStickyTag() {
        return this.stickyTag;
    }

    public void setStickyTag(String string) {
        this.stickyTag = string;
    }

    public String getStickyDate() {
        return this.stickyDate;
    }

    public void setStickyDate(String string) {
        this.stickyDate = string;
    }

    public String getStickyOptions() {
        return this.stickyOptions;
    }

    public void setStickyOptions(String string) {
        this.stickyOptions = string;
    }

    public void addExistingTag(String string, String string2) {
        if (this.symNamesBuffer == null) {
            this.symNamesBuffer = new StringBuffer();
        }
        this.symNamesBuffer.append(string);
        this.symNamesBuffer.append(" ");
        this.symNamesBuffer.append(string2);
        this.symNamesBuffer.append("\n");
    }

    private void createSymNames() {
        this.tags = new LinkedList();
        if (this.symNamesBuffer == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n < this.symNamesBuffer.length()) {
            while (n < this.symNamesBuffer.length() && this.symNamesBuffer.charAt(n) != '\n') {
                ++n;
            }
            if (n <= n2) continue;
            String string = this.symNamesBuffer.substring(n2, n);
            String string2 = string.substring(0, string.indexOf(32));
            String string3 = string.substring(string.indexOf(32) + 1);
            SymName symName = new SymName();
            symName.setTag(string2);
            symName.setRevision(string3);
            this.tags.add(symName);
            n2 = n + 1;
            ++n;
        }
        this.symNamesBuffer = null;
    }

    public List getAllExistingTags() {
        if (this.tags == null) {
            this.createSymNames();
        }
        return this.tags;
    }

    public void setAllExistingTags(List list) {
        this.tags = list;
    }

    public List getSymNamesForRevision(String string) {
        if (this.tags == null) {
            this.createSymNames();
        }
        LinkedList<SymName> linkedList = new LinkedList<SymName>();
        Iterator iterator = this.tags.iterator();
        while (iterator.hasNext()) {
            SymName symName = (SymName)iterator.next();
            if (!symName.getRevision().equals(string)) continue;
            linkedList.add(symName);
        }
        return linkedList;
    }

    public SymName getSymNameForTag(String string) {
        if (this.tags == null) {
            this.createSymNames();
        }
        Iterator iterator = this.tags.iterator();
        while (iterator.hasNext()) {
            SymName symName = (SymName)iterator.next();
            if (!symName.getTag().equals(string)) continue;
            return symName;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nFile: ");
        stringBuffer.append(this.file != null ? this.file.getAbsolutePath() : "null");
        stringBuffer.append("\nStatus is: ");
        stringBuffer.append(this.getStatusString());
        stringBuffer.append("\nWorking revision: ");
        stringBuffer.append(this.workingRevision);
        stringBuffer.append("\nRepository revision: ");
        stringBuffer.append("\nSticky date: ");
        stringBuffer.append(this.stickyDate);
        stringBuffer.append("\nSticky options: ");
        stringBuffer.append(this.stickyOptions);
        stringBuffer.append("\nSticky tag: ");
        stringBuffer.append(this.stickyTag);
        if (this.tags != null && this.tags.size() > 0) {
            stringBuffer.append("\nExisting Tags:");
            Iterator iterator = this.tags.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\n  ");
                stringBuffer.append(iterator.next().toString());
            }
        }
        return stringBuffer.toString();
    }

    public static class SymName {
        private String tag;
        private String revision;

        public String getTag() {
            return this.tag;
        }

        public void setTag(String string) {
            this.tag = string;
        }

        public void setRevision(String string) {
            this.revision = string;
        }

        public String getRevision() {
            return this.revision;
        }

        public String toString() {
            return this.getTag() + " : " + this.getRevision();
        }
    }
}

