/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby.api;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.derby.DbURLClassLoader;
import org.netbeans.modules.derby.DerbyOptions;
import org.netbeans.modules.derby.RegisterDerby;
import org.netbeans.modules.derby.Util;
import org.netbeans.modules.derby.spi.support.DerbySupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

public final class DerbyDatabases {
    private DerbyDatabases() {
    }

    public static boolean isDerbyRegistered() {
        return DerbySupport.getLocation().length() > 0 && DerbySupport.getSystemHome().length() > 0;
    }

    public static File getSystemHome() {
        String string = DerbyOptions.getDefault().getSystemHome();
        if (string.length() >= 0) {
            return new File(string);
        }
        return null;
    }

    public static boolean databaseExists(String string) {
        if (string == null) {
            throw new NullPointerException("The databaseName parameter cannot be null");
        }
        if ("".equals(string)) {
            return false;
        }
        String string2 = DerbySupport.getSystemHome();
        if (string2.length() <= 0) {
            return false;
        }
        File file = new File(string2, string);
        return file.exists();
    }

    public static String getFirstFreeDatabaseName(String string) {
        if (string == null) {
            throw new NullPointerException("The baseDatabaseName parameter cannot be null");
        }
        String string2 = DerbySupport.getSystemHome();
        if (string2.length() <= 0) {
            return string;
        }
        File file = new File(string2, string);
        if (!file.exists()) {
            return string;
        }
        for (int i = 1; i <= Integer.MAX_VALUE; ++i) {
            String string3 = string + String.valueOf(i);
            file = new File(string2, string3);
            if (file.exists()) continue;
            return string3;
        }
        return null;
    }

    public static int getFirstIllegalCharacter(String string) {
        if (string == null) {
            throw new NullPointerException("The databaseName parameter cannot be null");
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '/') {
                return c;
            }
            if (c != File.separatorChar) continue;
            return c;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseConnection createDatabase(String string, String string2, String string3) throws DatabaseException, IOException, IllegalStateException {
        if (string == null) {
            throw new NullPointerException("The databaseName parameter cannot be null");
        }
        DerbyDatabases.ensureSystemHome();
        if (!RegisterDerby.getDefault().ensureStarted(true)) {
            throw new DatabaseException("The Derby server did not start");
        }
        Driver driver = DerbyDatabases.loadDerbyNetDriver();
        Properties properties = new Properties();
        boolean bl = string2 != null && string2.length() >= 0;
        try {
            String string4 = "jdbc:derby://localhost:" + RegisterDerby.getDefault().getPort() + "/" + string;
            String string5 = string4 + ";create=true";
            Connection connection = driver.connect(string5, properties);
            try {
                if (bl) {
                    DerbyDatabases.setupDatabaseAuthentication(connection, string2, string3);
                }
            }
            finally {
                connection.close();
            }
            if (bl) {
                try {
                    connection = driver.connect(string4 + ";shutdown=true", properties);
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (SQLException sQLException) {
            DatabaseException databaseException = new DatabaseException(sQLException.getMessage());
            databaseException.initCause((Throwable)sQLException);
            throw databaseException;
        }
        return DerbyDatabases.registerDatabase(string, string2, bl ? string2.toUpperCase() : "APP", bl ? string3 : null, bl);
    }

    public static DatabaseConnection createSampleDatabase() throws DatabaseException, IOException, IllegalStateException {
        DerbyDatabases.extractSampleDatabase("sample");
        return DerbyDatabases.registerDatabase("sample", "app", "APP", "app", true);
    }

    public static DatabaseConnection createSampleDatabase(String string) throws DatabaseException, IOException {
        if (string == null) {
            throw new NullPointerException("The databaseName parameter cannot be null");
        }
        DerbyDatabases.extractSampleDatabase(string);
        return DerbyDatabases.registerDatabase(string, "app", "APP", "app", true);
    }

    static synchronized void extractSampleDatabase(String string) throws IOException {
        File file = DerbyDatabases.ensureSystemHome();
        File file2 = InstalledFileLocator.getDefault().locate("modules/ext/derbysampledb.zip", null, false);
        FileObject fileObject = FileUtil.toFileObject((File)file);
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 == null) {
            fileObject2 = fileObject.createFolder(string);
            Util.extractZip(file2, fileObject2);
        }
    }

    private static File ensureSystemHome() throws IOException {
        File file;
        String string = DerbySupport.getSystemHome();
        boolean bl = false;
        if (string.length() <= 0) {
            bl = true;
            string = DerbySupport.getDefaultSystemHome();
        }
        if (!((file = new File(string)).exists() || file.mkdirs() || file.exists())) {
            throw new IOException("Could not create the derby.system.home directory " + file);
        }
        if (bl) {
            DerbySupport.setSystemHome(string);
        }
        return file;
    }

    private static synchronized DatabaseConnection registerDatabase(String string, String string2, String string3, String string4, boolean bl) throws DatabaseException {
        JDBCDriver[] jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers("org.apache.derby.jdbc.ClientDriver");
        if (jDBCDriverArray.length == 0) {
            throw new IllegalStateException("The Java DB (Network) driver was not found");
        }
        DatabaseConnection databaseConnection = DatabaseConnection.create((JDBCDriver)jDBCDriverArray[0], (String)("jdbc:derby://localhost:" + RegisterDerby.getDefault().getPort() + "/" + string), (String)string2, (String)string3, (String)string4, (boolean)bl);
        if (ConnectionManager.getDefault().getConnection(databaseConnection.getName()) == null) {
            ConnectionManager.getDefault().addConnection(databaseConnection);
        }
        return databaseConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupDatabaseAuthentication(Connection connection, String string, String string2) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("{call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)}");
        try {
            preparedStatement.setString(1, "derby.connection.requireAuthentication");
            preparedStatement.setString(2, "true");
            preparedStatement.execute();
            preparedStatement.clearParameters();
            preparedStatement.setString(1, "derby.authentication.provider");
            preparedStatement.setString(2, "BUILTIN");
            preparedStatement.execute();
            preparedStatement.clearParameters();
            preparedStatement.setString(1, "derby.user." + string);
            preparedStatement.setString(2, string2);
            preparedStatement.execute();
        }
        finally {
            preparedStatement.close();
        }
    }

    private static Driver loadDerbyNetDriver() throws DatabaseException, IllegalStateException {
        Exception exception = null;
        try {
            File file = Util.getDerbyFile("lib/derbyclient.jar");
            if (file == null || !file.exists()) {
                throw new IllegalStateException("The Java DB (Network) driver was not found");
            }
            URL[] uRLArray = new URL[]{file.toURI().toURL()};
            DbURLClassLoader dbURLClassLoader = new DbURLClassLoader(uRLArray);
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.ClientDriver", true, dbURLClassLoader);
            return (Driver)clazz.newInstance();
        }
        catch (MalformedURLException malformedURLException) {
            exception = malformedURLException;
        }
        catch (IllegalAccessException illegalAccessException) {
            exception = illegalAccessException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            exception = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            exception = instantiationException;
        }
        if (exception != null) {
            DatabaseException databaseException = new DatabaseException(exception.getMessage());
            databaseException.initCause((Throwable)exception);
            throw databaseException;
        }
        return null;
    }
}

