/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.openide.util.NbPreferences;

public class BugtrackingConfig {
    private static BugtrackingConfig instance = null;
    private static final String ARCHIVED_TTL_KEY = "bugtracking.archived_time_to_live";
    private static final String COLUMN_WIDTH_PREFIX = "bugtracking.issuetable.columnwidth";
    private static long DEFAULT_ARCHIVED_TTL = 7L;

    private BugtrackingConfig() {
    }

    public static BugtrackingConfig getInstance() {
        if (instance == null) {
            instance = new BugtrackingConfig();
        }
        return instance;
    }

    public Preferences getPreferences() {
        return NbPreferences.forModule(BugtrackingConfig.class);
    }

    public void setArchivedIssuesTTL(int n) {
        this.getPreferences().putLong(ARCHIVED_TTL_KEY, n);
    }

    public long getArchivedIssuesTTL() {
        return this.getPreferences().getLong(ARCHIVED_TTL_KEY, DEFAULT_ARCHIVED_TTL);
    }

    public void storeColumnWidths(String string, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.getPreferences().putInt("bugtracking.issuetable.columnwidth." + string + "." + i, nArray[i]);
        }
    }

    public int[] getColumnWidths(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        try {
            String[] stringArray = this.getPreferences().keys();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2 == null || !string2.startsWith("bugtracking.issuetable.columnwidth." + string + ".")) continue;
                int n = Integer.parseInt(string2.substring(string2.lastIndexOf(46) + 1));
                int n2 = this.getPreferences().getInt(string2, -1);
                arrayList.add(n, n2);
            }
            int[] nArray = new int[arrayList.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = (Integer)arrayList.get(i);
            }
            return nArray;
        }
        catch (Exception exception) {
            BugtrackingManager.LOG.log(Level.INFO, null, exception);
            return new int[0];
        }
    }
}

