/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasklist;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.IssueProvider;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingOwnerSupport;
import org.netbeans.spi.tasklist.PushTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TaskListProvider
extends PushTaskScanner {
    private static TaskListProvider instance;
    private PushTaskScanner.Callback callback;
    private TaskScanningScope scope;
    private WeakReference<TaskScanningScope> lastScope = new WeakReference<Object>(null);
    private static final Object SCOPE_LOCK;
    private static final String TASK_GROUP_NAME = "nb-tasklist-issue";
    private static final String TC_TASKLIST_ID = "TaskListTopComponent";
    private final WeakHashMap<IssueProvider.LazyIssue, Task> cachedTasks;
    private final WeakHashMap<IssueProvider, Set<IssueProvider.LazyIssue>> cachedIssues;
    private final WeakSet<IssueProvider.LazyIssue> validatedIssues;
    private final HashSet<IssueProvider> providersToValidate;
    private boolean providersInitialized;
    public static final Logger LOG;
    private final RequestProcessor.Task refreshTask = new RequestProcessor("IssuesToTaskListProvider", 1, true).create((Runnable)new RefreshTask());

    private TaskListProvider() {
        super(NbBundle.getMessage(TaskListProvider.class, (String)"LBL_TaskListProvider_DisplayName"), NbBundle.getMessage(TaskListProvider.class, (String)"LBL_TaskListProvider_Description"), null);
        this.cachedTasks = new WeakHashMap(10);
        this.cachedIssues = new WeakHashMap(5);
        this.providersToValidate = new HashSet(5);
        this.validatedIssues = new WeakSet(10);
    }

    public static synchronized TaskListProvider getInstance() {
        if (instance == null) {
            instance = new TaskListProvider();
            instance.refreshTasks(true);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScope(TaskScanningScope taskScanningScope, PushTaskScanner.Callback callback) {
        Object object = SCOPE_LOCK;
        synchronized (object) {
            if (!this.providersInitialized) {
                for (IssueProvider issueProvider : Lookup.getDefault().lookupAll(IssueProvider.class)) {
                    LOG.finer("TaskListProvider.setScope: waking up " + issueProvider.getClass().getName());
                }
                this.providersInitialized = true;
            }
            this.callback = callback;
            this.scope = taskScanningScope;
            this.lastScope.clear();
        }
        this.refreshTasks(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IssueProvider issueProvider, boolean bl, IssueProvider.LazyIssue ... lazyIssueArray) {
        if (issueProvider == null || lazyIssueArray == null || lazyIssueArray.length == 0) {
            LOG.fine("TaskListProvider.add: provider: " + issueProvider + ", issuesToAdd: " + lazyIssueArray);
            return;
        }
        LOG.fine("TaskListProvider.add: adding " + lazyIssueArray.length + " for " + issueProvider + ", request to open: " + bl);
        WeakHashMap<IssueProvider, Set<IssueProvider.LazyIssue>> weakHashMap = this.cachedIssues;
        synchronized (weakHashMap) {
            Set<IssueProvider.LazyIssue> set = this.cachedIssues.get(issueProvider);
            if (set == null) {
                set = new HashSet<IssueProvider.LazyIssue>(5);
            }
            for (IssueProvider.LazyIssue lazyIssue : lazyIssueArray) {
                set.add(lazyIssue);
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("TaskListProvider.add: issues for " + issueProvider + ": " + set);
            }
            this.cachedIssues.put(issueProvider, set);
            this.providersToValidate.add(issueProvider);
        }
        if (bl) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("TaskListProvider.add: openning tasklist TC");
                    }
                    TopComponent topComponent = WindowManager.getDefault().findTopComponent(TaskListProvider.TC_TASKLIST_ID);
                    topComponent.open();
                    topComponent.requestVisible();
                }
            });
        }
        this.refreshTasks(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(IssueProvider issueProvider, IssueProvider.LazyIssue ... lazyIssueArray) {
        if (issueProvider == null || lazyIssueArray == null || lazyIssueArray.length == 0) {
            LOG.fine("TaskListProvider.remove: provider: " + issueProvider + ", issuesToRemove: " + lazyIssueArray);
            return;
        }
        LOG.fine("TaskListProvider.remove: removing " + lazyIssueArray.length + " for " + issueProvider);
        WeakHashMap<IssueProvider, Set<IssueProvider.LazyIssue>> weakHashMap = this.cachedIssues;
        synchronized (weakHashMap) {
            Set<IssueProvider.LazyIssue> set = this.cachedIssues.get(issueProvider);
            if (set != null) {
                for (IssueProvider.LazyIssue lazyIssue : lazyIssueArray) {
                    set.remove(lazyIssue);
                }
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("TaskListProvider.remove: issues for " + issueProvider + ": " + (set == null ? "empty" : set));
            }
        }
        this.removeCachedTasks(lazyIssueArray);
        this.refreshTasks(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(IssueProvider issueProvider) {
        Set<IssueProvider.LazyIssue> set;
        if (issueProvider == null) {
            LOG.fine("TaskListProvider.removeAll: provider is null");
            return;
        }
        LOG.fine("TaskListProvider.removeAll: provider is null");
        WeakHashMap<IssueProvider, Set<IssueProvider.LazyIssue>> weakHashMap = this.cachedIssues;
        synchronized (weakHashMap) {
            set = this.cachedIssues.remove(issueProvider);
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("TaskListProvider.removeAll: issues for " + issueProvider + ": " + (this.cachedIssues.get(issueProvider) == null ? "empty" : this.cachedIssues.get(issueProvider)));
            }
        }
        if (set != null) {
            this.removeCachedTasks(set.toArray(new IssueProvider.LazyIssue[set.size()]));
        }
        this.refreshTasks(false);
    }

    public void refresh() {
        this.refreshTasks(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCachedTasks(IssueProvider.LazyIssue ... lazyIssueArray) {
        WeakHashMap<IssueProvider.LazyIssue, Task> weakHashMap = this.cachedTasks;
        synchronized (weakHashMap) {
            for (IssueProvider.LazyIssue lazyIssue : lazyIssueArray) {
                this.cachedTasks.remove(lazyIssue);
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("TaskListProvider.removeCachedTasks: cached tasks: " + this.cachedTasks);
            }
        }
    }

    private Task createTask(final IssueProvider.LazyIssue lazyIssue, final WeakReference<IssueProvider> weakReference) {
        LinkedList<Action> linkedList = new LinkedList<Action>();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        Issue issue = lazyIssue.getIssue();
                        if (issue != null) {
                            LOG.log(Level.FINER, "TaskListProvider: openning issue {0}", lazyIssue.getName());
                            issue.open();
                        } else {
                            LOG.log(Level.FINE, "null issue returned for {0}", lazyIssue.getName());
                        }
                    }
                });
            }
        };
        linkedList.add(new AbstractAction(NbBundle.getMessage(TaskListProvider.class, (String)"TaskListProvider.Action.remove.name")){

            public void actionPerformed(ActionEvent actionEvent) {
                IssueProvider issueProvider = (IssueProvider)weakReference.get();
                if (issueProvider != null) {
                    LOG.log(Level.FINE, "TaskListProvider: removing issue {0}", lazyIssue.getName());
                    TaskListProvider.this.remove(issueProvider, lazyIssue);
                    issueProvider.removed(lazyIssue);
                }
            }
        });
        List<? extends Action> list = lazyIssue.getActions();
        if (list != null) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "TaskListProvider.createTask: provided actions {0}", list);
            }
            for (Action action : list) {
                if (action == null) continue;
                linkedList.add(action);
            }
        }
        Task task = Task.create((URL)lazyIssue.getUrl(), (String)TASK_GROUP_NAME, (String)lazyIssue.getName(), (ActionListener)actionListener, (Action[])linkedList.toArray(new AbstractAction[linkedList.size()]));
        this.cachedTasks.put(lazyIssue, task);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("TaskListProvider.createTasks: cached tasks: " + this.cachedTasks);
        }
        lazyIssue.setValid(true);
        return task;
    }

    private void refreshTasks(boolean bl) {
        LOG.finer("TaskListProvider.refreshTasks: cancel=" + bl);
        if (bl) {
            this.refreshTask.cancel();
        }
        this.refreshTask.schedule(200);
    }

    private List<String> getRepositoriesFor(TaskScanningScope taskScanningScope) {
        Collection collection = taskScanningScope.getLookup().lookupAll(Project.class);
        LinkedList<String> linkedList = new LinkedList<String>();
        if (!collection.isEmpty()) {
            for (Project project : collection) {
                if (Thread.interrupted()) {
                    return null;
                }
                long l = 0L;
                if (LOG.isLoggable(Level.FINER)) {
                    l = System.currentTimeMillis();
                }
                Repository repository = BugtrackingOwnerSupport.getInstance().getRepository(project, false);
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "getRepositoriesFor: repository: {0} for {1} after {2}", new Object[]{repository, project, System.currentTimeMillis() - l});
                }
                if (repository == null) continue;
                linkedList.add(repository.getUrl());
            }
        }
        return linkedList;
    }

    private boolean isIssueFromRepository(IssueProvider.LazyIssue lazyIssue, Collection<String> collection, Collection<String> collection2) {
        String string = lazyIssue.getRepositoryUrl();
        boolean bl = false;
        if (string != null) {
            for (String string2 : collection) {
                if (!string.equals(string2)) continue;
                LOG.log(Level.FINE, "isIssueFromRepository: issue {0} under an allowed repository", lazyIssue);
                bl = true;
                break;
            }
            if (!bl && !collection2.contains(string)) {
                LOG.log(Level.FINE, "isIssueFromRepository: issue {0} under a unassociated repository", lazyIssue);
                bl = true;
            }
        }
        return bl;
    }

    static {
        SCOPE_LOCK = new Object();
        LOG = Logger.getLogger("org.netbeans.modules.bugtracking.tasklist");
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Collection<String> collection;
            boolean bl;
            PushTaskScanner.Callback callback;
            TaskScanningScope taskScanningScope;
            if (Thread.interrupted()) {
                return;
            }
            HashMap<IssueProvider.LazyIssue, Object> hashMap = SCOPE_LOCK;
            synchronized (hashMap) {
                taskScanningScope = TaskListProvider.this.scope;
                callback = TaskListProvider.this.callback;
                boolean bl2 = bl = taskScanningScope != TaskListProvider.this.lastScope.get();
                if (bl) {
                    LOG.finer("RefreshTask.run: scope has changed, running the full scan.");
                }
            }
            if (callback == null || taskScanningScope == null) {
                return;
            }
            hashMap = new HashMap<IssueProvider.LazyIssue, Object>();
            HashMap hashMap2 = new HashMap();
            Object object2 = TaskListProvider.this.cachedIssues;
            synchronized (object2) {
                if (bl) {
                    TaskListProvider.this.providersToValidate.addAll(TaskListProvider.this.cachedIssues.keySet());
                }
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "RefreshTask.run: providers to validate: {0}", TaskListProvider.this.providersToValidate);
                }
                for (Map.Entry object3 : TaskListProvider.this.cachedIssues.entrySet()) {
                    if (TaskListProvider.this.providersToValidate.contains(object3.getKey())) {
                        for (IssueProvider.LazyIssue lazyIssue : (Set)object3.getValue()) {
                            hashMap2.put(lazyIssue, object3.getKey());
                        }
                        continue;
                    }
                    for (IssueProvider.LazyIssue lazyIssue : (Set)object3.getValue()) {
                        if (TaskListProvider.this.validatedIssues.contains((Object)lazyIssue)) {
                            hashMap.put(lazyIssue, object3.getKey());
                            continue;
                        }
                        hashMap2.put(lazyIssue, object3.getKey());
                    }
                }
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "RefreshTask.run: issues to validate: {0}", hashMap2);
                }
            }
            if (!hashMap2.isEmpty() && (object2 = TaskListProvider.this.getRepositoriesFor(taskScanningScope)) != null) {
                collection = BugtrackingOwnerSupport.getInstance().getAllAssociatedUrls();
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "RefreshTask.run: all associated repositories: {0}", collection);
                }
                for (Map.Entry entry : hashMap2.entrySet()) {
                    if (TaskListProvider.this.isIssueFromRepository((IssueProvider.LazyIssue)entry.getKey(), (Collection)object2, collection)) {
                        if (LOG.isLoggable(Level.FINER)) {
                            LOG.log(Level.FINER, "RefreshTask.run: issue {0} is valid under current scope", ((IssueProvider.LazyIssue)entry.getKey()).getName());
                        }
                        hashMap.put((IssueProvider.LazyIssue)entry.getKey(), entry.getValue());
                        continue;
                    }
                    if (!LOG.isLoggable(Level.FINER)) continue;
                    LOG.log(Level.FINER, "RefreshTask.run: issue {0} is invalid under current scope", ((IssueProvider.LazyIssue)entry.getKey()).getName());
                }
            }
            collection = new LinkedList();
            for (Map.Entry entry : hashMap.entrySet()) {
                Task task;
                IssueProvider.LazyIssue lazyIssue;
                lazyIssue = (IssueProvider.LazyIssue)entry.getKey();
                WeakHashMap weakHashMap = TaskListProvider.this.cachedTasks;
                synchronized (weakHashMap) {
                    task = (Task)TaskListProvider.this.cachedTasks.get(lazyIssue);
                    if (task == null || !lazyIssue.isValid()) {
                        task = TaskListProvider.this.createTask(lazyIssue, new WeakReference(entry.getValue()));
                    }
                }
                ((LinkedList)collection).add((String)task);
            }
            if (Thread.interrupted()) {
                return;
            }
            WeakHashMap weakHashMap = TaskListProvider.this.cachedIssues;
            synchronized (weakHashMap) {
                TaskListProvider.this.providersToValidate.clear();
                TaskListProvider.this.validatedIssues.clear();
                TaskListProvider.this.validatedIssues.addAll(hashMap.keySet());
            }
            callback.setTasks(collection);
            TaskListProvider.this.lastScope = new WeakReference<TaskScanningScope>(taskScanningScope);
        }
    }
}

