/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.issue;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.RepositoriesSupport;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.issue.IssueAccessor;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.netbeans.modules.bugtracking.util.RepositoryComboRenderer;
import org.netbeans.modules.bugtracking.util.RepositoryComboSupport;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public final class IssueTopComponent
extends TopComponent
implements PropertyChangeListener {
    private static Set<IssueTopComponent> openIssues = new HashSet<IssueTopComponent>();
    private Issue issue;
    private RequestProcessor rp = new RequestProcessor("Bugtracking issue", 1, true);
    private RequestProcessor.Task prepareTask;
    private RepositoryComboSupport rs;
    private Node[] context;
    private BugtrackingController controller;
    private JLabel findIssuesLabel;
    private JPanel issuePanel;
    private JPanel jPanel1;
    private LinkButton newButton;
    private JLabel preparingLabel;
    private JLabel repoLabel;
    private JPanel repoPanel;
    private JComboBox repositoryComboBox;

    public IssueTopComponent() {
        this.initComponents();
        RepositoriesSupport.getInstance().addPropertyChangeListener(this);
        this.preparingLabel.setVisible(false);
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IssueTopComponent.this.onNewClick();
            }
        });
    }

    public Issue getIssue() {
        return this.issue;
    }

    public void initNewIssue(Repository repository, Node[] nodeArray) {
        this.initNewIssue(repository, false, nodeArray);
    }

    public void initNewIssue(Repository repository, boolean bl, Node[] nodeArray) {
        BugtrackingUtil.logBugtrackingUsage(repository, "ISSUE_EDIT");
        this.context = nodeArray;
        Font font = new JLabel().getFont();
        int n = font.getSize();
        this.findIssuesLabel.setFont(this.repoLabel.getFont().deriveFont((float)n * 1.7f));
        if (repository != null && !bl) {
            DefaultComboBoxModel<Repository> defaultComboBoxModel = new DefaultComboBoxModel<Repository>();
            defaultComboBoxModel.addElement(repository);
            this.repositoryComboBox.setModel(defaultComboBoxModel);
            this.repositoryComboBox.setRenderer(new RepositoryComboRenderer());
            this.repositoryComboBox.setSelectedItem(repository);
            this.repositoryComboBox.setEnabled(false);
            this.newButton.setEnabled(false);
            this.onRepoSelected();
        } else {
            this.rs = repository == null ? RepositoryComboSupport.setup((JComponent)((Object)this), this.repositoryComboBox, false) : RepositoryComboSupport.setup((JComponent)((Object)this), this.repositoryComboBox, repository);
        }
        this.repositoryComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    IssueTopComponent.this.onRepoSelected();
                }
            }
        });
        this.setNameAndTooltip();
    }

    public void initNoIssue(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IssueTopComponent.this.preparingLabel.setVisible(true);
                IssueTopComponent.this.repoPanel.setVisible(false);
                if (string != null) {
                    String string2 = NbBundle.getMessage(Issue.class, (String)"LBL_OPENING_ISSUE", (Object[])new Object[]{string});
                    IssueTopComponent.this.preparingLabel.setText(string2);
                    IssueTopComponent.this.setName(NbBundle.getMessage(IssueTopComponent.class, (String)"LBL_LOADING_ISSUE", (Object[])new Object[]{string}));
                    IssueTopComponent.this.setToolTipText(string2);
                } else {
                    IssueTopComponent.this.setNameAndTooltip();
                }
            }
        });
    }

    public void setIssue(Issue issue) {
        assert (this.issue == null);
        BugtrackingUtil.logBugtrackingUsage(issue.getRepository(), "ISSUE_EDIT");
        this.issue = issue;
        this.preparingLabel.setVisible(false);
        this.issuePanel.add((Component)issue.getController().getComponent(), "Center");
        this.repoPanel.setVisible(false);
        this.setNameAndTooltip();
        issue.addPropertyChangeListener(this);
    }

    private void initComponents() {
        this.repoPanel = new JPanel();
        this.repositoryComboBox = new JComboBox();
        this.findIssuesLabel = new JLabel();
        this.repoLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.newButton = new LinkButton();
        this.issuePanel = new JPanel();
        this.preparingLabel = new JLabel();
        this.repoPanel.setBackground(UIManager.getDefaults().getColor("EditorPane.background"));
        Mnemonics.setLocalizedText((JLabel)this.findIssuesLabel, (String)NbBundle.getMessage(IssueTopComponent.class, (String)"IssueTopComponent.findIssuesLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.repoLabel, (String)NbBundle.getMessage(IssueTopComponent.class, (String)"IssueTopComponent.repoLabel.text"));
        this.repoLabel.setFocusCycleRoot(true);
        this.jPanel1.setOpaque(false);
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 64, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 8, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.newButton, (String)NbBundle.getMessage(IssueTopComponent.class, (String)"IssueTopComponent.newButton.text"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.repoPanel);
        this.repoPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.repoLabel).addPreferredGap(0).add((Component)this.repositoryComboBox, -2, 225, -2).addPreferredGap(0).add((Component)this.newButton, -2, -1, -2)).add((Component)this.findIssuesLabel)).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addContainerGap(152, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(50, 50, 50).add((Component)this.jPanel1, -2, -1, -2)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.findIssuesLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.repoLabel).add((Component)this.repositoryComboBox, -2, -1, -2).add((Component)this.newButton, -2, -1, -2))));
        this.issuePanel.setBackground(UIManager.getDefaults().getColor("EditorPane.background"));
        this.issuePanel.setLayout(new BorderLayout());
        this.preparingLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.preparingLabel, (String)NbBundle.getMessage(IssueTopComponent.class, (String)"IssueTopComponent.preparingLabel.text"));
        this.issuePanel.add((Component)this.preparingLabel, "Center");
        GroupLayout groupLayout3 = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.repoPanel, -1, -1, Short.MAX_VALUE).add((Component)this.issuePanel, -1, 598, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.repoPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.issuePanel, -1, 174, Short.MAX_VALUE)));
    }

    private void onNewClick() {
        Repository repository = BugtrackingUtil.createRepository();
        if (repository != null) {
            this.repositoryComboBox.addItem(repository);
            this.repositoryComboBox.setSelectedItem(repository);
        }
    }

    private void onRepoSelected() {
        if (this.prepareTask != null) {
            this.prepareTask.cancel();
        }
        Cancellable cancellable = new Cancellable(){

            public boolean cancel() {
                if (IssueTopComponent.this.prepareTask != null) {
                    IssueTopComponent.this.prepareTask.cancel();
                }
                return true;
            }
        };
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(IssueTopComponent.class, (String)"CTL_PreparingIssue"), (Cancellable)cancellable);
        this.prepareTask = this.rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    progressHandle.start();
                    IssueTopComponent.this.preparingLabel.setVisible(true);
                    Repository repository = IssueTopComponent.this.getRepository();
                    if (repository == null) {
                        return;
                    }
                    if (IssueTopComponent.this.issue != null) {
                        if (IssueTopComponent.this.controller != null) {
                            IssueTopComponent.this.issuePanel.remove(IssueTopComponent.this.controller.getComponent());
                        }
                        IssueTopComponent.this.issue.removePropertyChangeListener(IssueTopComponent.this);
                    }
                    IssueTopComponent.this.issue = repository.createIssue();
                    if (IssueTopComponent.this.issue == null) {
                        return;
                    }
                    IssueAccessor.getInstance().setSelection(IssueTopComponent.this.issue, IssueTopComponent.this.context);
                    IssueTopComponent.this.controller = IssueTopComponent.this.issue.getController();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            IssueTopComponent.this.issuePanel.add((Component)IssueTopComponent.this.controller.getComponent(), "Center");
                            IssueTopComponent.this.issue.addPropertyChangeListener(IssueTopComponent.this);
                            IssueTopComponent.this.revalidate();
                            IssueTopComponent.this.repaint();
                            IssueTopComponent.this.focusFirstEnabledComponent();
                        }
                    });
                }
                finally {
                    IssueTopComponent.this.preparingLabel.setVisible(false);
                    progressHandle.finish();
                    IssueTopComponent.this.prepareTask = null;
                }
            }
        });
    }

    private Repository getRepository() {
        Object object = this.repositoryComboBox.getSelectedItem();
        if (object == null || !(object instanceof Repository)) {
            return null;
        }
        return (Repository)object;
    }

    private void focusFirstEnabledComponent() {
        this.repositoryComboBox.requestFocusInWindow();
        if (!this.repositoryComboBox.isEnabled()) {
            this.newButton.requestFocusInWindow();
            if (!this.newButton.isEnabled()) {
                this.newButton.transferFocus();
            }
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentOpened() {
        openIssues.add(this);
        if (this.issue != null) {
            this.issue.getController().opened();
        }
        BugtrackingManager.LOG.fine("IssueTopComponent Opened " + (this.issue != null ? this.issue.getID() : "null"));
    }

    public void componentClosed() {
        openIssues.remove(this);
        if (this.issue != null) {
            this.issue.removePropertyChangeListener(this);
            this.issue.getController().closed();
        }
        if (this.prepareTask != null) {
            this.prepareTask.cancel();
        }
        BugtrackingManager.LOG.fine("IssueTopComponent Closed " + (this.issue != null ? this.issue.getID() : "null"));
    }

    public static synchronized IssueTopComponent find(Issue issue) {
        return IssueTopComponent.find(issue, true);
    }

    public static synchronized IssueTopComponent find(Issue issue, boolean bl) {
        for (IssueTopComponent issueTopComponent : openIssues) {
            if (!issue.equals(issueTopComponent.getIssue())) continue;
            return issueTopComponent;
        }
        if (!bl) {
            return null;
        }
        IssueTopComponent issueTopComponent = new IssueTopComponent();
        issueTopComponent.setIssue(issue);
        return issueTopComponent;
    }

    public static synchronized IssueTopComponent find(String string) {
        assert (string != null);
        for (IssueTopComponent issueTopComponent : openIssues) {
            Issue issue = issueTopComponent.getIssue();
            if (issue == null || !string.equals(issue.getID())) continue;
            return issueTopComponent;
        }
        IssueTopComponent issueTopComponent = new IssueTopComponent();
        return issueTopComponent;
    }

    private void setNameAndTooltip() throws MissingResourceException {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (IssueTopComponent.this.issue != null) {
                    IssueTopComponent.this.setName(IssueTopComponent.this.issue.getShortenedDisplayName());
                    IssueTopComponent.this.setToolTipText(IssueTopComponent.this.issue.getTooltip());
                } else {
                    IssueTopComponent.this.setName(NbBundle.getMessage(IssueTopComponent.class, (String)"CTL_IssueTopComponent"));
                    IssueTopComponent.this.setToolTipText(NbBundle.getMessage(IssueTopComponent.class, (String)"CTL_IssueTopComponent"));
                }
            }
        });
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("issue.data_changed")) {
            this.repoPanel.setVisible(false);
            this.setNameAndTooltip();
        } else if (propertyChangeEvent.getPropertyName().equals("bugtracking.repositories.changed")) {
            if (!this.repositoryComboBox.isEnabled()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (IssueTopComponent.this.rs != null) {
                        IssueTopComponent.this.rs.refreshRepositoryModel();
                    }
                }
            });
        }
    }

    public boolean requestFocusInWindow() {
        if (this.issue == null) {
            return this.repositoryComboBox.requestFocusInWindow();
        }
        return this.issue.getController().getComponent().requestFocusInWindow();
    }
}

