/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.issue;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class PatchContextChooser
extends JPanel
implements ExplorerManager.Provider {
    private ExplorerManager manager;
    private JButton locationButton;
    private JTextField locationField;
    private JLabel locationLabel;
    private BeanTreeView projectsView;
    private JLabel titleLabel;

    public PatchContextChooser() {
        this.initComponents();
        this.projectsView.setPopupAllowed(false);
        this.projectsView.setRootVisible(false);
        this.projectsView.setSelectionMode(1);
        this.manager = new ExplorerManager();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (Project project : OpenProjects.getDefault().getOpenProjects()) {
            LogicalViewProvider logicalViewProvider = (LogicalViewProvider)project.getLookup().lookup(LogicalViewProvider.class);
            if (logicalViewProvider == null) continue;
            Node node = logicalViewProvider.createLogicalView();
            linkedList.add(node);
        }
        Children.Array array = new Children.Array();
        array.add(linkedList.toArray(new Node[linkedList.size()]));
        AbstractNode abstractNode = new AbstractNode((Children)array);
        this.manager.setRootContext((Node)abstractNode);
        this.manager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                    Project project;
                    Lookup lookup;
                    DataObject dataObject;
                    Node[] nodeArray = PatchContextChooser.this.manager.getSelectedNodes();
                    FileObject fileObject = null;
                    if (nodeArray.length != 0 && (fileObject = (dataObject = (DataObject)(lookup = nodeArray[0].getLookup()).lookup(DataObject.class)) != null ? dataObject.getPrimaryFile() : (FileObject)lookup.lookup(FileObject.class)) == null && (project = (Project)lookup.lookup(Project.class)) != null) {
                        fileObject = project.getProjectDirectory();
                    }
                    PatchContextChooser.this.locationField.setText(fileObject == null ? "" : FileUtil.getFileDisplayName(fileObject));
                }
            }
        });
    }

    private void initComponents() {
        this.projectsView = new BeanTreeView();
        this.titleLabel = new JLabel();
        this.locationLabel = new JLabel();
        this.locationField = new JTextField();
        this.locationButton = new JButton();
        this.titleLabel.setText(NbBundle.getMessage(PatchContextChooser.class, (String)"PatchContextChooser.titleLabel.text"));
        this.locationLabel.setText(NbBundle.getMessage(PatchContextChooser.class, (String)"PatchContextChooser.locationLabel.text"));
        this.locationButton.setText(NbBundle.getMessage(PatchContextChooser.class, (String)"PatchContextChooser.locationButton.text"));
        this.locationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PatchContextChooser.this.locationButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectsView, -1, -1, Short.MAX_VALUE).add((Component)this.titleLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.locationLabel).addPreferredGap(0).add((Component)this.locationField, -1, 254, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.locationButton))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.titleLabel).addPreferredGap(0).add((Component)this.projectsView, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.locationLabel).add((Component)this.locationField, -2, -1, -2).add((Component)this.locationButton))));
    }

    private void locationButtonActionPerformed(ActionEvent actionEvent) {
        FileChooserBuilder fileChooserBuilder = new FileChooserBuilder(PatchContextChooser.class);
        File file = fileChooserBuilder.setApproveText(NbBundle.getMessage(PatchContextChooser.class, (String)"LBL_SELECT")).showOpenDialog();
        if (file != null) {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            this.locationField.setText(FileUtil.getFileDisplayName((FileObject)fileObject));
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public File getSelectedFile() {
        File file = null;
        String string = this.locationField.getText().trim();
        if (!"".equals(string) && !(file = new File(string)).exists()) {
            file = null;
        }
        return file;
    }
}

