/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.preview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.netbeans.modules.vmd.game.model.SequenceListener;
import org.netbeans.modules.vmd.game.model.StaticTile;
import org.netbeans.modules.vmd.game.preview.SequenceTimeSpinner;
import org.netbeans.modules.vmd.game.view.ImagePreviewComponent;

public class SequencePreviewPanelSidebar
extends JPanel
implements SequenceListener,
ComponentListener,
PropertyChangeListener,
ActionListener {
    public static final boolean DEBUG = false;
    private boolean isPlaying;
    private boolean isPlayingForward = true;
    private int sequenceIndex;
    private Sequence sequence;
    private Timer timer;
    private ImagePreviewComponent imagePreview = new ImagePreviewComponent(false, true, false);
    private JButton buttonDirection;
    private JButton buttonPause;
    public JPanel jPanel1;
    public JPanel jPanel2;
    public JLabel labelName;
    private JPanel panelSequenceAnimatedPreview;
    public JPanel spinnerPanel;

    public SequencePreviewPanelSidebar(Sequence sequence) {
        this.initComponents();
        this.addComponentListener(this);
        this.setSequence(sequence);
    }

    private Dimension getFrameSize() {
        if (this.sequence == null) {
            return new Dimension(10, 10);
        }
        return this.sequence.getFrameSize();
    }

    public void setImportant(boolean bl) {
        if (bl) {
            this.labelName.setFont(this.labelName.getFont().deriveFont(1));
        } else {
            this.labelName.setFont(this.labelName.getFont().deriveFont(0));
        }
    }

    public void setSequence(Sequence sequence) {
        if (this.sequence != null) {
            this.sequence.removeSequenceListener(this);
            this.sequence.removePropertyChangeListener(this);
            this.timer.cancel();
            int n = sequence.getFrameCount() - 1;
        }
        this.sequence = sequence;
        this.labelName.setText(this.sequence.getName());
        this.spinnerPanel.add((Component)new SequenceTimeSpinner(this.sequence), "Center");
        this.timer = new Timer();
        StaticTile staticTile = this.sequence.getFrame(0);
        this.imagePreview.setPreviewable(staticTile);
        this.sequence.addSequenceListener(this);
        this.timer.schedule((TimerTask)new AnimationTimerTask(), 0L, (long)this.sequence.getFrameMs());
        this.sequence.addPropertyChangeListener(this);
    }

    public void requestPreviewFrame(int n) {
        if (!this.isPlaying && this.sequence.getFrame(n) != null) {
            this.imagePreview.setPreviewable(this.sequence.getFrame(n));
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.buttonPause = new JButton();
        this.buttonDirection = new JButton();
        this.panelSequenceAnimatedPreview = new JPanel();
        this.jPanel2 = new JPanel();
        this.labelName = new JLabel();
        this.spinnerPanel = new JPanel();
        this.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.buttonPause.setText(">");
        this.buttonPause.addActionListener(this);
        this.buttonDirection.setText("<>");
        this.buttonDirection.addActionListener(this);
        this.panelSequenceAnimatedPreview.setLayout(new BorderLayout(10, 10));
        this.panelSequenceAnimatedPreview.setBackground(new Color(255, 255, 255));
        this.panelSequenceAnimatedPreview.setMinimumSize(this.getFrameSize());
        this.panelSequenceAnimatedPreview.add(this.imagePreview);
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.buttonDirection, -1, -1, Short.MAX_VALUE).add((Component)this.buttonPause, -1, 69, Short.MAX_VALUE)).add(18, 18, 18).add((Component)this.panelSequenceAnimatedPreview, -1, 78, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.panelSequenceAnimatedPreview, -1, 56, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.buttonPause).addPreferredGap(0).add((Component)this.buttonDirection))).addContainerGap()));
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.labelName.setText("<None>");
        this.spinnerPanel.setLayout(new BorderLayout());
        this.spinnerPanel.setBackground(new Color(255, 255, 255));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.labelName, -1, 79, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.spinnerPanel, -2, 74, -2).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.labelName).add((Component)this.spinnerPanel, -1, 15, Short.MAX_VALUE)).add(12, 12, 12)));
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void sequenceChanged() {
        this.setSequence(this.sequence);
    }

    private void switchPlayDirection() {
        this.isPlayingForward = !this.isPlayingForward;
        this.setPlaying(true);
    }

    private void setPlaying(boolean bl) {
        if (bl) {
            if (this.isPlayingForward) {
                this.buttonPause.setText(">||");
            } else {
                this.buttonPause.setText("||<");
            }
        } else if (this.isPlayingForward) {
            this.buttonPause.setText(">");
        } else {
            this.buttonPause.setText("<");
        }
        this.isPlaying = bl;
    }

    private void incrementSequenceIndex() {
        int n = this.sequenceIndex + 1;
        this.sequenceIndex = n >= this.sequence.getFrameCount() ? 0 : n;
    }

    private void decrementSequenceIndex() {
        int n = this.sequenceIndex - 1;
        this.sequenceIndex = n < 0 ? this.sequence.getFrameCount() - 1 : n;
    }

    private void currentFrameChanged() {
    }

    private void setCurrentFrameIndex(int n) {
        StaticTile staticTile = null;
        do {
            try {
                staticTile = this.sequence.getFrame(n);
            }
            catch (Exception exception) {
                --n;
            }
        } while (staticTile == null);
        this.sequenceIndex = n;
        this.imagePreview.setPreviewable(staticTile);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.sequence) {
            if (propertyChangeEvent.getPropertyName().equals("sequence.prop.frames.ms")) {
                this.timer.cancel();
                this.timer = new Timer();
                this.timer.schedule((TimerTask)new AnimationTimerTask(), 0L, (long)this.sequence.getFrameMs());
            }
            if (propertyChangeEvent.getPropertyName().equals("sequence.prop.name")) {
                this.labelName.setText(this.sequence.getName());
            }
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.buttonDirection) {
            this.switchPlayDirection();
        } else {
            this.setPlaying(!this.isPlaying);
        }
    }

    public void frameAdded(Sequence sequence, int n) {
        this.sequenceChanged();
    }

    public void frameRemoved(Sequence sequence, int n) {
        this.sequenceChanged();
    }

    public void framesChanged(Sequence sequence) {
        this.sequenceChanged();
    }

    public void frameModified(Sequence sequence, int n) {
    }

    private class AnimationTimerTask
    extends TimerTask {
        private AnimationTimerTask() {
        }

        public void run() {
            if (!SequencePreviewPanelSidebar.this.isPlaying || !SequencePreviewPanelSidebar.this.isShowing()) {
                return;
            }
            SequencePreviewPanelSidebar.this.setCurrentFrameIndex(SequencePreviewPanelSidebar.this.sequenceIndex);
            SequencePreviewPanelSidebar.this.currentFrameChanged();
            if (SequencePreviewPanelSidebar.this.isPlayingForward) {
                SequencePreviewPanelSidebar.this.incrementSequenceIndex();
            } else {
                SequencePreviewPanelSidebar.this.decrementSequenceIndex();
            }
        }
    }
}

