/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.j2ee.common.project.FileChangeSupportEvent;
import org.netbeans.modules.j2ee.common.project.FileChangeSupportListener;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class FileChangeSupport {
    public static final FileChangeSupport DEFAULT = new FileChangeSupport();
    private final Map<FileChangeSupportListener, Map<File, Holder>> holders = new WeakHashMap<FileChangeSupportListener, Map<File, Holder>>();

    private FileChangeSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(FileChangeSupportListener fileChangeSupportListener, File file) {
        assert (file.equals(FileUtil.normalizeFile((File)file))) : "Need to normalize " + file + " before passing to FCS!";
        Map<FileChangeSupportListener, Map<File, Holder>> map = this.holders;
        synchronized (map) {
            Map<File, Holder> map2 = this.holders.get(fileChangeSupportListener);
            if (map2 == null) {
                map2 = new HashMap<File, Holder>();
                this.holders.put(fileChangeSupportListener, map2);
            }
            if (map2.containsKey(file)) {
                throw new IllegalArgumentException("Already listening to " + file);
            }
            map2.put(file, new Holder(fileChangeSupportListener, file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(FileChangeSupportListener fileChangeSupportListener, File file) {
        assert (file.equals(FileUtil.normalizeFile((File)file))) : "Need to normalize " + file + " before passing to FCS!";
        Holder holder = null;
        Map<FileChangeSupportListener, Map<File, Holder>> map = this.holders;
        synchronized (map) {
            Map<File, Holder> map2 = this.holders.get(fileChangeSupportListener);
            if (map2 == null) {
                throw new IllegalArgumentException("Was not listening to " + file);
            }
            if (!map2.containsKey(file)) {
                throw new IllegalArgumentException(fileChangeSupportListener + " was not listening to " + file + "; only to " + map2.keySet());
            }
            holder = map2.remove(file);
        }
        if (holder != null) {
            holder.run();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Holder
    extends WeakReference<FileChangeSupportListener>
    implements FileChangeListener,
    Runnable {
        private final File path;
        private FileObject current;
        private File currentF;

        public Holder(FileChangeSupportListener fileChangeSupportListener, File file) {
            super(fileChangeSupportListener, Utilities.activeReferenceQueue());
            assert (file != null);
            this.path = file;
            this.locateCurrent();
        }

        private void locateCurrent() {
            FileObject fileObject;
            block6: {
                fileObject = this.current;
                this.currentF = this.path;
                do {
                    try {
                        this.current = FileUtil.toFileObject((File)this.currentF);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.currentF = FileUtil.normalizeFile((File)this.currentF);
                        this.current = FileUtil.toFileObject((File)this.currentF);
                    }
                    if (this.current != null) break block6;
                    this.currentF = this.currentF.getParentFile();
                } while (this.currentF != null);
                return;
            }
            assert (this.current != null);
            if (this.current != fileObject) {
                if (fileObject != null) {
                    fileObject.removeFileChangeListener((FileChangeListener)this);
                }
                this.current.addFileChangeListener((FileChangeListener)this);
                this.current.getChildren();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void someChange(FileObject fileObject) {
            File file;
            FileObject fileObject2;
            File file2;
            FileChangeSupportListener fileChangeSupportListener;
            Object object = this;
            synchronized (object) {
                if (this.current == null) {
                    return;
                }
                fileChangeSupportListener = (FileChangeSupportListener)this.get();
                if (fileChangeSupportListener == null) {
                    return;
                }
                FileObject fileObject3 = this.current;
                file2 = this.currentF;
                this.locateCurrent();
                fileObject2 = this.current;
                file = this.currentF;
            }
            if (fileObject != null && fileObject == fileObject2) {
                object = new FileChangeSupportEvent(DEFAULT, 2, this.path);
                fileChangeSupportListener.fileModified((FileChangeSupportEvent)object);
            } else {
                boolean bl = this.path.equals(file2);
                boolean bl2 = this.path.equals(file);
                if (bl && !bl2) {
                    FileChangeSupportEvent fileChangeSupportEvent = new FileChangeSupportEvent(DEFAULT, 1, this.path);
                    fileChangeSupportListener.fileDeleted(fileChangeSupportEvent);
                } else if (bl2 && !bl) {
                    FileChangeSupportEvent fileChangeSupportEvent = new FileChangeSupportEvent(DEFAULT, 0, this.path);
                    fileChangeSupportListener.fileCreated(fileChangeSupportEvent);
                }
            }
        }

        public void fileChanged(FileEvent fileEvent) {
            this.someChange(fileEvent.getFile());
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.someChange(null);
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.someChange(null);
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.someChange(null);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.someChange(null);
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        @Override
        public synchronized void run() {
            if (this.current != null) {
                this.current.removeFileChangeListener((FileChangeListener)this);
                this.current = null;
            }
        }
    }
}

