/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import org.netbeans.lib.profiler.heap.HeapSummary;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;

final class Summary
implements HeapSummary {
    final int totalLiveBytes;
    final int totalLiveInstances;
    final long time;
    final long totalAllocatedBytes;
    final long totalAllocatedInstances;

    Summary(HprofByteBuffer hprofByteBuffer, long l) {
        assert (hprofByteBuffer.get(l) == 7);
        hprofByteBuffer.getInt(l + 1L);
        hprofByteBuffer.getInt(l + 1L + 4L);
        this.totalLiveBytes = hprofByteBuffer.getInt(l + 1L + 4L + 4L);
        this.totalLiveInstances = hprofByteBuffer.getInt(l + 1L + 4L + 4L + 4L);
        this.totalAllocatedBytes = hprofByteBuffer.getLong(l + 1L + 4L + 4L + 4L + 4L);
        this.totalAllocatedInstances = hprofByteBuffer.getLong(l + 1L + 4L + 4L + 4L + 4L + 8L);
        this.time = hprofByteBuffer.getTime();
    }

    public long getTime() {
        return this.time;
    }

    public long getTotalAllocatedBytes() {
        return this.totalAllocatedBytes;
    }

    public long getTotalAllocatedInstances() {
        return this.totalAllocatedInstances;
    }

    public long getTotalLiveBytes() {
        return this.totalLiveBytes;
    }

    public long getTotalLiveInstances() {
        return this.totalLiveInstances;
    }
}

