/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.etable;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.etable.ETableColumnModel;
import org.netbeans.swing.etable.TableColumnSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ColumnSelectionPanel
extends JPanel {
    private static final String COLUMNS_SELECTOR_HINT = "ColumnsSelectorHint";
    private Map<ETableColumn, JCheckBox> checkBoxes = new HashMap<ETableColumn, JCheckBox>();
    private ETableColumnModel columnModel;

    public ColumnSelectionPanel(ETable eTable) {
        ETableColumnModel eTableColumnModel;
        TableColumnModel tableColumnModel = eTable.getColumnModel();
        if (!(tableColumnModel instanceof ETableColumnModel)) {
            return;
        }
        this.columnModel = eTableColumnModel = (ETableColumnModel)tableColumnModel;
        ArrayList<TableColumn> arrayList = Collections.list(eTableColumnModel.getColumns());
        arrayList.addAll(eTableColumnModel.hiddenColumns);
        Collections.sort(arrayList, ETableColumnComparator.DEFAULT);
        int n = 1;
        JPanel jPanel = this.layoutPanel(arrayList, n, eTable);
        Dimension dimension = jPanel.getPreferredSize();
        final Rectangle rectangle = ColumnSelectionPanel.getUsableScreenBounds(ColumnSelectionPanel.getCurrentGraphicsConfiguration());
        JComponent jComponent = null;
        if (dimension.width > rectangle.width - 100 || dimension.height > rectangle.height - 100) {
            JScrollPane jScrollPane = new JScrollPane(){

                public Dimension getPreferredSize() {
                    Dimension dimension = new Dimension(super.getPreferredSize());
                    if (dimension.width > rectangle.width - 100) {
                        dimension.width = rectangle.width * 3 / 4;
                    }
                    if (dimension.height > rectangle.height - 100) {
                        dimension.height = rectangle.height * 3 / 4;
                    }
                    return dimension;
                }
            };
            jScrollPane.setViewportView(jPanel);
            jComponent = jScrollPane;
        } else {
            jComponent = jPanel;
        }
        this.add(jComponent);
    }

    private JPanel layoutPanel(List<TableColumn> list, int n, ETable eTable) {
        JCheckBox jCheckBox;
        Object v;
        ArrayList<Object> arrayList;
        Object object;
        Object object2;
        JPanel jPanel = new JPanel(new GridBagLayout());
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int i = 0; i < list.size(); ++i) {
            ETableColumn eTableColumn = (ETableColumn)list.get(i);
            Object object3 = new JCheckBox();
            Object object4 = eTable.transformValue(eTableColumn);
            Object object5 = eTable.transformValue(eTableColumn);
            object2 = object4 == eTableColumn || object5 == null ? eTableColumn.getHeaderValue().toString() : object5.toString();
            ((AbstractButton)object3).setText((String)object2);
            object = (JCheckBox)eTable.transformValue(object3);
            if (object != null) {
                object3 = object;
            }
            this.checkBoxes.put(eTableColumn, (JCheckBox)object3);
            ((AbstractButton)object3).setSelected(!this.columnModel.isColumnHidden(eTableColumn));
            ((AbstractButton)object3).setEnabled(eTableColumn.isHidingAllowed());
            if (!arrayList2.contains(object2)) {
                hashMap.put(object2, object3);
            } else {
                arrayList = null;
                v = hashMap.get(object2);
                if (v instanceof JCheckBox) {
                    jCheckBox = (JCheckBox)v;
                    arrayList = new ArrayList<Object>();
                    arrayList.add(jCheckBox);
                } else if (v instanceof ArrayList) {
                    arrayList = (ArrayList)v;
                } else {
                    throw new IllegalStateException("Wrong object theFirstOne is " + v);
                }
                arrayList.add(object3);
                hashMap.put(object2, arrayList);
            }
            arrayList2.add(object2);
        }
        String string = (String)arrayList2.remove(0);
        Collections.sort(arrayList2, Collator.getInstance());
        arrayList2.add(0, string);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = list.size() / n;
        object2 = eTable.transformValue(COLUMNS_SELECTOR_HINT);
        if (object2 != null) {
            object = new GridBagConstraints();
            ((GridBagConstraints)object).gridx = 0;
            ((GridBagConstraints)object).gridy = 0;
            ((GridBagConstraints)object).insets = new Insets(5, 12, 12, 12);
            ((GridBagConstraints)object).anchor = 18;
            jPanel.add((Component)new JLabel(object2.toString()), object);
        }
        object = arrayList2.iterator();
        while (object.hasNext()) {
            Cloneable cloneable;
            if (n2 >= n5) {
                n2 = 0;
                ++n3;
            }
            arrayList = (String)object.next();
            v = hashMap.get(arrayList);
            jCheckBox = null;
            if (v instanceof JCheckBox) {
                jCheckBox = (JCheckBox)v;
            } else if (v instanceof ArrayList) {
                cloneable = (ArrayList)v;
                if (n4 >= ((ArrayList)cloneable).size()) {
                    n4 = 0;
                }
                jCheckBox = (JCheckBox)((ArrayList)cloneable).get(n4++);
            } else {
                throw new IllegalStateException("Wrong object obj is " + v);
            }
            cloneable = new GridBagConstraints();
            ((GridBagConstraints)cloneable).gridx = n3;
            ((GridBagConstraints)cloneable).gridy = n2 + (object2 == null ? n2 : n2 + 1);
            ((GridBagConstraints)cloneable).insets = new Insets(0, 12, 0, 12);
            ((GridBagConstraints)cloneable).anchor = 18;
            ((GridBagConstraints)cloneable).weightx = 1.0;
            jPanel.add((Component)jCheckBox, cloneable);
            ++n2;
        }
        return jPanel;
    }

    public void changeColumnVisibility() {
        if (this.columnModel == null) {
            return;
        }
        Iterator<ETableColumn> iterator = this.checkBoxes.keySet().iterator();
        while (iterator.hasNext()) {
            ETableColumn eTableColumn;
            JCheckBox jCheckBox = this.checkBoxes.get(eTableColumn = iterator.next());
            this.columnModel.setColumnHidden(eTableColumn, !jCheckBox.isSelected());
        }
    }

    static void showColumnSelectionPopup(Component component, final ETable eTable) {
        ArrayList<JCheckBoxMenuItem> arrayList;
        JCheckBoxMenuItem jCheckBoxMenuItem;
        String string;
        if (!eTable.isColumnHidingAllowed()) {
            return;
        }
        if (!eTable.isPopupUsedFromTheCorner()) {
            ColumnSelectionPanel.showColumnSelectionDialog(eTable);
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        TableColumnModel tableColumnModel = eTable.getColumnModel();
        if (!(tableColumnModel instanceof ETableColumnModel)) {
            return;
        }
        final ETableColumnModel eTableColumnModel = (ETableColumnModel)tableColumnModel;
        ArrayList<TableColumn> arrayList2 = Collections.list(eTableColumnModel.getColumns());
        arrayList2.addAll(eTableColumnModel.hiddenColumns);
        Collections.sort(arrayList2, ETableColumnComparator.DEFAULT);
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (final ETableColumn object2 : arrayList2) {
            JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem();
            string = eTable.transformValue(object2).toString();
            jCheckBoxMenuItem2.setText(string);
            JCheckBoxMenuItem jCheckBoxMenuItem3 = (JCheckBoxMenuItem)eTable.transformValue(jCheckBoxMenuItem2);
            jCheckBoxMenuItem3.setSelected(!eTableColumnModel.isColumnHidden(object2));
            jCheckBoxMenuItem3.setEnabled(object2.isHidingAllowed());
            jCheckBoxMenuItem = jCheckBoxMenuItem3;
            jCheckBoxMenuItem3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    eTableColumnModel.setColumnHidden(object2, !jCheckBoxMenuItem.isSelected());
                    eTable.updateColumnSelectionMouseListener();
                }
            });
            if (!arrayList3.contains(string)) {
                hashMap.put(string, jCheckBoxMenuItem3);
            } else {
                arrayList = null;
                Object v = hashMap.get(string);
                if (v instanceof JCheckBoxMenuItem) {
                    JCheckBoxMenuItem jCheckBoxMenuItem4 = (JCheckBoxMenuItem)v;
                    arrayList = new ArrayList<JCheckBoxMenuItem>();
                    arrayList.add(jCheckBoxMenuItem4);
                } else if (v instanceof ArrayList) {
                    arrayList = (ArrayList)v;
                } else {
                    throw new IllegalStateException("Wrong object theFirstOne is " + v);
                }
                arrayList.add(jCheckBoxMenuItem3);
                hashMap.put(string, arrayList);
            }
            arrayList3.add(string);
        }
        Collections.sort(arrayList3, Collator.getInstance());
        int n = 0;
        for (String string2 : arrayList3) {
            string = hashMap.get(string2);
            jCheckBoxMenuItem = null;
            if (string instanceof JCheckBoxMenuItem) {
                jCheckBoxMenuItem = (JCheckBoxMenuItem)((Object)string);
            } else if (string instanceof ArrayList) {
                arrayList = (ArrayList<JCheckBoxMenuItem>)((Object)string);
                if (n >= arrayList.size()) {
                    n = 0;
                }
                jCheckBoxMenuItem = (JCheckBoxMenuItem)arrayList.get(n++);
            } else {
                throw new IllegalStateException("Wrong object obj is " + string);
            }
            jPopupMenu.add(jCheckBoxMenuItem);
        }
        jPopupMenu.show(component, 8, 8);
    }

    static void showColumnSelectionDialog(ETable eTable) {
        if (!eTable.isColumnHidingAllowed()) {
            return;
        }
        TableColumnSelector tableColumnSelector = eTable.getColumnSelector();
        if (tableColumnSelector != null) {
            ETableColumnModel eTableColumnModel = (ETableColumnModel)eTable.getColumnModel();
            TableColumnSelector.TreeNode treeNode = eTableColumnModel.getColumnHierarchyRoot();
            if (treeNode != null) {
                String[] stringArray = ColumnSelectionPanel.getAvailableColumnNames(eTable, true);
                String[] stringArray2 = tableColumnSelector.selectVisibleColumns(treeNode, stringArray);
                ColumnSelectionPanel.makeVisibleColumns(eTable, stringArray2);
            } else {
                String[] stringArray = ColumnSelectionPanel.getAvailableColumnNames(eTable, false);
                String[] stringArray3 = ColumnSelectionPanel.getAvailableColumnNames(eTable, true);
                String[] stringArray4 = tableColumnSelector.selectVisibleColumns(stringArray, stringArray3);
                ColumnSelectionPanel.makeVisibleColumns(eTable, stringArray4);
            }
            return;
        }
        ColumnSelectionPanel columnSelectionPanel = new ColumnSelectionPanel(eTable);
        int n = JOptionPane.showConfirmDialog(null, columnSelectionPanel, eTable.selectVisibleColumnsLabel, 2);
        if (n == 0) {
            columnSelectionPanel.changeColumnVisibility();
            eTable.updateColumnSelectionMouseListener();
        }
    }

    private static void makeVisibleColumns(ETable eTable, String[] stringArray) {
        ETableColumn eTableColumn;
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        TableColumnModel tableColumnModel = eTable.getColumnModel();
        if (!(tableColumnModel instanceof ETableColumnModel)) {
            return;
        }
        ETableColumnModel eTableColumnModel = (ETableColumnModel)tableColumnModel;
        ArrayList<TableColumn> arrayList = Collections.list(eTableColumnModel.getColumns());
        arrayList.addAll(eTableColumnModel.hiddenColumns);
        Collections.sort(arrayList, ETableColumnComparator.DEFAULT);
        HashMap<String, ETableColumn> hashMap = new HashMap<String, ETableColumn>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = eTable.getColumnDisplayName((eTableColumn = (ETableColumn)iterator.next()).getHeaderValue().toString());
            eTableColumnModel.setColumnHidden(eTableColumn, !hashSet.contains(string));
            hashMap.put(string, eTableColumn);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            eTableColumn = (ETableColumn)hashMap.get(stringArray[i]);
            if (eTableColumn == null) {
                throw new IllegalStateException("Cannot find column with name " + stringArray[i]);
            }
            int n = eTableColumnModel.getColumnIndex(eTableColumn.getIdentifier());
            eTableColumnModel.moveColumn(n, i);
        }
    }

    private static String[] getAvailableColumnNames(ETable eTable, boolean bl) {
        TableColumnModel tableColumnModel = eTable.getColumnModel();
        if (!(tableColumnModel instanceof ETableColumnModel)) {
            return new String[0];
        }
        ETableColumnModel eTableColumnModel = (ETableColumnModel)tableColumnModel;
        ArrayList<TableColumn> arrayList = Collections.list(eTableColumnModel.getColumns());
        if (!bl) {
            arrayList.addAll(eTableColumnModel.hiddenColumns);
        }
        Collections.sort(arrayList, ETableColumnComparator.DEFAULT);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (ETableColumn eTableColumn : arrayList) {
            String string = eTable.getColumnDisplayName(eTableColumn.getHeaderValue().toString());
            arrayList2.add(string);
        }
        Collections.sort(arrayList2, Collator.getInstance());
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    private static GraphicsConfiguration getCurrentGraphicsConfiguration() {
        Window window;
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component != null && (window = SwingUtilities.getWindowAncestor(component)) != null) {
            return window.getGraphicsConfiguration();
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    private static Rectangle getUsableScreenBounds(GraphicsConfiguration graphicsConfiguration) {
        if (graphicsConfiguration == null) {
            graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        return new Rectangle(graphicsConfiguration.getBounds());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ETableColumnComparator
    implements Comparator<TableColumn> {
        public static final ETableColumnComparator DEFAULT = new ETableColumnComparator();

        private ETableColumnComparator() {
        }

        @Override
        public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
            if (tableColumn instanceof ETableColumn && tableColumn2 instanceof ETableColumn) {
                ((ETableColumn)tableColumn).compareTo((ETableColumn)tableColumn2);
            }
            return 0;
        }
    }
}

