/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.Util;

public final class TreeName {
    private final String prefix;
    private final String name;
    private final String rawName;

    public TreeName(String string, String string2) throws InvalidArgumentException {
        this.checkPrefix(string);
        this.checkName(string2);
        this.prefix = string;
        this.name = string2;
        this.rawName = TreeName.getQualifiedName(string, string2);
    }

    public TreeName(String string) throws InvalidArgumentException {
        this.checkRawName(string);
        this.prefix = TreeName.getPrefix(string);
        this.name = TreeName.getName(string);
        this.rawName = string;
    }

    private static String getPrefix(String string) {
        int n = string.indexOf(":");
        if (n < 0) {
            return "";
        }
        return string.substring(0, n);
    }

    private static String getName(String string) {
        int n = string.indexOf(":");
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    private static String getQualifiedName(String string, String string2) {
        if ("".equals(string)) {
            return string2;
        }
        return string + ":" + string2;
    }

    public String getPrefix() {
        return this.prefix;
    }

    private void checkPrefix(String string) throws InvalidArgumentException {
        if (string == null) {
            throw this.createInvalidNullArgumentException();
        }
    }

    public String getName() {
        return this.name;
    }

    private void checkName(String string) throws InvalidArgumentException {
        if (string == null) {
            throw this.createInvalidNullArgumentException();
        }
    }

    public String getQualifiedName() {
        return this.rawName;
    }

    private void checkRawName(String string) throws InvalidArgumentException {
        if (string == null) {
            throw this.createInvalidNullArgumentException();
        }
    }

    private InvalidArgumentException createInvalidNullArgumentException() {
        return new InvalidArgumentException(Util.THIS.getString("EXC_invalid_null_value"), new NullPointerException());
    }

    public boolean equals(Object object) {
        if (object instanceof TreeName) {
            return this.rawName.equals(((TreeName)object).rawName);
        }
        return false;
    }

    public int hashCode() {
        return this.rawName.hashCode();
    }

    public String toString() {
        return this.rawName;
    }
}

