/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FilterComponent;
import org.netbeans.lib.profiler.ui.components.JExtendedTable;
import org.netbeans.lib.profiler.ui.components.table.ClassNameTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.ExtendedTableModel;
import org.netbeans.lib.profiler.ui.components.table.LabelBracketTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.MethodNameTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.SortableTableModel;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.CPUResultsPanel;
import org.netbeans.lib.profiler.ui.cpu.CPUSelectionHandler;
import org.netbeans.lib.profiler.utils.StringUtils;

public abstract class FlatProfilePanel
extends CPUResultsPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.cpu.Bundle");
    private static final String STARTS_WITH_STRING = messages.getString("FlatProfilePanel_StartsWithString");
    private static final String CONTAINS_STRING = messages.getString("FlatProfilePanel_ContainsString");
    private static final String ENDS_WITH_STRING = messages.getString("FlatProfilePanel_EndsWithString");
    private static final String REGEXP_STRING = messages.getString("FlatProfilePanel_RegExpString");
    private static final String FILTER_ITEM_NAME = messages.getString("FlatProfilePanel_FilterItemName");
    private static final String METHOD_COLUMN_NAME = messages.getString("FlatProfilePanel_MethodColumnName");
    private static final String METHOD_COLUMN_TOOLTIP = messages.getString("FlatProfilePanel_MethodColumnToolTip");
    private static final String METHOD_FILTER_HINT = messages.getString("FlatProfilePanel_MethodFilterHint");
    private static final String CLASS_COLUMN_NAME = messages.getString("FlatProfilePanel_ClassColumnName");
    private static final String CLASS_COLUMN_TOOLTIP = messages.getString("FlatProfilePanel_ClassColumnToolTip");
    private static final String CLASS_FILTER_HINT = messages.getString("FlatProfilePanel_ClassFilterHint");
    private static final String PACKAGE_COLUMN_NAME = messages.getString("FlatProfilePanel_PackageColumnName");
    private static final String PACKAGE_COLUMN_TOOLTIP = messages.getString("FlatProfilePanel_PackageColumnToolTip");
    private static final String PACKAGE_FILTER_HINT = messages.getString("FlatProfilePanel_PackageFilterHint");
    private static final String SELFTIME_REL_COLUMN_NAME = messages.getString("FlatProfilePanel_SelfTimeRelColumnName");
    private static final String SELFTIME_REL_COLUMN_TOOLTIP = messages.getString("FlatProfilePanel_SelfTimeRelColumnToolTip");
    private static final String SELFTIME_COLUMN_NAME = messages.getString("FlatProfilePanel_SelfTimeColumnName");
    private static final String SELFTIME_COLUMN_TOOLTIP = messages.getString("FlatProfilePanel_SelfTimeColumnToolTip");
    private static final String SELFTIME_CPU_COLUMN_NAME = messages.getString("FlatProfilePanel_SelfTimeCpuColumnName");
    private static final String SELFTIME_CPU_COLUMN_TOOLTIP = messages.getString("FlatProfilePanel_SelfTimeCpuColumnToolTip");
    private static final String INVOCATIONS_COLUMN_NAME = messages.getString("FlatProfilePanel_InvocationsColumnName");
    private static final String INVOCATIONS_COLUMN_TOOLTIP = messages.getString("FlatProfilePanel_InvocationsColumnToolTip");
    private static final String TABLE_ACCESS_NAME = messages.getString("FlatProfilePanel_TableAccessName");
    private static final String NO_RELEVANT_DATA = messages.getString("FlatProfilePanel_NoRelevantData");
    protected CustomBarCellRenderer barRenderer;
    protected ExtendedTableModel resTableModel;
    protected FilterComponent filterComponent;
    protected FlatProfileContainer flatProfileContainer;
    protected JExtendedTable resTable;
    protected JScrollPane jScrollPane;
    protected String filterString = "";
    protected boolean collectingTwoTimeStamps;
    protected boolean sortOrder;
    protected double valueFilterValue = 0.0;
    protected int filterType = 20;
    protected int sortBy;
    protected int threadId;
    private CPUSelectionHandler selectionHandler;
    private JPanel noDataPanel;
    private int minNamesColumnWidth;
    private int sortingColumn;

    public FlatProfilePanel(CPUResUserActionsHandler cPUResUserActionsHandler) {
        this(cPUResUserActionsHandler, null);
    }

    public FlatProfilePanel(CPUResUserActionsHandler cPUResUserActionsHandler, CPUSelectionHandler cPUSelectionHandler) {
        super(cPUResUserActionsHandler);
        this.selectionHandler = cPUSelectionHandler;
        this.setDefaultSorting();
        this.minNamesColumnWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 30;
        this.cornerPopup = new JPopupMenu();
        this.jScrollPane = this.createScrollPaneVerticalScrollBarAlways();
        this.jScrollPane.setCorner("UPPER_RIGHT_CORNER", this.createHeaderPopupCornerButton(this.cornerPopup));
        this.jScrollPane.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (FlatProfilePanel.this.resTable != null) {
                    FlatProfilePanel.this.resTable.mouseWheelMoved(mouseWheelEvent);
                }
            }
        });
        this.initFilterPanel();
    }

    public void setCPUSelectionHandler(CPUSelectionHandler cPUSelectionHandler) {
        this.selectionHandler = cPUSelectionHandler;
    }

    public int getCurrentThreadId() {
        return this.threadId;
    }

    public void setDefaultSorting() {
        this.setSorting(1, false);
    }

    public int getFilterType() {
        return this.filterComponent.getFilterType();
    }

    public String getFilterValue() {
        return this.filterComponent.getFilterString();
    }

    public void setFilterValues(String string, int n) {
        this.filterComponent.setFilterValues(string, n);
    }

    public void setFindString(String string) {
        this.resTable.setFindParameters(string, 0);
    }

    public String getFindString() {
        return this.resTable.getFindString();
    }

    public boolean isFindStringDefined() {
        return this.resTable.isFindStringDefined();
    }

    public void setResultsAvailable(boolean bl) {
        JComponent jComponent;
        JViewport jViewport = this.jScrollPane.getViewport();
        JComponent jComponent2 = jComponent = bl ? this.resTable : this.noDataPanel;
        if (jComponent != jViewport.getView()) {
            jViewport.setView(jComponent);
            this.revalidate();
            this.repaint();
        }
    }

    public Object getResultsViewReference() {
        return this.resTable;
    }

    public int getSortBy(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: 
            case 2: {
                return 2;
            }
            case 3: {
                return this.collectingTwoTimeStamps ? 3 : 4;
            }
            case 4: {
                return 4;
            }
        }
        return 2;
    }

    public void setSorting(int n, boolean bl) {
        if (n == -1) {
            this.setDefaultSorting();
        } else {
            this.sortingColumn = n;
            this.sortOrder = bl;
            this.sortBy = this.getSortBy(this.sortingColumn);
        }
    }

    public int getSortingColumn() {
        if (this.resTableModel == null) {
            return -1;
        }
        return this.resTableModel.getRealColumn(this.resTableModel.getSortingColumn());
    }

    public boolean getSortingOrder() {
        if (this.resTableModel == null) {
            return false;
        }
        return this.resTableModel.getSortingOrder();
    }

    public void addFilterListener(FilterComponent.FilterListener filterListener) {
        this.filterComponent.addFilterListener(filterListener);
    }

    public void addResultsViewFocusListener(FocusListener focusListener) {
        this.resTable.addFocusListener(focusListener);
    }

    public boolean findFirst() {
        return this.resTable.findFirst();
    }

    public boolean findNext() {
        return this.resTable.findNext();
    }

    public boolean findPrevious() {
        return this.resTable.findPrevious();
    }

    public void prepareResults() {
        this.prepareResults(true);
    }

    public void removeFilterListener(FilterComponent.FilterListener filterListener) {
        this.filterComponent.removeFilterListener(filterListener);
    }

    public void removeResultsViewFocusListener(FocusListener focusListener) {
        this.resTable.removeFocusListener(focusListener);
    }

    public void requestFocus() {
        if (this.resTable != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FlatProfilePanel.this.resTable.requestFocus();
                }
            });
        }
    }

    public void reset() {
        this.jScrollPane.setViewportView(null);
        this.flatProfileContainer = null;
        this.resTable = null;
        this.resTableModel = null;
    }

    public void selectMethod(int n) {
        if (n == 0) {
            this.resTable.getSelectionModel().clearSelection();
            return;
        }
        int n2 = this.resTable.getSelectedRow();
        if (n2 >= this.flatProfileContainer.getNRows()) {
            n2 = this.flatProfileContainer.getNRows() - 1;
        }
        if (n2 != -1 && this.getCurrentThreadId() == this.threadId && this.flatProfileContainer.getMethodIdAtRow(n2) == n) {
            return;
        }
        for (int i = 0; i < this.flatProfileContainer.getNRows(); ++i) {
            if (this.flatProfileContainer.getMethodIdAtRow(i) != n) continue;
            this.resTable.getSelectionModel().setSelectionInterval(i, i);
            this.resTable.scrollRectToVisible(this.resTable.getCellRect(i, 0, true));
            break;
        }
    }

    public void selectMethod(String string) {
        for (int i = 0; i < this.resTable.getRowCount(); ++i) {
            if (!this.resTable.getValueAt(i, 0).toString().equals(string)) continue;
            this.resTable.getSelectionModel().setSelectionInterval(i, i);
            this.resTable.scrollRectToVisible(this.resTable.getCellRect(i, 0, true));
            return;
        }
        this.resTable.getSelectionModel().clearSelection();
    }

    protected String getSelectedMethodName() {
        if (this.resTable == null || this.resTableModel == null) {
            return null;
        }
        if (this.resTable.getSelectedRow() == -1) {
            return null;
        }
        return this.resTable.getValueAt(this.resTable.getSelectedRow(), 0).toString();
    }

    protected void initColumnSelectorItems() {
        this.cornerPopup.removeAll();
        for (int i = 0; i < this.columnCount; ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.columnNames[i]);
            jCheckBoxMenuItem.setActionCommand(new Integer(i).toString());
            this.addMenuItemListener(jCheckBoxMenuItem);
            if (this.resTable != null) {
                jCheckBoxMenuItem.setState(this.resTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    jCheckBoxMenuItem.setEnabled(false);
                }
            } else {
                jCheckBoxMenuItem.setState(true);
            }
            this.cornerPopup.add(jCheckBoxMenuItem);
        }
        this.cornerPopup.addSeparator();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(FILTER_ITEM_NAME);
        jCheckBoxMenuItem.setActionCommand("Filter");
        this.addMenuItemListener(jCheckBoxMenuItem);
        if (this.filterComponent == null) {
            jCheckBoxMenuItem.setState(true);
        } else {
            jCheckBoxMenuItem.setState(this.filterComponent.isVisible());
        }
        this.cornerPopup.add(jCheckBoxMenuItem);
        this.cornerPopup.pack();
    }

    protected void initColumnsData() {
        this.columnCount = this.collectingTwoTimeStamps ? 5 : 4;
        this.columnsVisibility = null;
        this.columnWidths = new int[this.columnCount - 1];
        this.columnNames = new String[this.columnCount];
        this.columnToolTips = new String[this.columnCount];
        this.columnRenderers = new TableCellRenderer[this.columnCount];
        this.columnNames[0] = METHOD_COLUMN_NAME;
        this.columnToolTips[0] = METHOD_COLUMN_TOOLTIP;
        this.columnNames[1] = SELFTIME_REL_COLUMN_NAME;
        this.columnToolTips[1] = SELFTIME_REL_COLUMN_TOOLTIP;
        this.columnNames[2] = SELFTIME_COLUMN_NAME;
        this.columnToolTips[2] = SELFTIME_COLUMN_TOOLTIP;
        if (this.collectingTwoTimeStamps) {
            this.columnNames[3] = SELFTIME_CPU_COLUMN_NAME;
            this.columnToolTips[3] = SELFTIME_CPU_COLUMN_TOOLTIP;
            this.columnNames[4] = INVOCATIONS_COLUMN_NAME;
            this.columnToolTips[4] = INVOCATIONS_COLUMN_TOOLTIP;
        } else {
            this.columnNames[3] = INVOCATIONS_COLUMN_NAME;
            this.columnToolTips[3] = INVOCATIONS_COLUMN_TOOLTIP;
        }
        int n = this.getFontMetrics(this.getFont()).charWidth('W') * 12;
        CustomBarCellRenderer customBarCellRenderer = new CustomBarCellRenderer(0L, 100L);
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(11);
        LabelBracketTableCellRenderer labelBracketTableCellRenderer = new LabelBracketTableCellRenderer(11);
        this.columnRenderers[0] = null;
        this.columnWidths[0] = n;
        this.columnRenderers[1] = customBarCellRenderer;
        this.columnWidths[1] = n;
        this.columnRenderers[2] = labelBracketTableCellRenderer;
        for (int i = 3; i < this.columnCount; ++i) {
            this.columnWidths[i - 1] = n;
            this.columnRenderers[i] = labelTableCellRenderer;
        }
    }

    protected abstract void obtainResults();

    protected void prepareResults(boolean bl) {
        int n;
        if (this.threadId < -1) {
            return;
        }
        int n2 = n = this.collectingTwoTimeStamps ? 5 : 4;
        if (this.columnCount != n) {
            this.initColumnsData();
        } else if (this.resTable != null) {
            this.saveColumnsData();
        }
        if (this.resTableModel == null || this.resTable == null) {
            this.initComponents();
        }
        if (bl) {
            this.obtainResults();
            String string = this.columnNames[0];
            this.initFirstColumnName();
            if (this.resTable != null && !this.columnNames[0].equals(string)) {
                this.resTable.getColumnModel().getColumn(0).setHeaderValue(this.columnNames[0]);
            }
        }
        this.flatProfileContainer.sortBy(this.sortBy, this.sortOrder);
        this.resTable.invalidate();
        this.jScrollPane.revalidate();
        this.resTable.repaint();
    }

    protected void saveColumnsData() {
        TableColumnModel tableColumnModel = this.resTable.getColumnModel();
        for (int i = 0; i < this.resTableModel.getColumnCount(); ++i) {
            int n = this.resTableModel.getRealColumn(i);
            if (n == 0) continue;
            this.columnWidths[n - 1] = tableColumnModel.getColumn(i).getPreferredWidth();
        }
        this.columnsVisibility = null;
        this.columnsVisibility = this.resTableModel.getColumnsVisibility();
    }

    protected void updateResults() {
        int n;
        if (this.threadId < -1) {
            return;
        }
        int n2 = n = this.collectingTwoTimeStamps ? 5 : 4;
        if (this.columnCount != n) {
            this.initColumnsData();
        } else if (this.resTable != null) {
            this.saveColumnsData();
        }
        this.flatProfileContainer.sortBy(this.sortBy, this.sortOrder);
        this.jScrollPane.setViewportView(this.resTable);
        this.jScrollPane.getViewport().setBackground(this.resTable.getBackground());
    }

    private void setColumnsData() {
        switch (this.currentView) {
            case 0: {
                this.columnRenderers[0] = new MethodNameTableCellRenderer();
                break;
            }
            case 1: {
                this.columnRenderers[0] = new ClassNameTableCellRenderer();
                break;
            }
            case 2: {
                this.columnRenderers[0] = new LabelTableCellRenderer();
            }
        }
        TableColumnModel tableColumnModel = this.resTable.getColumnModel();
        for (int i = 0; i < this.resTableModel.getColumnCount(); ++i) {
            int n = this.resTableModel.getRealColumn(i);
            if (n == 0) {
                tableColumnModel.getColumn(i).setPreferredWidth(this.minNamesColumnWidth);
            } else {
                tableColumnModel.getColumn(i).setPreferredWidth(this.columnWidths[n - 1]);
            }
            tableColumnModel.getColumn(i).setCellRenderer(this.columnRenderers[n]);
        }
    }

    private void addMenuItemListener(JCheckBoxMenuItem jCheckBoxMenuItem) {
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("Filter")) {
                    FlatProfilePanel.this.filterComponent.setVisible(!FlatProfilePanel.this.filterComponent.isVisible());
                    return;
                }
                boolean bl = false;
                int n = Integer.parseInt(actionEvent.getActionCommand());
                int n2 = FlatProfilePanel.this.resTableModel.getSortingColumn();
                int n3 = FlatProfilePanel.this.resTableModel.getRealColumn(n2);
                boolean bl2 = FlatProfilePanel.this.resTableModel.isRealColumnVisible(n);
                if (bl2 && n == n3) {
                    n2 = n2 + 1 == FlatProfilePanel.this.resTableModel.getColumnCount() ? n2 - 1 : n2 + 1;
                    n3 = FlatProfilePanel.this.resTableModel.getRealColumn(n2);
                    bl = true;
                }
                FlatProfilePanel.this.resTableModel.setRealColumnVisibility(n, !bl2);
                FlatProfilePanel.this.resTable.createDefaultColumnsFromModel();
                FlatProfilePanel.this.resTableModel.setTable(FlatProfilePanel.this.resTable);
                n2 = FlatProfilePanel.this.resTableModel.getVirtualColumn(n3);
                if (bl) {
                    FlatProfilePanel.this.sortOrder = FlatProfilePanel.this.resTableModel.getInitialSorting(n2);
                    FlatProfilePanel.this.sortBy = FlatProfilePanel.this.getSortBy(n3);
                    FlatProfilePanel.this.flatProfileContainer.sortBy(FlatProfilePanel.this.sortBy, FlatProfilePanel.this.sortOrder);
                    FlatProfilePanel.this.resTable.repaint();
                }
                FlatProfilePanel.this.sortingColumn = n3;
                FlatProfilePanel.this.resTableModel.setInitialSorting(n2, FlatProfilePanel.this.sortOrder);
                FlatProfilePanel.this.resTable.getTableHeader().repaint();
                FlatProfilePanel.this.setColumnsData();
            }
        });
    }

    private void initComponents() {
        this.resTableModel = new ExtendedTableModel(new SortableTableModel(){

            public String getColumnName(int n) {
                return FlatProfilePanel.this.columnNames[n];
            }

            public int getRowCount() {
                if (FlatProfilePanel.this.flatProfileContainer == null) {
                    return 0;
                }
                return FlatProfilePanel.this.flatProfileContainer.getNRows();
            }

            public int getColumnCount() {
                return FlatProfilePanel.this.columnCount;
            }

            public Class getColumnClass(int n) {
                if (n == 1) {
                    return Number.class;
                }
                return String.class;
            }

            public Object getValueAt(int n, int n2) {
                switch (n2) {
                    case 0: {
                        return FlatProfilePanel.this.flatProfileContainer.getMethodNameAtRow(n);
                    }
                    case 1: {
                        return new Float(FlatProfilePanel.this.flatProfileContainer.getPercentAtRow(n));
                    }
                    case 2: {
                        return StringUtils.mcsTimeToString((long)FlatProfilePanel.this.flatProfileContainer.getTimeInMcs0AtRow(n)) + " ms (" + FlatProfilePanel.this.percentFormat.format(FlatProfilePanel.this.flatProfileContainer.getPercentAtRow(n) / 100.0f) + ")";
                    }
                    case 3: {
                        return FlatProfilePanel.this.collectingTwoTimeStamps ? StringUtils.mcsTimeToString((long)FlatProfilePanel.this.flatProfileContainer.getTimeInMcs1AtRow(n)) + " ms" : Integer.toString(FlatProfilePanel.this.flatProfileContainer.getNInvocationsAtRow(n));
                    }
                    case 4: {
                        return Integer.toString(FlatProfilePanel.this.flatProfileContainer.getNInvocationsAtRow(n));
                    }
                }
                return null;
            }

            public String getColumnToolTipText(int n) {
                return FlatProfilePanel.this.columnToolTips[n];
            }

            public void sortByColumn(int n, boolean bl) {
                FlatProfilePanel.this.sortingColumn = n;
                FlatProfilePanel.this.sortBy = FlatProfilePanel.this.getSortBy(n);
                FlatProfilePanel.this.sortOrder = bl;
                int n2 = FlatProfilePanel.this.resTable.getSelectedRow();
                String string = null;
                if (n2 != -1) {
                    string = (String)FlatProfilePanel.this.resTable.getValueAt(n2, 0);
                }
                FlatProfilePanel.this.updateResults();
                if (string != null) {
                    FlatProfilePanel.this.resTable.selectRowByContents(string, 0, true);
                }
            }

            public boolean getInitialSorting(int n) {
                switch (n) {
                    case 0: {
                        return true;
                    }
                }
                return false;
            }
        });
        if (this.columnsVisibility != null) {
            this.resTableModel.setColumnsVisibility(this.columnsVisibility);
        }
        this.resTable = new JExtendedTable(this.resTableModel){

            public void doLayout() {
                int n = 0;
                int n2 = -1;
                for (int i = 0; i < FlatProfilePanel.this.resTableModel.getColumnCount(); ++i) {
                    int n3 = FlatProfilePanel.this.resTableModel.getRealColumn(i);
                    if (n3 == 0) {
                        n2 = i;
                        continue;
                    }
                    n += this.getColumnModel().getColumn(i).getPreferredWidth();
                }
                if (n2 != -1) {
                    this.getColumnModel().getColumn(n2).setPreferredWidth(Math.max(this.getWidth() - n, FlatProfilePanel.this.minNamesColumnWidth));
                }
                super.doLayout();
            }
        };
        this.resTable.getAccessibleContext().setAccessibleName(TABLE_ACCESS_NAME);
        this.resTableModel.setTable(this.resTable);
        this.resTableModel.setInitialSorting(this.sortingColumn, this.sortOrder);
        this.resTable.setRowSelectionAllowed(true);
        this.resTable.setSelectionMode(0);
        this.resTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.resTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.resTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.resTable.setShowHorizontalLines(false);
        this.resTable.setShowVerticalLines(true);
        this.resTable.setRowMargin(0);
        this.resTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.resTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.resTable.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FlatProfilePanel.this.performDefaultAction();
            }
        });
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(this.resTable.getFocusTraversalKeys(0));
        hashSet.add(KeyStroke.getKeyStroke(9, 0));
        this.resTable.setFocusTraversalKeys(0, hashSet);
        hashSet = new HashSet<AWTKeyStroke>(this.resTable.getFocusTraversalKeys(1));
        hashSet.add(KeyStroke.getKeyStroke(9, 1));
        this.resTable.setFocusTraversalKeys(1, hashSet);
        this.setColumnsData();
        this.resTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            private int lastSelection = -1;

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = FlatProfilePanel.this.resTable.getSelectedRow();
                int n2 = FlatProfilePanel.this.methodId = n != -1 ? FlatProfilePanel.this.flatProfileContainer.getMethodIdAtRow(n) : -1;
                if (FlatProfilePanel.this.selectionHandler != null) {
                    FlatProfilePanel.this.selectionHandler.methodSelected(this.lastSelection, FlatProfilePanel.this.methodId, FlatProfilePanel.this.currentView);
                }
                this.lastSelection = FlatProfilePanel.this.methodId;
            }
        });
        this.resTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n;
                if ((keyEvent.getKeyCode() == 525 || keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 1) && (n = FlatProfilePanel.this.resTable.getSelectedRow()) != -1) {
                    FlatProfilePanel.this.popupShowSource.setVisible(true);
                    if (FlatProfilePanel.this.popupShowReverse != null) {
                        FlatProfilePanel.this.popupShowReverse.setVisible(true);
                    }
                    FlatProfilePanel.this.popupPath = null;
                    FlatProfilePanel.this.methodId = FlatProfilePanel.this.flatProfileContainer.getMethodIdAtRow(n);
                    FlatProfilePanel.this.popupAddToRoots.setVisible(true);
                    Rectangle rectangle = FlatProfilePanel.this.resTable.getCellRect(n, 0, false);
                    FlatProfilePanel.this.callGraphPopupMenu.show(keyEvent.getComponent(), rectangle.x + FlatProfilePanel.this.resTable.getSize().width > 50 ? 50 : 5, rectangle.y);
                }
            }
        });
        this.resTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getModifiers() == 4 && (n = FlatProfilePanel.this.resTable.rowAtPoint(mouseEvent.getPoint())) != -1) {
                    FlatProfilePanel.this.resTable.setRowSelectionInterval(n, n);
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = FlatProfilePanel.this.resTable.rowAtPoint(mouseEvent.getPoint());
                if (n == -1) {
                    FlatProfilePanel.this.popupShowSource.setVisible(false);
                    if (FlatProfilePanel.this.popupShowReverse != null) {
                        FlatProfilePanel.this.popupShowReverse.setVisible(false);
                    }
                    FlatProfilePanel.this.popupAddToRoots.setVisible(false);
                    if (mouseEvent.getModifiers() == 4) {
                        FlatProfilePanel.this.popupPath = null;
                        FlatProfilePanel.this.callGraphPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                } else {
                    FlatProfilePanel.this.popupShowSource.setVisible(true);
                    if (FlatProfilePanel.this.popupShowReverse != null) {
                        FlatProfilePanel.this.popupShowReverse.setVisible(true);
                    }
                    FlatProfilePanel.this.popupAddToRoots.setVisible(true);
                    FlatProfilePanel.this.methodId = FlatProfilePanel.this.flatProfileContainer.getMethodIdAtRow(n);
                    if (mouseEvent.getModifiers() == 4) {
                        FlatProfilePanel.this.popupPath = null;
                        FlatProfilePanel.this.callGraphPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    } else if (mouseEvent.getModifiers() == 16 && mouseEvent.getClickCount() == 2) {
                        FlatProfilePanel.this.showSourceForMethod(FlatProfilePanel.this.methodId);
                    }
                }
            }
        });
        this.noDataPanel = new JPanel(new BorderLayout());
        this.noDataPanel.add((Component)new JLabel(NO_RELEVANT_DATA), "North");
        this.noDataPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.noDataPanel.setBackground(this.resTable.getBackground());
        this.jScrollPane.setViewportView(null);
        this.jScrollPane.getViewport().setBackground(this.resTable.getBackground());
    }

    private void initFilterPanel() {
        this.filterComponent = new FilterComponent();
        this.filterComponent.addFilterItem(new ImageIcon(this.filterComponent.getClass().getResource("/org/netbeans/lib/profiler/ui/resources/filterStartsWith.png")), STARTS_WITH_STRING, 10);
        this.filterComponent.addFilterItem(new ImageIcon(this.filterComponent.getClass().getResource("/org/netbeans/lib/profiler/ui/resources/filterContains.png")), CONTAINS_STRING, 20);
        this.filterComponent.addFilterItem(new ImageIcon(this.filterComponent.getClass().getResource("/org/netbeans/lib/profiler/ui/resources/filterEndsWith.png")), ENDS_WITH_STRING, 30);
        this.filterComponent.addFilterItem(new ImageIcon(this.filterComponent.getClass().getResource("/org/netbeans/lib/profiler/ui/resources/filterRegExp.png")), REGEXP_STRING, 50);
        this.filterComponent.setFilterValues(this.filterString, this.filterType);
        this.filterComponent.addFilterListener(new FilterComponent.FilterListener(){

            public void filterChanged() {
                int n;
                String string = null;
                if (FlatProfilePanel.this.resTable != null && (n = FlatProfilePanel.this.resTable.getSelectedRow()) != -1) {
                    string = (String)FlatProfilePanel.this.resTable.getValueAt(n, 0);
                }
                FlatProfilePanel.this.filterString = FlatProfilePanel.this.filterComponent.getFilterString();
                FlatProfilePanel.this.filterType = FlatProfilePanel.this.filterComponent.getFilterType();
                if (FlatProfilePanel.this.flatProfileContainer != null) {
                    FlatProfilePanel.this.flatProfileContainer.filterOriginalData(FilterComponent.getFilterStrings(FlatProfilePanel.this.filterString), FlatProfilePanel.this.filterType, FlatProfilePanel.this.valueFilterValue);
                    FlatProfilePanel.this.flatProfileContainer.sortBy(FlatProfilePanel.this.sortBy, FlatProfilePanel.this.sortOrder);
                }
                if (FlatProfilePanel.this.resTable != null) {
                    FlatProfilePanel.this.resTable.invalidate();
                    FlatProfilePanel.this.jScrollPane.revalidate();
                    FlatProfilePanel.this.resTable.repaint();
                    if (string != null) {
                        FlatProfilePanel.this.resTable.selectRowByContents(string, 0, true);
                    }
                }
            }
        });
        this.add((Component)this.filterComponent, "South");
    }

    private void initFirstColumnName() {
        switch (this.currentView) {
            case 0: {
                this.columnNames[0] = METHOD_COLUMN_NAME;
                this.columnToolTips[0] = METHOD_COLUMN_TOOLTIP;
                this.filterComponent.setEmptyFilterText(METHOD_FILTER_HINT);
                break;
            }
            case 1: {
                this.columnNames[0] = CLASS_COLUMN_NAME;
                this.columnToolTips[0] = CLASS_COLUMN_TOOLTIP;
                this.filterComponent.setEmptyFilterText(CLASS_FILTER_HINT);
                break;
            }
            case 2: {
                this.columnNames[0] = PACKAGE_COLUMN_NAME;
                this.columnToolTips[0] = PACKAGE_COLUMN_TOOLTIP;
                this.filterComponent.setEmptyFilterText(PACKAGE_FILTER_HINT);
            }
        }
        if (this.resTable != null) {
            this.resTable.getTableHeader().repaint();
        }
    }
}

