/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.management.api;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dlight.api.dataprovider.DataModelScheme;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightToolkitManagement;
import org.netbeans.modules.dlight.api.impl.DLightSessionHandlerAccessor;
import org.netbeans.modules.dlight.api.impl.DLightSessionInternalReference;
import org.netbeans.modules.dlight.api.impl.DLightToolkitManager;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightConfigurationManager;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.api.visualizer.TableBasedVisualizerConfiguration;
import org.netbeans.modules.dlight.api.visualizer.VisualizerConfiguration;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.DLightSessionListener;
import org.netbeans.modules.dlight.management.api.ExecutionContext;
import org.netbeans.modules.dlight.management.api.SessionStateListener;
import org.netbeans.modules.dlight.management.api.impl.VisualizerProvider;
import org.netbeans.modules.dlight.management.ui.spi.DetailsViewEmptyContentProvider;
import org.netbeans.modules.dlight.management.ui.spi.EmptyVisualizerContainerProvider;
import org.netbeans.modules.dlight.management.ui.spi.IndicatorsComponentProvider;
import org.netbeans.modules.dlight.spi.dataprovider.DataProvider;
import org.netbeans.modules.dlight.spi.impl.IndicatorAccessor;
import org.netbeans.modules.dlight.spi.impl.IndicatorActionListener;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerContainer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerDataProvider;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DLightManager
implements DLightToolkitManager,
IndicatorActionListener {
    private static final Logger log = DLightLogger.getLogger(DLightManager.class);
    private final List<DLightSessionListener> sessionListeners = Collections.synchronizedList(new ArrayList());
    private final List<DLightSession> sessions = new ArrayList<DLightSession>();
    private DLightSession activeSession;
    private final DLightManagerSessionStateListener sessionStateListener = new DLightManagerSessionStateListener();

    public DLightManager() {
        for (DLightSessionListener dLightSessionListener : IndicatorsComponentProvider.getInstance().getIndicatorComponentListeners()) {
            this.addDLightSessionListener(dLightSessionListener);
        }
    }

    public static DLightManager getDefault() {
        return (DLightManager)Lookup.getDefault().lookup(DLightToolkitManager.class);
    }

    public DLightSession createNewSession(DLightTarget dLightTarget, String string) {
        return this.createNewSession(dLightTarget, string, null);
    }

    public DLightSession createNewSession(DLightTarget dLightTarget, String string, String string2) {
        return this.createNewSession(dLightTarget, DLightConfigurationManager.getInstance().getConfigurationByName(string), string2);
    }

    public DLightSession createNewSession(DLightTarget dLightTarget, DLightConfiguration dLightConfiguration) {
        return this.createNewSession(dLightTarget, dLightConfiguration, null);
    }

    public DLightSession createNewSession(DLightTarget dLightTarget, DLightConfiguration dLightConfiguration, String string) {
        DLightSession dLightSession = this.newSession(dLightTarget, dLightConfiguration, string);
        this.setActiveSession(dLightSession);
        if (dLightSession != null) {
            dLightSession.addSessionStateListener(this.sessionStateListener);
        }
        return dLightSession;
    }

    public DLightToolkitManagement.DLightSessionHandler createSession(DLightTarget dLightTarget, String string) {
        return this.createSession(dLightTarget, string, null);
    }

    public DLightToolkitManagement.DLightSessionHandler createSession(DLightTarget dLightTarget, String string, String string2) {
        return DLightSessionHandlerAccessor.getDefault().create((DLightSessionInternalReference)this.createNewSession(dLightTarget, string, string2));
    }

    public DLightToolkitManagement.DLightSessionHandler createSession(DLightTarget dLightTarget, DLightConfiguration dLightConfiguration) {
        return this.createSession(dLightTarget, dLightConfiguration, null);
    }

    public DLightToolkitManagement.DLightSessionHandler createSession(DLightTarget dLightTarget, DLightConfiguration dLightConfiguration, String string) {
        return DLightSessionHandlerAccessor.getDefault().create((DLightSessionInternalReference)this.createNewSession(dLightTarget, dLightConfiguration, string));
    }

    public void closeSessionOnExit(DLightSession dLightSession) {
        DLightSession.SessionState sessionState = dLightSession.getState();
        if (sessionState != DLightSession.SessionState.ANALYZE) {
            dLightSession.closeOnExit();
        } else {
            dLightSession.close();
        }
    }

    private void cleanupSession(DLightSession dLightSession) {
        Indicator indicator;
        List<Visualizer<?>> list = dLightSession.getVisualizers();
        if (list != null) {
            for (Visualizer visualizer2 : list) {
                indicator = (VisualizerContainer)SwingUtilities.getAncestorOfClass(VisualizerContainer.class, visualizer2.getComponent());
                if (indicator == null) continue;
                indicator.removeVisualizer(visualizer2);
            }
        }
        List<Indicator<?>> list2 = dLightSession.getIndicators();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            indicator = (Indicator)iterator.next();
            IndicatorAccessor.getDefault().removeIndicatorActionListener(indicator, (IndicatorActionListener)this);
        }
        this.sessions.remove(dLightSession);
        this.notifySessionRemoved(dLightSession);
        if (this.sessions.isEmpty()) {
            this.setActiveSession(null);
        } else {
            this.setActiveSession(this.sessions.get(this.sessions.size() - 1));
        }
    }

    public void closeSession(DLightSession dLightSession) {
        if (dLightSession.isRunning()) {
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)DLightManager.loc("DLightManager.disposeRunningContext.Message", dLightSession.getDescription()), DLightManager.loc("DLightManager.disposeRunningContext.Title"), 0));
            if (object == NotifyDescriptor.NO_OPTION) {
                return;
            }
            dLightSession.stop();
            dLightSession.close();
        }
    }

    public DLightSession getActiveSession() {
        return this.activeSession;
    }

    public List<DLightSession> getSessionsList() {
        return this.sessions;
    }

    public DLightSession setActiveSession(DLightSession dLightSession) {
        DLightSession dLightSession2 = this.activeSession;
        if (dLightSession != dLightSession2) {
            this.activeSession = dLightSession;
            if (dLightSession2 != null) {
                dLightSession2.setActive(false);
            }
            if (dLightSession != null) {
                dLightSession.setActive(true);
            }
            this.notifySessionActivated(dLightSession2, dLightSession);
        }
        return this.activeSession;
    }

    public void startSession(DLightSession dLightSession) {
        this.setActiveSession(dLightSession);
        dLightSession.start();
    }

    public void stopActiveSession() {
        this.activeSession.stop();
    }

    public void stopSession(DLightSession dLightSession) {
        dLightSession.stop();
    }

    public void addDLightSessionListener(DLightSessionListener dLightSessionListener) {
        if (dLightSessionListener == null) {
            return;
        }
        if (!this.sessionListeners.contains(dLightSessionListener)) {
            this.sessionListeners.add(dLightSessionListener);
            for (DLightSession dLightSession : this.sessions) {
                dLightSessionListener.sessionAdded(dLightSession);
            }
            dLightSessionListener.activeSessionChanged(null, this.activeSession);
        }
    }

    public void removeDLightSessionListener(DLightSessionListener dLightSessionListener) {
        this.sessionListeners.remove(dLightSessionListener);
    }

    private DLightSession newSession(DLightTarget dLightTarget, DLightConfiguration dLightConfiguration, String string) {
        DLightSession dLightSession = new DLightSession(string);
        dLightSession.setExecutionContext(new ExecutionContext(dLightTarget, dLightConfiguration));
        this.sessions.add(dLightSession);
        List<Indicator<?>> list = dLightSession.getIndicators();
        for (Indicator<?> indicator : list) {
            IndicatorAccessor.getDefault().addIndicatorActionListener(indicator, (IndicatorActionListener)this);
        }
        this.notifySessionAdded(dLightSession);
        return dLightSession;
    }

    private DLightSession findIndicatorOwner(Indicator<?> indicator) {
        for (DLightSession dLightSession : this.sessions) {
            if (!dLightSession.containsIndicator(indicator)) continue;
            return dLightSession;
        }
        return this.activeSession;
    }

    private Visualizer<?> openVisualizer(String string, VisualizerConfiguration visualizerConfiguration, DLightSession dLightSession) {
        DataTableMetadata dataTableMetadata;
        TableBasedVisualizerConfiguration tableBasedVisualizerConfiguration;
        Visualizer<?> visualizer = null;
        if (dLightSession.hasVisualizer(string, visualizerConfiguration.getID())) {
            Visualizer<?> visualizer2 = visualizer = dLightSession.getVisualizer(string, visualizerConfiguration.getID());
            visualizer2.updateVisualizerConfiguration(visualizerConfiguration);
            if (visualizer instanceof SessionStateListener) {
                dLightSession.addSessionStateListener((SessionStateListener)visualizer);
                ((SessionStateListener)visualizer).sessionStateChanged(dLightSession, null, dLightSession.getState());
            }
            VisualizerContainer visualizerContainer = visualizer.getDefaultContainer();
            DLightTool dLightTool = dLightSession.getToolByID(string);
            if (dLightTool != null) {
                visualizerContainer.addVisualizer(string, dLightTool.getDetailedName(), visualizer);
            } else {
                visualizerContainer.addVisualizer(string, string, visualizer);
            }
            visualizerContainer.showup();
            visualizer.refresh();
            return visualizer;
        }
        DataProvider dataProvider = null;
        DataModelScheme dataModelScheme = visualizerConfiguration.getSupportedDataScheme();
        if (visualizerConfiguration instanceof TableBasedVisualizerConfiguration) {
            tableBasedVisualizerConfiguration = (TableBasedVisualizerConfiguration)visualizerConfiguration;
            dataTableMetadata = tableBasedVisualizerConfiguration.getMetadata();
            dataProvider = dLightSession.createDataProvider(dataModelScheme, dataTableMetadata);
        } else {
            dataProvider = dLightSession.createDataProvider(dataModelScheme, null);
        }
        if (dataProvider != null && (visualizer = VisualizerProvider.getInstance().createVisualizer(visualizerConfiguration, (VisualizerDataProvider)dataProvider)) instanceof SessionStateListener) {
            dLightSession.addSessionStateListener((SessionStateListener)visualizer);
            ((SessionStateListener)visualizer).sessionStateChanged(dLightSession, null, dLightSession.getState());
        }
        if (visualizer == null && (tableBasedVisualizerConfiguration = dLightSession.createVisualizerDataProvider(visualizerConfiguration.getSupportedDataScheme())) != null && (visualizer = VisualizerProvider.getInstance().createVisualizer(visualizerConfiguration, (VisualizerDataProvider)tableBasedVisualizerConfiguration)) instanceof SessionStateListener) {
            dLightSession.addSessionStateListener((SessionStateListener)visualizer);
            ((SessionStateListener)visualizer).sessionStateChanged(dLightSession, null, dLightSession.getState());
        }
        if (visualizer == null) {
            log.fine("Unable to find factory to create Visualizer with ID == " + visualizerConfiguration.getID());
            return null;
        }
        tableBasedVisualizerConfiguration = visualizer.getDefaultContainer();
        dataTableMetadata = dLightSession.getToolByID(string);
        if (dataTableMetadata != null) {
            tableBasedVisualizerConfiguration.addVisualizer(string, dataTableMetadata.getDetailedName(), visualizer);
        } else {
            tableBasedVisualizerConfiguration.addVisualizer(string, string, visualizer);
        }
        tableBasedVisualizerConfiguration.showup();
        dLightSession.putVisualizer(string, visualizerConfiguration.getID(), visualizer);
        return visualizer;
    }

    private void openEmptyVisualizer(String string, String string2, DLightSession dLightSession) {
        DetailsViewEmptyContentProvider detailsViewEmptyContentProvider = (DetailsViewEmptyContentProvider)Lookup.getDefault().lookup(DetailsViewEmptyContentProvider.class);
        if (detailsViewEmptyContentProvider == null) {
            detailsViewEmptyContentProvider = DefaultDetailsViewEmptyContentProvider.instance;
        }
        JComponent jComponent = null;
        boolean bl = true;
        if (Lookup.getDefault().lookup(EmptyVisualizerContainerProvider.class) == null) {
            return;
        }
        DLightTool dLightTool = dLightSession.getToolByID(string2);
        if (dLightTool == null) {
            return;
        }
        Collection collection = Lookup.getDefault().lookupAll(EmptyVisualizerContainerProvider.class);
        VisualizerContainer visualizerContainer = ((EmptyVisualizerContainerProvider)Lookup.getDefault().lookup(EmptyVisualizerContainerProvider.class)).getEmptyVisualizerContainer();
        if (string != null) {
            for (Object object2 : collection) {
                VisualizerContainer object4 = object2.getEmptyVisualizerContainer(string);
                if (object4 == null) continue;
                visualizerContainer = object4;
                break;
            }
        }
        if (visualizerContainer == null) {
            for (Object object2 : collection) {
                VisualizerContainer visualizerContainer2 = object2.getEmptyVisualizerContainer();
                if (visualizerContainer2 == null) continue;
                visualizerContainer = visualizerContainer2;
                break;
            }
        }
        if (visualizerContainer == null) {
            return;
        }
        Object object3 = string2;
        if (dLightTool != null) {
            object3 = dLightTool.getDetailedName();
        }
        for (ExecutionContext executionContext : dLightSession.getExecutionContexts()) {
            jComponent = detailsViewEmptyContentProvider.getEmptyView(executionContext.getDLightConfiguration(), dLightTool, executionContext.getTarget());
            if (bl) {
                visualizerContainer.setContent((String)object3, jComponent);
                bl = false;
                continue;
            }
            visualizerContainer.addContent((String)object3, jComponent);
        }
        visualizerContainer.showup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySessionRemoved(DLightSession dLightSession) {
        List<DLightSessionListener> list = this.sessionListeners;
        synchronized (list) {
            for (DLightSessionListener dLightSessionListener : this.sessionListeners) {
                dLightSessionListener.sessionRemoved(dLightSession);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySessionAdded(DLightSession dLightSession) {
        List<DLightSessionListener> list = this.sessionListeners;
        synchronized (list) {
            for (DLightSessionListener dLightSessionListener : this.sessionListeners) {
                dLightSessionListener.sessionAdded(dLightSession);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySessionActivated(DLightSession dLightSession, DLightSession dLightSession2) {
        List<DLightSessionListener> list = this.sessionListeners;
        synchronized (list) {
            for (DLightSessionListener dLightSessionListener : this.sessionListeners) {
                dLightSessionListener.activeSessionChanged(dLightSession, dLightSession2);
            }
        }
    }

    private void resetContext(ExecutionContext executionContext) {
    }

    private static String loc(String string) {
        return NbBundle.getMessage(DLightManager.class, (String)string);
    }

    private static String loc(String string, Object object) {
        return NbBundle.getMessage(DLightManager.class, (String)string, (Object)object);
    }

    public void startSession(DLightToolkitManagement.DLightSessionHandler dLightSessionHandler) {
        DLightSessionInternalReference dLightSessionInternalReference = DLightSessionHandlerAccessor.getDefault().getSessionReferenceImpl(dLightSessionHandler);
        if (!(dLightSessionInternalReference instanceof DLightSession)) {
            throw new IllegalArgumentException("Illegal Argument, reference you are trying to use to start D-Light session is invalid");
        }
        this.startSession((DLightSession)dLightSessionInternalReference);
    }

    public void stopSession(DLightToolkitManagement.DLightSessionHandler dLightSessionHandler) {
        DLightSessionInternalReference dLightSessionInternalReference = DLightSessionHandlerAccessor.getDefault().getSessionReferenceImpl(dLightSessionHandler);
        if (!(dLightSessionInternalReference instanceof DLightSession)) {
            throw new IllegalArgumentException("Illegal Argument, reference you are trying to use to stop D-Light session is invalid");
        }
        this.stopSession((DLightSession)dLightSessionInternalReference);
    }

    public void revalidateSessions() {
        for (DLightSession dLightSession : this.sessions) {
            dLightSession.revalidate();
        }
    }

    public void openVisualizerForIndicator(Indicator<?> indicator, VisualizerConfiguration visualizerConfiguration) {
        boolean bl;
        DLightSession dLightSession = this.findIndicatorOwner(indicator);
        this.setActiveSession(dLightSession);
        boolean bl2 = bl = this.openVisualizer(IndicatorAccessor.getDefault().getToolID(indicator), visualizerConfiguration, dLightSession) != null;
        if (!bl) {
            this.openEmptyVisualizer(visualizerConfiguration.getID(), IndicatorAccessor.getDefault().getToolID(indicator), dLightSession);
        }
    }

    public final void openVisualizer(DLightSession dLightSession, String string, VisualizerConfiguration visualizerConfiguration) {
        boolean bl;
        this.setActiveSession(dLightSession);
        boolean bl2 = bl = this.openVisualizer(string, visualizerConfiguration, dLightSession) != null;
        if (!bl) {
            this.openEmptyVisualizer(visualizerConfiguration.getID(), string, dLightSession);
        }
    }

    public void mouseClickedOnIndicator(Indicator<?> indicator) {
        DLightSession dLightSession = this.findIndicatorOwner(indicator);
        this.setActiveSession(dLightSession);
        List list = IndicatorAccessor.getDefault().getVisualizerConfigurations(indicator);
        boolean bl = false;
        if (list != null) {
            for (VisualizerConfiguration visualizerConfiguration : list) {
                if (this.openVisualizer(IndicatorAccessor.getDefault().getToolID(indicator), visualizerConfiguration, dLightSession) == null) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            this.openEmptyVisualizer(null, IndicatorAccessor.getDefault().getToolID(indicator), dLightSession);
        }
    }

    private static final class DefaultDetailsViewEmptyContentProvider
    implements DetailsViewEmptyContentProvider {
        private static final DefaultDetailsViewEmptyContentProvider instance = new DefaultDetailsViewEmptyContentProvider();
        private final JPanel p = new JPanel();

        DefaultDetailsViewEmptyContentProvider() {
            this.p.setLayout(new BorderLayout());
            this.p.add((Component)new JLabel(DLightManager.loc("DLightManager.noData")), "Center");
        }

        public JComponent getEmptyView(DLightConfiguration dLightConfiguration, DLightTool dLightTool, DLightTarget dLightTarget) {
            return this.p;
        }
    }

    private class DLightManagerSessionStateListener
    implements SessionStateListener {
        private DLightManagerSessionStateListener() {
        }

        public void sessionStateChanged(DLightSession dLightSession, DLightSession.SessionState sessionState, DLightSession.SessionState sessionState2) {
            if (sessionState2 == DLightSession.SessionState.CLOSED) {
                DLightManager.this.cleanupSession(dLightSession);
            }
        }
    }
}

