/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.base;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.asm.base.BaseAsmModel;
import org.netbeans.modules.cnd.asm.model.AsmModel;
import org.netbeans.modules.cnd.asm.model.AsmModelProvider;
import org.netbeans.modules.cnd.asm.model.util.EmptyModel;

public abstract class BaseModelProvider
implements AsmModelProvider {
    private final String resource;
    private Reference<AsmModel> modelRef;

    public BaseModelProvider(String string) {
        this.resource = string;
        this.modelRef = new SoftReference<Object>(null);
    }

    public synchronized AsmModel getModel() {
        AsmModel asmModel = this.modelRef.get();
        if (asmModel == null) {
            asmModel = this.load();
            this.modelRef = new SoftReference<AsmModel>(asmModel);
        }
        return asmModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsmModel load() {
        BaseAsmModel baseAsmModel;
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getResourceAsStream(this.resource);
            baseAsmModel = new BaseAsmModel(new InputStreamReader(inputStream));
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Can't load xml model", exception);
            AsmModel asmModel = EmptyModel.getInstance();
            return asmModel;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Can't load xml model", exception);
                    return EmptyModel.getInstance();
                }
            }
        }
        return baseAsmModel;
    }
}

