/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.base.syntax;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.asm.base.syntax.AntlrScanner;
import org.netbeans.modules.cnd.asm.base.syntax.AntlrToken;
import org.netbeans.modules.cnd.asm.base.syntax.IdentResolver;
import org.netbeans.modules.cnd.asm.model.lang.syntax.AsmBaseTokenId;
import org.netbeans.modules.cnd.asm.model.lang.syntax.AsmHighlightLexer;
import org.netbeans.modules.cnd.asm.model.lang.syntax.AsmToken;
import org.netbeans.modules.cnd.asm.model.lang.syntax.AsmTokenId;

public class AntlrLexer
implements AsmHighlightLexer {
    private AntlrScanner scanner;
    private IdentResolver resolver;
    private int length;

    public AntlrLexer(AntlrScanner antlrScanner, IdentResolver identResolver) {
        this.scanner = antlrScanner;
        this.resolver = identResolver;
        this.length = 0;
    }

    public AsmTokenId nextToken() {
        int n = this.scanner.getOffset();
        AsmTokenId asmTokenId = AsmBaseTokenId.ASM_EMPTY;
        try {
            AntlrToken antlrToken = (AntlrToken)this.scanner.nextToken();
            AsmToken asmToken = antlrToken.createAsmToken(this.resolver);
            asmTokenId = asmToken.getId();
            this.length = this.scanner.getOffset() - n;
            if (!(asmTokenId != AsmBaseTokenId.ASM_UNKWN_ID && asmTokenId != AsmBaseTokenId.ASM_LABEL || asmToken.getText().startsWith(".") || asmToken.getText().startsWith("_"))) {
                asmTokenId = AsmBaseTokenId.ASM_INSTRUCTION;
            }
            return asmTokenId;
        }
        catch (TokenStreamException tokenStreamException) {
            if (this.scanner.getPartState() != AntlrScanner.PartState.IN_COMMENT && this.scanner.getPartState() != AntlrScanner.PartState.IN_STRING) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Unresolved symbol at position " + n);
            }
            this.length = this.scanner.getOffset() - n;
            return asmTokenId;
        }
    }

    public int getLastLength() {
        return this.length;
    }

    public Object getState() {
        return this.scanner.getIntState();
    }
}

