/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.el;

import java.awt.Toolkit;
import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.el.lexer.api.ELTokenId;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.editor.JSFEditorUtilities;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.netbeans.modules.web.jsf.api.metamodel.FacesManagedBean;
import org.netbeans.modules.web.jsf.editor.el.JsfElExpression;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JsfHyperlinkProvider
implements HyperlinkProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHyperlinkPoint(Document document, int n) {
        if (!(document instanceof BaseDocument)) {
            return false;
        }
        BaseDocument baseDocument = (BaseDocument)document;
        baseDocument.readLock();
        try {
            JTextComponent jTextComponent = Utilities.getFocusedComponent();
            if (jTextComponent == null || jTextComponent.getDocument() != baseDocument) {
                boolean bl = false;
                return bl;
            }
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            if (tokenSequence.move(n) == Integer.MAX_VALUE) {
                boolean bl = false;
                return bl;
            }
            if (!tokenSequence.moveNext()) {
                boolean bl = false;
                return bl;
            }
            TokenSequence tokenSequence2 = tokenSequence.embedded(ELTokenId.language());
            if (tokenSequence2 != null) {
                FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
                if (fileObject == null) {
                    boolean bl = false;
                    return bl;
                }
                WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
                if (webModule != null) {
                    JsfElExpression jsfElExpression = new JsfElExpression(webModule, document);
                    tokenSequence2.move(n);
                    if (!tokenSequence2.moveNext()) {
                        boolean bl = false;
                        return bl;
                    }
                    if (tokenSequence2.token().id() == ELTokenId.DOT) {
                        boolean bl = false;
                        return bl;
                    }
                    int n2 = tokenSequence2.offset() + tokenSequence2.token().length();
                    int n3 = jsfElExpression.parse(n2);
                    if (n3 == 1) {
                        n3 = jsfElExpression.parse(n2 + 1);
                    }
                    boolean bl = n3 == 100 || n3 == 102;
                    return bl;
                }
            }
        }
        finally {
            baseDocument.readUnlock();
        }
        return false;
    }

    public int[] getHyperlinkSpan(Document document, int n) {
        FileObject fileObject;
        WebModule webModule;
        if (!(document instanceof BaseDocument)) {
            return null;
        }
        BaseDocument baseDocument = (BaseDocument)document;
        JTextComponent jTextComponent = Utilities.getFocusedComponent();
        if (jTextComponent == null || jTextComponent.getDocument() != baseDocument) {
            return null;
        }
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        if (tokenSequence.move(n) == Integer.MAX_VALUE) {
            return null;
        }
        if (!tokenSequence.moveNext()) {
            return null;
        }
        TokenSequence tokenSequence2 = tokenSequence.embedded(ELTokenId.language());
        if (tokenSequence2 != null && (webModule = WebModule.getWebModule((FileObject)(fileObject = NbEditorUtilities.getFileObject((Document)document)))) != null) {
            JsfElExpression jsfElExpression = new JsfElExpression(webModule, document);
            tokenSequence2.move(n);
            if (!tokenSequence2.moveNext()) {
                return null;
            }
            int n2 = tokenSequence2.offset() + tokenSequence2.token().length();
            int n3 = jsfElExpression.parse(n2);
            if (n3 == 100 || n3 == 1 || n3 == 102) {
                return new int[]{tokenSequence2.offset(), n2};
            }
        }
        return null;
    }

    public void performClickAction(Document document, int n) {
        FileObject fileObject;
        WebModule webModule;
        BaseDocument baseDocument = (BaseDocument)document;
        JTextComponent jTextComponent = Utilities.getFocusedComponent();
        if (jTextComponent == null || jTextComponent.getDocument() != baseDocument) {
            return;
        }
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        if (tokenSequence.move(n) == Integer.MAX_VALUE) {
            return;
        }
        if (!tokenSequence.moveNext()) {
            return;
        }
        TokenSequence tokenSequence2 = tokenSequence.embedded(ELTokenId.language());
        if (tokenSequence2 != null && (webModule = WebModule.getWebModule((FileObject)(fileObject = NbEditorUtilities.getFileObject((Document)document)))) != null) {
            JsfElExpression jsfElExpression = new JsfElExpression(webModule, (Document)baseDocument);
            tokenSequence2.move(n);
            if (!tokenSequence2.moveNext()) {
                return;
            }
            int n2 = jsfElExpression.parse(tokenSequence2.offset() + tokenSequence2.token().length());
            if (n2 == 1) {
                new OpenConfigFile(fileObject, webModule, ((Object)tokenSequence2.token().text()).toString()).run();
                return;
            }
            if (!(n2 != 100 && n2 != 102 || jsfElExpression.gotoPropertyDeclaration(jsfElExpression.getBaseObjectClass()))) {
                String string = NbBundle.getBundle(JsfHyperlinkProvider.class).getString("MSG_source_not_found");
                StatusDisplayer.getDefault().setStatusText(string);
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    private static class OpenConfigFile
    implements Runnable {
        private String beanName;
        private WebModule wm;
        private FileObject mySource;

        OpenConfigFile(FileObject fileObject, WebModule webModule, String string) {
            this.beanName = string;
            this.wm = webModule;
            this.mySource = fileObject;
        }

        public void run() {
            if (this.wm == null) {
                return;
            }
            FacesManagedBean facesManagedBean = ConfigurationUtils.findFacesManagedBean((WebModule)this.wm, (String)this.beanName);
            if (facesManagedBean == null) {
                return;
            }
            FileObject fileObject = null;
            if (!(facesManagedBean instanceof ManagedBean)) {
                String string = facesManagedBean.getManagedBeanClass();
                JavaSource javaSource = JavaSource.create((ClasspathInfo)this.getClassPathInfo(), (FileObject[])new FileObject[0]);
                this.openElement(javaSource, string);
                return;
            }
            fileObject = (FileObject)((ManagedBean)facesManagedBean).getModel().getModelSource().getLookup().lookup(FileObject.class);
            if (fileObject != null) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    if (dataObject != null) {
                        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
                        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                        EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
                        if (editorCookie != null) {
                            Line line;
                            StyledDocument styledDocument = editorCookie.openDocument();
                            int[] nArray = JSFEditorUtilities.getManagedBeanDefinition((BaseDocument)((BaseDocument)styledDocument), (String)"managed-bean-name", (String)this.beanName);
                            int n = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)nArray[0]);
                            int n2 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n);
                            int n3 = n2 - nArray[0];
                            if (n != -1 && (line = lineCookie.getLineSet().getCurrent(n)) != null) {
                                line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FRONT, n3);
                            }
                            if (editCookie != null) {
                                editCookie.edit();
                            }
                        }
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }

        private void openElement(JavaSource javaSource, final String string) {
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                        if (typeElement == null) {
                            return;
                        }
                        ElementOpen.open((ClasspathInfo)compilationController.getClasspathInfo(), (Element)typeElement);
                    }
                }, true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        private ClasspathInfo getClassPathInfo() {
            Project project = FileOwnerQuery.getOwner((FileObject)this.mySource);
            return ClasspathInfo.create((ClassPath)OpenConfigFile.getClassPath(project, "classpath/boot"), (ClassPath)OpenConfigFile.getClassPath(project, "classpath/compile"), (ClassPath)OpenConfigFile.getClassPath(project, "classpath/source"));
        }

        private static ClassPath getClassPath(Project project, String string) {
            ClassPathProvider classPathProvider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
            if (classPathProvider == null) {
                return null;
            }
            Sources sources = (Sources)project.getLookup().lookup(Sources.class);
            if (sources == null) {
                return null;
            }
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
            ClassPath[] classPathArray = new ClassPath[sourceGroupArray.length];
            int n = 0;
            for (SourceGroup sourceGroup : sourceGroupArray) {
                FileObject fileObject = sourceGroup.getRootFolder();
                classPathArray[n] = classPathProvider.findClassPath(fileObject, string);
            }
            return ClassPathSupport.createProxyClassPath((ClassPath[])classPathArray);
        }
    }
}

