/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.hints;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.el.lexer.api.ELTokenId;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.syntax.checker.JspElChecker;
import org.netbeans.modules.web.core.syntax.completion.api.ELExpression;
import org.netbeans.modules.web.jsf.editor.el.JsfElExpression;
import org.netbeans.modules.web.jsf.editor.hints.ElContextChecker;
import org.netbeans.modules.web.jsf.editor.hints.HintsProvider;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElChecker
extends HintsProvider {
    private static final Map<Integer, ElContextChecker> JSF_CHECKERS = new HashMap<Integer, ElContextChecker>();
    private JspElChecker myJspChecker = new JspElChecker();

    ElChecker() {
    }

    @Override
    public List<Hint> compute(RuleContext ruleContext) {
        BaseDocument baseDocument = ruleContext.doc;
        FileObject fileObject = ruleContext.parserResult.getSnapshot().getSource().getFileObject();
        WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
        if (webModule == null) {
            return Collections.emptyList();
        }
        LinkedList<Hint> linkedList = new LinkedList<Hint>();
        LinkedList linkedList2 = new LinkedList();
        baseDocument.render(new Runnable((Document)baseDocument, webModule, fileObject, linkedList2){
            final /* synthetic */ Document val$doc;
            final /* synthetic */ WebModule val$webModule;
            final /* synthetic */ FileObject val$fileObject;
            final /* synthetic */ List val$elExpressions;
            {
                this.val$doc = document;
                this.val$webModule = webModule;
                this.val$fileObject = fileObject;
                this.val$elExpressions = list;
            }

            public void run() {
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.val$doc);
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                tokenSequence.moveStart();
                while (tokenSequence.moveNext()) {
                    TokenSequence tokenSequence2 = tokenSequence.embedded(ELTokenId.language());
                    if (tokenSequence2 == null) continue;
                    tokenSequence2.moveEnd();
                    if (!tokenSequence2.moveNext() && !tokenSequence2.movePrevious()) continue;
                    Token token = tokenSequence2.token();
                    int n = tokenSequence2.offset() + token.length();
                    ElChecker.this.collectExpressions(this.val$webModule, this.val$doc, n, (TokenSequence<ELTokenId>)tokenSequence2, this.val$fileObject, this.val$elExpressions);
                }
            }
        });
        for (Map map : linkedList2) {
            this.checkElContext(map, linkedList, (Document)baseDocument, webModule, fileObject);
        }
        return linkedList;
    }

    protected void collectExpressions(WebModule webModule, Document document, int n, TokenSequence<ELTokenId> tokenSequence, FileObject fileObject, List<Map<Class<? extends ELExpression>, ELExpression>> list) {
        JsfElExpression jsfElExpression = new JsfElExpression(webModule, document);
        jsfElExpression.parse(n);
        int n2 = jsfElExpression.getStartOffset();
        if (n2 == -1) {
            tokenSequence.move(n);
            if (!tokenSequence.movePrevious()) {
                return;
            }
            this.collectExpressions(webModule, document, tokenSequence.offset(), tokenSequence, fileObject, list);
        } else {
            ELExpression eLExpression = this.myJspChecker.parseExpression(document, jsfElExpression.getContextOffset());
            HashMap hashMap = new HashMap();
            hashMap.put(((Object)((Object)jsfElExpression)).getClass(), jsfElExpression);
            hashMap.put(eLExpression.getClass(), eLExpression);
            list.add(hashMap);
            this.collectExpressions(webModule, document, n2, tokenSequence, fileObject, list);
        }
    }

    private void checkElContext(Map<Class<? extends ELExpression>, ELExpression> map, List<Hint> list, Document document, WebModule webModule, FileObject fileObject) {
        JsfElExpression jsfElExpression = (JsfElExpression)map.get(JsfElExpression.class);
        ElContextChecker elContextChecker = JSF_CHECKERS.get(jsfElExpression.getParseType());
        if (elContextChecker != null && elContextChecker.check(jsfElExpression, document, fileObject, list)) {
            return;
        }
    }

    static {
        JSF_CHECKERS.put(1, new ElContextChecker.JsfElStartContextChecker());
        JSF_CHECKERS.put(100, new ElContextChecker.JsfElBeanContextChecker());
        JSF_CHECKERS.put(102, JSF_CHECKERS.get(100));
        JSF_CHECKERS.put(101, new ElContextChecker.JsfElResourceBundleContextChecker());
        JSF_CHECKERS.put(1, new ElContextChecker.JsfElStartContextChecker());
        JSF_CHECKERS.put(5, new ElContextChecker.JsfElUnknownContextChecker());
    }
}

