/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.hints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.AstNodeVisitor;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.el.lexer.api.ELTokenId;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.jsf.editor.JsfSupport;
import org.netbeans.modules.web.jsf.editor.JsfUtils;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrary;
import org.netbeans.modules.web.jsf.editor.hints.HintsProvider;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryDeclarationChecker
extends HintsProvider {
    @Override
    public List<Hint> compute(RuleContext ruleContext) {
        ArrayList<Hint> arrayList = new ArrayList<Hint>();
        this.checkLibraryDeclarations(arrayList, ruleContext);
        return arrayList;
    }

    private void checkLibraryDeclarations(final List<Hint> list, final RuleContext ruleContext) {
        AstNode.Attribute attribute;
        Object object;
        AstNode.Attribute attribute2;
        Object object322;
        HtmlParserResult htmlParserResult = (HtmlParserResult)ruleContext.parserResult;
        final Snapshot snapshot = htmlParserResult.getSnapshot();
        Set set = htmlParserResult.getNamespaces().keySet();
        ArrayList<FaceletsLibrary> arrayList = new ArrayList<FaceletsLibrary>();
        JsfSupport jsfSupport = JsfSupport.findFor((Document)ruleContext.doc);
        Map<String, FaceletsLibrary> map = Collections.EMPTY_MAP;
        if (jsfSupport != null) {
            map = jsfSupport.getFaceletsLibraries();
        }
        final HashMap hashMap = new HashMap();
        AstNode astNode = htmlParserResult.root();
        AstNodeUtils.visitChildren((AstNode)astNode, (AstNodeVisitor)new AstNodeVisitor(){

            public void visit(AstNode astNode) {
                if (astNode.type() == AstNode.NodeType.OPEN_TAG) {
                    Collection collection = astNode.getAttributes(new AstNode.AttributeFilter(){

                        public boolean accepts(AstNode.Attribute attribute) {
                            return "xmlns".equals(attribute.namespacePrefix());
                        }
                    });
                    for (AstNode.Attribute attribute : collection) {
                        hashMap.put(attribute.unquotedValue(), attribute);
                    }
                } else if (astNode.type() == AstNode.NodeType.UNKNOWN_TAG && astNode.getNamespacePrefix() != null) {
                    Hint hint = new Hint((Rule)HintsProvider.DEFAULT_ERROR_RULE, NbBundle.getMessage(HintsProvider.class, (String)"MSG_UNDECLARED_COMPONENT"), ruleContext.parserResult.getSnapshot().getSource().getFileObject(), JsfUtils.createOffsetRange(snapshot, astNode.startOffset(), astNode.startOffset() + astNode.name().length() + 1), Collections.EMPTY_LIST, 50);
                    list.add(hint);
                }
            }
        });
        for (Object object322 : set) {
            FaceletsLibrary object22 = map.get(object322);
            if (object22 != null) {
                arrayList.add(object22);
                continue;
            }
            attribute2 = (AstNode.Attribute)hashMap.get(object322);
            if (attribute2 == null) continue;
            object = new Hint((Rule)DEFAULT_ERROR_RULE, NbBundle.getMessage(HintsProvider.class, (String)"MSG_MISSING_LIBRARY"), ruleContext.parserResult.getSnapshot().getSource().getFileObject(), JsfUtils.createOffsetRange(snapshot, attribute2.nameOffset(), attribute2.valueOffset() + attribute2.value().length()), Collections.EMPTY_LIST, 50);
            list.add((Hint)object);
        }
        ArrayList arrayList2 = new ArrayList();
        for (FaceletsLibrary faceletsLibrary : arrayList) {
            attribute2 = htmlParserResult.root(faceletsLibrary.getNamespace());
            if (attribute2 == null) continue;
            object = new int[1];
            AstNodeUtils.visitChildren((AstNode)attribute2, (AstNodeVisitor)new AstNodeVisitor((int[])object){
                final /* synthetic */ int[] val$usages;
                {
                    this.val$usages = nArray;
                }

                public void visit(AstNode astNode) {
                    this.val$usages[0] = this.val$usages[0] + 1;
                }
            }, (AstNode.NodeType)AstNode.NodeType.OPEN_TAG);
            object[0] = object[0] + (this.isFunctionLibraryPrefixUsadInEL(ruleContext, faceletsLibrary) ? 1 : 0);
            if (object[0] != 0 || (attribute = (AstNode.Attribute)hashMap.get(faceletsLibrary.getNamespace())) == null) continue;
            int n = attribute.nameOffset();
            int n2 = attribute.valueOffset() + attribute.value().length();
            try {
                arrayList2.add(new PositionRange(ruleContext, n, n2));
            }
            catch (BadLocationException badLocationException) {}
        }
        object322 = arrayList2.iterator();
        while (object322.hasNext()) {
            PositionRange positionRange = (PositionRange)object322.next();
            int n = positionRange.getFrom();
            int n3 = positionRange.getTo();
            attribute = Arrays.asList(new RemoveUnusedLibraryDeclarationHintFix(ruleContext.doc, positionRange), new RemoveUnusedLibrariesDeclarationHintFix(ruleContext.doc, arrayList2));
            Hint hint = new Hint((Rule)DEFAULT_WARNING_RULE, NbBundle.getMessage(HintsProvider.class, (String)"MSG_UNUSED_LIBRARY_DECLARATION"), ruleContext.parserResult.getSnapshot().getSource().getFileObject(), JsfUtils.createOffsetRange(snapshot, n, n3), (List)attribute, 50);
            list.add(hint);
        }
    }

    private boolean isFunctionLibraryPrefixUsadInEL(RuleContext ruleContext, FaceletsLibrary faceletsLibrary) {
        String string = (String)((HtmlParserResult)ruleContext.parserResult).getNamespaces().get(faceletsLibrary.getNamespace());
        BaseDocument baseDocument = ruleContext.doc;
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.moveStart();
        while (tokenSequence.moveNext()) {
            TokenSequence tokenSequence2 = tokenSequence.embeddedJoined(ELTokenId.language());
            if (tokenSequence2 == null) continue;
            tokenSequence2.moveStart();
            while (tokenSequence2.moveNext()) {
                if (tokenSequence2.token().id() != ELTokenId.TAG_LIB_PREFIX || !CharSequenceUtilities.equals((CharSequence)string, (Object)tokenSequence2.token().text())) continue;
                return true;
            }
        }
        return false;
    }

    private static final class PositionRange {
        private Position from;
        private Position to;

        public PositionRange(RuleContext ruleContext, int n, int n2) throws BadLocationException {
            Snapshot snapshot = ruleContext.parserResult.getSnapshot();
            this.from = ruleContext.doc.createPosition(snapshot.getOriginalOffset(n));
            this.to = ruleContext.doc.createPosition(snapshot.getOriginalOffset(n2));
        }

        public int getFrom() {
            return this.from.getOffset();
        }

        public int getTo() {
            return this.to.getOffset();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RemoveUnusedLibrariesDeclarationHintFix
    implements HintFix {
        protected Collection<PositionRange> ranges = new ArrayList<PositionRange>();
        protected BaseDocument document;

        public RemoveUnusedLibrariesDeclarationHintFix(BaseDocument baseDocument, Collection<PositionRange> collection) {
            this.document = baseDocument;
            this.ranges = collection;
        }

        public String getDescription() {
            return NbBundle.getMessage(HintsProvider.class, (String)"MSG_HINTFIX_REMOVE_ALL_UNUSED_LIBRARIES_DECLARATION");
        }

        public void implement() throws Exception {
            this.document.runAtomic(new Runnable(){

                public void run() {
                    try {
                        for (PositionRange positionRange : RemoveUnusedLibrariesDeclarationHintFix.this.ranges) {
                            int n;
                            int n2 = positionRange.getFrom();
                            int n3 = positionRange.getTo();
                            int n4 = Utilities.getRowStart((BaseDocument)RemoveUnusedLibrariesDeclarationHintFix.this.document, (int)n2);
                            if (n4 > (n = Utilities.getFirstNonWhiteBwd((BaseDocument)RemoveUnusedLibrariesDeclarationHintFix.this.document, (int)n2))) {
                                n2 = n4 - 1;
                            }
                            RemoveUnusedLibrariesDeclarationHintFix.this.document.remove(n2, n3 - n2);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            });
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static class RemoveUnusedLibraryDeclarationHintFix
    extends RemoveUnusedLibrariesDeclarationHintFix {
        public RemoveUnusedLibraryDeclarationHintFix(BaseDocument baseDocument, PositionRange positionRange) {
            super(baseDocument, Collections.singletonList(positionRange));
        }

        public String getDescription() {
            return NbBundle.getMessage(HintsProvider.class, (String)"MSG_HINTFIX_REMOVE_UNUSED_LIBRARY_DECLARATION");
        }
    }
}

