/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.diff.DiffNode;
import org.netbeans.modules.mercurial.ui.diff.DiffStreamSource;
import org.openide.util.NbBundle;

public final class Setup {
    public static final int DIFFTYPE_LOCAL = 0;
    public static final int DIFFTYPE_REMOTE = 1;
    public static final int DIFFTYPE_ALL = 2;
    public static final String REVISION_PRISTINE = "PRISTINE";
    public static final String REVISION_BASE = "BASE";
    public static final String REVISION_CURRENT = "LOCAL";
    public static final String REVISION_HEAD = "HEAD";
    private final File baseFile;
    private final String propertyName;
    private final String firstRevision;
    private final String secondRevision;
    private FileInformation info;
    private DiffStreamSource firstSource;
    private DiffStreamSource secondSource;
    private DiffController view;
    private DiffNode node;
    private String title;

    public Setup(File file, String string, int n) {
        String string2;
        String string3;
        this.baseFile = file;
        this.propertyName = string;
        this.info = Mercurial.getInstance().getFileStatusCache().getStatus(file);
        int n2 = this.info.getStatus();
        ResourceBundle resourceBundle = NbBundle.getBundle(Setup.class);
        switch (n) {
            case 0: {
                if (Setup.match(n2, 4100)) {
                    this.firstRevision = REVISION_BASE;
                    string3 = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_BaseRevision"), this.firstRevision);
                    break;
                }
                if (Setup.match(n2, 512)) {
                    this.firstRevision = null;
                    string3 = NbBundle.getMessage(Setup.class, (String)"LBL_Diff_NoLocalFile");
                    break;
                }
                if (Setup.match(n2, 2304)) {
                    this.firstRevision = REVISION_BASE;
                    string3 = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_BaseRevision"), this.firstRevision);
                    break;
                }
                this.firstRevision = REVISION_BASE;
                string3 = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_BaseRevision"), this.firstRevision);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow diff type: " + n);
            }
        }
        switch (n) {
            case 0: {
                if (Setup.match(n2, 64)) {
                    this.secondRevision = REVISION_CURRENT;
                    string2 = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_LocalConflict"), this.secondRevision);
                    break;
                }
                if (Setup.match(n2, 4100)) {
                    this.secondRevision = REVISION_CURRENT;
                    string2 = resourceBundle.getString("MSG_DiffPanel_LocalNew");
                    break;
                }
                if (Setup.match(n2, 512)) {
                    this.secondRevision = null;
                    string2 = NbBundle.getMessage(Setup.class, (String)"LBL_Diff_NoLocalFile");
                    break;
                }
                if (Setup.match(n2, 2304)) {
                    this.secondRevision = null;
                    string2 = resourceBundle.getString("MSG_DiffPanel_LocalDeleted");
                    break;
                }
                this.secondRevision = REVISION_CURRENT;
                string2 = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_LocalModified"), this.secondRevision);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow diff type: " + n);
            }
        }
        this.firstSource = new DiffStreamSource(file, this.firstRevision, string3);
        this.secondSource = new DiffStreamSource(file, this.secondRevision, string2);
        this.title = "<html>" + Mercurial.getInstance().getMercurialAnnotator().annotateNameHtml(file, this.info);
    }

    public Setup(File file, String string, String string2) {
        this.baseFile = file;
        this.propertyName = null;
        this.firstRevision = string;
        this.secondRevision = string2;
        this.firstSource = new DiffStreamSource(file, string, string);
        this.secondSource = new DiffStreamSource(file, string2, string2);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public File getBaseFile() {
        return this.baseFile;
    }

    public FileInformation getInfo() {
        return this.info;
    }

    public void setView(DiffController diffController) {
        this.view = diffController;
    }

    public DiffController getView() {
        return this.view;
    }

    public StreamSource getFirstSource() {
        return this.firstSource;
    }

    public StreamSource getSecondSource() {
        return this.secondSource;
    }

    void setNode(DiffNode diffNode) {
        this.node = diffNode;
    }

    DiffNode getNode() {
        return this.node;
    }

    public String toString() {
        return this.title;
    }

    void initSources() throws IOException {
        if (this.firstSource != null) {
            this.firstSource.init();
        }
        if (this.secondSource != null) {
            this.secondSource.init();
        }
    }

    private static boolean match(int n, int n2) {
        return (n & n2) != 0;
    }
}

