/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.log.SearchCriteriaPanel;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryPanel;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SearchExecutor
implements Runnable {
    public static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    static final SimpleDateFormat fullDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    static final DateFormat[] dateFormats = new DateFormat[]{fullDateFormat, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), simpleDateFormat, new SimpleDateFormat("yyyy-MM-dd")};
    private final SearchHistoryPanel master;
    private Map<File, Set<File>> workFiles;
    private Map<String, File> pathToRoot;
    private final SearchCriteriaPanel criteria;
    private int completedSearches;
    private boolean searchCanceled;

    public SearchExecutor(SearchHistoryPanel searchHistoryPanel) {
        this.master = searchHistoryPanel;
        this.criteria = searchHistoryPanel.getCriteria();
        this.pathToRoot = new HashMap<String, File>();
        this.workFiles = new HashMap<File, Set<File>>();
        for (File file : searchHistoryPanel.getRoots()) {
            File file2 = Mercurial.getInstance().getRepositoryRoot(file);
            Set<File> set = this.workFiles.get(file2);
            if (set == null) {
                set = new HashSet<File>(2);
                this.workFiles.put(file2, set);
            }
            set.add(file);
        }
    }

    @Override
    public void run() {
        final String string = this.criteria.getFrom();
        final String string2 = this.criteria.getTo();
        final int n = this.criteria.getLimit();
        this.completedSearches = 0;
        for (Map.Entry<File, Set<File>> entry : this.workFiles.entrySet()) {
            final File file = entry.getKey();
            final Set<File> set = entry.getValue();
            RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(file);
            HgProgressSupport hgProgressSupport = new HgProgressSupport(){

                public void perform() {
                    OutputLogger outputLogger = this.getLogger();
                    SearchExecutor.this.search(file, set, string, string2, n, this, outputLogger);
                }
            };
            hgProgressSupport.start(requestProcessor, file, NbBundle.getMessage(SearchExecutor.class, (String)"MSG_Search_Progress"));
        }
    }

    private void search(File file, Set<File> set, String string, String string2, int n, HgProgressSupport hgProgressSupport, OutputLogger outputLogger) {
        if (hgProgressSupport.isCanceled()) {
            this.searchCanceled = true;
            return;
        }
        HgLogMessage[] hgLogMessageArray = this.master.isIncomingSearch() ? HgCommand.getIncomingMessages(file, string2, this.master.isShowMerges(), outputLogger) : (this.master.isOutSearch() ? HgCommand.getOutMessages(file, string2, this.master.isShowMerges(), outputLogger) : (!this.master.isShowInfo() ? HgCommand.getLogMessagesNoFileInfo(file, set, string, string2, this.master.isShowMerges(), n, outputLogger) : HgCommand.getLogMessages(file, set, string, string2, this.master.isShowMerges(), true, n, outputLogger, true)));
        this.appendResults(file, hgLogMessageArray);
    }

    private synchronized void appendResults(File file, HgLogMessage[] hgLogMessageArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<RepositoryRevision> arrayList = new ArrayList<RepositoryRevision>();
        for (int i = hgLogMessageArray.length - 1; i >= 0; --i) {
            String string;
            HgLogMessage hgLogMessage = hgLogMessageArray[i];
            String string2 = this.criteria.getUsername();
            if (string2 != null && hgLogMessage.getAuthor().indexOf(string2) == -1 || (string = this.criteria.getCommitMessage()) != null && hgLogMessage.getMessage().indexOf(string) == -1) continue;
            RepositoryRevision repositoryRevision = new RepositoryRevision(hgLogMessage, file);
            for (RepositoryRevision.Event event : repositoryRevision.getEvents()) {
                String string3;
                if (event.getChangedPath().getAction() == 'A' && event.getChangedPath().getCopySrcPath() != null) {
                    string3 = (String)hashMap.get(event.getChangedPath().getPath());
                    if (string3 == null) {
                        string3 = event.getChangedPath().getPath();
                    }
                    hashMap.put(event.getChangedPath().getCopySrcPath(), string3);
                }
                string3 = event.getChangedPath().getPath();
                for (String string4 : hashMap.keySet()) {
                    if (!string3.startsWith(string4) || string3.length() != string4.length() && string3.charAt(string4.length()) != '/') continue;
                    string3 = (String)hashMap.get(string4) + string3.substring(string4.length());
                    break;
                }
                File file2 = new File(file, string3);
                event.setFile(file2);
            }
            arrayList.add(repositoryRevision);
        }
        this.checkFinished(arrayList);
    }

    private void checkFinished(final List<RepositoryRevision> list) {
        ++this.completedSearches;
        if (this.workFiles.size() == this.completedSearches) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (list.isEmpty()) {
                        SearchExecutor.this.master.setResults(null);
                    } else {
                        SearchExecutor.this.master.setResults(list);
                    }
                }
            });
        }
    }
}

