/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.io.File;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public abstract class SearchHistoryAction
extends ContextAction {
    static final int DIRECTORY_ENABLED_STATUS = -8;
    static final int FILE_ENABLED_STATUS = -8;
    private final VCSContext context;
    private File repositoryRoot;
    private File[] files;

    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_SearchHistory";
    }

    public SearchHistoryAction(VCSContext vCSContext) {
        this.context = vCSContext;
    }

    protected VCSContext getContext() {
        return this.context;
    }

    public boolean isEnabled() {
        return HgUtils.isFromHgRepository(this.context);
    }

    protected static void outputSearchContextTab(File file, String string) {
        OutputLogger outputLogger = SearchHistoryAction.openLogger(file, string);
        outputLogger.output(NbBundle.getMessage(SearchHistoryAction.class, (String)"MSG_LOG_ROOT_CONTEXT_SEP"));
        outputLogger.output(file.getAbsolutePath());
        SearchHistoryAction.closeLog(outputLogger);
    }

    protected static void outputSearchContextTab(File file, File[] fileArray, String string) {
        OutputLogger outputLogger = SearchHistoryAction.openLogger(file, string);
        outputLogger.output(NbBundle.getMessage(SearchHistoryAction.class, (String)"MSG_LOG_CONTEXT_SEP"));
        for (File file2 : fileArray) {
            outputLogger.output(file2.getAbsolutePath());
        }
        SearchHistoryAction.closeLog(outputLogger);
    }

    private static OutputLogger openLogger(File file, String string) {
        String string2 = file != null ? new HgURL(file).toHgCommandUrlStringWithoutUserInfo() : null;
        OutputLogger outputLogger = OutputLogger.getLogger(string2);
        outputLogger.outputInRed(NbBundle.getMessage(SearchHistoryAction.class, (String)string));
        outputLogger.outputInRed(NbBundle.getMessage(SearchHistoryAction.class, (String)"MSG_Log_Title_Sep"));
        return outputLogger;
    }

    private static void closeLog(OutputLogger outputLogger) {
        outputLogger.outputInRed("");
        outputLogger.closeLog();
    }

    protected File getRepositoryRoot() {
        File[] fileArray;
        if (this.repositoryRoot == null && this.context != null && (fileArray = HgUtils.getActionRoots(this.context)) != null && fileArray.length > 0) {
            this.repositoryRoot = Mercurial.getInstance().getRepositoryRoot(fileArray[0]);
        }
        return this.repositoryRoot;
    }

    protected File[] getFiles() {
        File file;
        if (this.files == null && (file = this.getRepositoryRoot()) != null) {
            this.files = HgUtils.filterForRepository(this.context, file, false);
        }
        return this.files;
    }
}

