/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.Locale;
import org.netbeans.modules.properties.LocalePanel;

public class LocalePropertyEditor
extends PropertyEditorSupport {
    private Locale locale;

    public void setValue(Object object) {
        if (!(object instanceof Locale)) {
            throw new IllegalArgumentException("I18N module: Bad class type of value:" + object.getClass().getName());
        }
        if (this.locale != null && this.locale.equals(object)) {
            return;
        }
        this.locale = (Locale)object;
        this.firePropertyChange();
    }

    public Object getValue() {
        return this.locale;
    }

    public String getAsText() {
        if (this.locale == null) {
            return super.getAsText();
        }
        return this.locale.toString();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(LocalePropertyEditor.createLocaleFromText(string));
    }

    public String getJavaInitializationString() {
        if (this.locale == null) {
            return super.getJavaInitializationString();
        }
        StringBuffer stringBuffer = new StringBuffer("new Locale(");
        String string = this.locale.getLanguage();
        String string2 = this.locale.getCountry();
        String string3 = this.locale.getVariant();
        if (string == null) {
            stringBuffer.append("\"\"");
        } else {
            stringBuffer.append("\"" + string + "\"");
        }
        if (string2 == null) {
            stringBuffer.append(",\"\"");
        } else {
            stringBuffer.append(",\"" + string2 + "\"");
        }
        if (string3 == null) {
            stringBuffer.append(")");
        } else {
            stringBuffer.append(",\"" + string3 + "\")");
        }
        return stringBuffer.toString();
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        final LocalePanel localePanel = new LocalePanel(this.locale);
        localePanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("customized_locale".equals(propertyChangeEvent.getPropertyName())) {
                    LocalePropertyEditor.this.setValue(localePanel.getLocale());
                }
            }
        });
        return localePanel;
    }

    private static Locale createLocaleFromText(String string) {
        if (string == null || "".equals(string)) {
            return new Locale("", "");
        }
        int n = string.indexOf(95);
        if (n == -1) {
            return new Locale(string, "");
        }
        String string2 = n == 0 ? "" : string.substring(0, n);
        if (string.length() <= n + 1) {
            return new Locale(string2, "");
        }
        if ((n = (string = string.substring(n + 1)).indexOf(95)) == -1) {
            return new Locale(string2, string);
        }
        String string3 = n == 0 ? "" : string.substring(0, n);
        if (string.length() <= n + 1) {
            return new Locale(string2, string3);
        }
        String string4 = string.substring(n + 1);
        return new Locale(string2, string3, string4);
    }
}

