/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.Dialog;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.netbeans.api.project.Project;
import org.netbeans.modules.i18n.wizard.AdditionalWizardPanel;
import org.netbeans.modules.i18n.wizard.HardStringWizardPanel;
import org.netbeans.modules.i18n.wizard.I18nWizardDescriptor;
import org.netbeans.modules.i18n.wizard.ResourceWizardPanel;
import org.netbeans.modules.i18n.wizard.SourceWizardPanel;
import org.netbeans.modules.i18n.wizard.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I18nWizardAction
extends NodeAction {
    static final long serialVersionUID = 6965968608028644524L;
    private static WeakReference<Dialog> dialogWRef = new WeakReference<Object>(null);

    public I18nWizardAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected boolean enable(Node[] nodeArray) {
        if (!Util.wizardEnabled(nodeArray)) {
            return false;
        }
        Dialog dialog = (Dialog)dialogWRef.get();
        if (dialog == null) {
            return true;
        }
        return !dialog.isVisible();
    }

    protected void performAction(Node[] nodeArray) {
        Project project;
        Dialog dialog = (Dialog)dialogWRef.get();
        if (dialog != null) {
            dialog.setVisible(false);
            dialog.dispose();
        }
        if ((project = org.netbeans.modules.i18n.Util.getProjectFor(nodeArray)) == null) {
            return;
        }
        WizardDescriptor wizardDescriptor = I18nWizardDescriptor.createI18nWizardDescriptor(this.getWizardIterator(), new I18nWizardDescriptor.Settings(Util.createWizardSourceMap(nodeArray), project));
        this.initWizard(wizardDescriptor);
        dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialogWRef = new WeakReference<Dialog>(dialog);
        dialog.setVisible(true);
    }

    private WizardDescriptor.Iterator<I18nWizardDescriptor.Settings> getWizardIterator() {
        ArrayList<I18nWizardDescriptor.Panel> arrayList = new ArrayList<I18nWizardDescriptor.Panel>(4);
        arrayList.add(new SourceWizardPanel.Panel());
        arrayList.add(new ResourceWizardPanel.Panel());
        arrayList.add(new AdditionalWizardPanel.Panel());
        arrayList.add(new HardStringWizardPanel.Panel());
        return new WizardDescriptor.ArrayIterator(arrayList.toArray(new WizardDescriptor.Panel[arrayList.size()]));
    }

    private void initWizard(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("WizardPanel_autoWizardStyle", (Object)Boolean.TRUE);
        wizardDescriptor.putProperty("WizardPanel_contentDisplayed", (Object)Boolean.TRUE);
        wizardDescriptor.putProperty("WizardPanel_contentNumbered", (Object)Boolean.TRUE);
        ArrayList<String> arrayList = new ArrayList<String>(4);
        arrayList.add(Util.getString("TXT_SelectSourcesHelp"));
        arrayList.add(Util.getString("TXT_SelectResourceHelp"));
        arrayList.add(Util.getString("TXT_AdditionalHelp"));
        arrayList.add(Util.getString("TXT_FoundStringsHelp"));
        wizardDescriptor.putProperty("WizardPanel_contentData", (Object)arrayList.toArray(new String[arrayList.size()]));
        wizardDescriptor.setTitle(Util.getString("LBL_WizardTitle"));
        wizardDescriptor.setTitleFormat(new MessageFormat("{0} ({1})"));
        wizardDescriptor.setModal(false);
    }

    public String getName() {
        return Util.getString("LBL_WizardActionName");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("internation.wizard");
    }

    protected boolean asynchronous() {
        return false;
    }
}

