/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.tool;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.tool.DLightConfigurationOptions;
import org.netbeans.modules.dlight.api.tool.DLightConfigurationOptionsListener;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.api.tool.ToolsConfiguration;
import org.netbeans.modules.dlight.api.tool.impl.DLightConfigurationAccessor;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DLightConfiguration {
    static final String CONFIGURATION_OPTIONS = "ConfigurationOptions";
    private final FileObject rootFolder;
    private final ToolsConfiguration toolsConfiguration;
    private final DLightConfigurationOptions configurationOptions;
    private final String displayedName;
    private final String category;
    private final String[] platforms;
    private final String collectorProviders;
    private final String[] indicatorProviders;
    private final boolean isHidden;
    private final boolean isSystem;
    private final boolean isDefault;
    private final DLightConfigurationOptionsListener listener = new DLightConfigurationOptionsListenerImpl();

    static DLightConfiguration create(FileObject fileObject) {
        return new DLightConfiguration(fileObject);
    }

    static DLightConfiguration createDefault() {
        FileObject fileObject = FileUtil.getConfigRoot();
        FileObject fileObject2 = fileObject.getFileObject("DLight/ToolConfigurationProviders");
        return new DLightConfiguration(fileObject.getFileObject("DLight"), ToolsConfiguration.createDefault(fileObject2));
    }

    private DLightConfiguration(FileObject fileObject) {
        this(fileObject, ToolsConfiguration.create(fileObject));
    }

    private DLightConfiguration(FileObject fileObject, ToolsConfiguration toolsConfiguration) {
        this.toolsConfiguration = toolsConfiguration;
        this.rootFolder = fileObject;
        this.configurationOptions = this.getConfigurationOptions();
        this.displayedName = fileObject.getAttribute("displayedName") == null ? fileObject.getName() : (String)fileObject.getAttribute("displayedName");
        this.isHidden = fileObject.getAttribute("hidden") != null && (Boolean)fileObject.getAttribute("hidden") != false;
        this.isSystem = fileObject.getAttribute("system") != null && (Boolean)fileObject.getAttribute("system") != false;
        this.isDefault = fileObject.getAttribute("default") != null && (Boolean)fileObject.getAttribute("default") != false;
        this.category = fileObject.getAttribute("category") == null ? fileObject.getName() : (String)fileObject.getAttribute("category");
        this.platforms = fileObject.getAttribute("platforms") == null ? null : ((String)fileObject.getAttribute("platforms")).split(",");
        this.collectorProviders = fileObject.getAttribute("collector.providers") == null ? null : (String)fileObject.getAttribute("collector.providers");
        this.indicatorProviders = fileObject.getAttribute("indicator.providers") == null ? null : ((String)fileObject.getAttribute("indicator.providers")).split(",");
    }

    public final String getDisplayedName() {
        return this.displayedName;
    }

    public final String getCategoryName() {
        return this.category;
    }

    public final List<String> getPlatforms() {
        return Arrays.asList(this.platforms);
    }

    public final String getCollectorProviders() {
        return this.collectorProviders;
    }

    public final List<String> getIndicatorProviders() {
        return Arrays.asList(this.indicatorProviders);
    }

    boolean isSystem() {
        return this.isSystem;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    final ToolsConfiguration getToolsConfiguration() {
        return this.toolsConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DLightTool> getToolsSet() {
        ToolsConfiguration toolsConfiguration = this.toolsConfiguration;
        synchronized (toolsConfiguration) {
            return this.toolsConfiguration.getToolsSet();
        }
    }

    public List<Indicator<?>> getIndicators() {
        ArrayList arrayList = new ArrayList();
        List<DLightTool> list = this.getToolsSet();
        for (DLightTool dLightTool : list) {
            arrayList.addAll(dLightTool.getIndicators());
        }
        return arrayList;
    }

    private final List<Indicator<?>> getEnabledIndicators() {
        ArrayList arrayList = new ArrayList();
        List<DLightTool> list = this.getToolsSet();
        for (DLightTool dLightTool : list) {
            if (!dLightTool.isEnabled()) continue;
            arrayList.addAll(dLightTool.getIndicators());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLightTool getToolByID(String string) {
        ArrayList<DLightTool> arrayList;
        if (string == null) {
            return null;
        }
        ToolsConfiguration toolsConfiguration = this.toolsConfiguration;
        synchronized (toolsConfiguration) {
            arrayList = new ArrayList<DLightTool>(this.toolsConfiguration.getToolsSet());
        }
        for (DLightTool dLightTool : arrayList) {
            if (!string.equals(dLightTool.getID())) continue;
            return dLightTool;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLightTool getToolByName(String string) {
        ArrayList<DLightTool> arrayList;
        if (string == null) {
            return null;
        }
        ToolsConfiguration toolsConfiguration = this.toolsConfiguration;
        synchronized (toolsConfiguration) {
            arrayList = new ArrayList<DLightTool>(this.toolsConfiguration.getToolsSet());
        }
        for (DLightTool dLightTool : arrayList) {
            if (!string.equals(dLightTool.getName())) continue;
            return dLightTool;
        }
        return null;
    }

    public DLightConfigurationOptions getConfigurationOptions(boolean bl) {
        if (bl) {
            this.getConfigurationOptions();
        }
        return this.configurationOptions;
    }

    FileObject getRootFolder() {
        return this.rootFolder;
    }

    private DLightConfigurationOptions getConfigurationOptions() {
        FileObject fileObject = this.rootFolder.getFileObject(CONFIGURATION_OPTIONS);
        if (fileObject == null) {
            return new DefaultConfigurationOption();
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        if (fileObjectArray == null || fileObjectArray.length == 0) {
            return new DefaultConfigurationOption();
        }
        for (FileObject fileObject2 : fileObjectArray) {
            Object object;
            DataObject dataObject = null;
            try {
                dataObject = DataObject.find((FileObject)fileObject2);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Logger.getLogger(ToolsConfiguration.class.getName()).log(Level.SEVERE, null, dataObjectNotFoundException);
            }
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
            if (instanceCookie == null) {
                object = "D-Light options configuration " + fileObject2.getName() + " not found";
                Logger.getLogger(ToolsConfiguration.class.getName()).log(Level.SEVERE, (String)object, new Exception((String)object));
                continue;
            }
            try {
                object = instanceCookie.instanceClass();
                DLightConfigurationOptions dLightConfigurationOptions = (DLightConfigurationOptions)((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
                dLightConfigurationOptions.addListener(this.listener);
                return dLightConfigurationOptions;
            }
            catch (InstantiationException instantiationException) {
                Exceptions.printStackTrace((Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Exceptions.printStackTrace((Throwable)illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Exceptions.printStackTrace((Throwable)illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Exceptions.printStackTrace((Throwable)invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Exceptions.printStackTrace((Throwable)noSuchMethodException);
            }
            catch (SecurityException securityException) {
                Exceptions.printStackTrace((Throwable)securityException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Exceptions.printStackTrace((Throwable)classNotFoundException);
            }
        }
        return null;
    }

    public String getConfigurationName() {
        return this.rootFolder.getName();
    }

    static {
        DLightConfigurationAccessor.setDefault(new DLightConfigurationAccessorImpl());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DLightConfigurationAccessorImpl
    extends DLightConfigurationAccessor {
        private DLightConfigurationAccessorImpl() {
        }

        @Override
        public List<Indicator<?>> getEnabledIndicators(DLightConfiguration dLightConfiguration) {
            return dLightConfiguration.getEnabledIndicators();
        }

        @Override
        public boolean isHidden(DLightConfiguration dLightConfiguration) {
            return dLightConfiguration.isHidden;
        }
    }

    private final class DLightConfigurationOptionsListenerImpl
    implements DLightConfigurationOptionsListener {
        private DLightConfigurationOptionsListenerImpl() {
        }

        public boolean dlightToolEnabling(String string, boolean bl) {
            if (DLightConfiguration.this.getToolByName(string) == null) {
                return false;
            }
            if (bl) {
                DLightConfiguration.this.getToolByName(string).enable();
            } else {
                DLightConfiguration.this.getToolByName(string).disable();
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultConfigurationOption
    implements DLightConfigurationOptions {
        private boolean turnState = true;

        private DefaultConfigurationOption() {
        }

        @Override
        public void turnCollectorsState(boolean bl) {
            this.turnState = bl;
        }

        @Override
        public boolean areCollectorsTurnedOn() {
            return this.turnState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<DLightTool> getToolsSet() {
            ToolsConfiguration toolsConfiguration = DLightConfiguration.this.toolsConfiguration;
            synchronized (toolsConfiguration) {
                return DLightConfiguration.this.toolsConfiguration.getToolsSet();
            }
        }

        @Override
        public List<DataCollector<?>> getCollectors(DLightTool dLightTool) {
            return dLightTool.getCollectors();
        }

        @Override
        public List<IndicatorDataProvider<?>> getIndicatorDataProviders(DLightTool dLightTool) {
            return dLightTool.getIndicatorDataProviders();
        }

        @Override
        public boolean validateToolsRequiredUserInteraction() {
            return true;
        }

        @Override
        public boolean profileOnRun() {
            return false;
        }

        @Override
        public Collection<String> getActiveToolNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DLightTool dLightTool : this.getToolsSet()) {
                if (!dLightTool.isEnabled()) continue;
                arrayList.add(dLightTool.getID());
            }
            return arrayList;
        }

        @Override
        public void addListener(DLightConfigurationOptionsListener dLightConfigurationOptionsListener) {
        }

        @Override
        public void removeListener(DLightConfigurationOptionsListener dLightConfigurationOptionsListener) {
        }
    }
}

