/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.impl.DLightToolConfigurationAccessor;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DLightToolConfiguration {
    private final String id;
    private final List<DataCollectorConfiguration> dataCollectors;
    private final List<IndicatorDataProviderConfiguration> indicatorDataProvidersConfiguration;
    private final List<IndicatorConfiguration> indicators;
    private String shortName;
    private String longName;
    private boolean visible;
    private String iconPath = null;
    private String shortDescription;
    private String detailsDescription;

    public DLightToolConfiguration(String string) {
        this(string, string);
    }

    public DLightToolConfiguration(String string, String string2) {
        this.id = string;
        this.shortName = string2;
        this.longName = string2;
        this.visible = true;
        this.dataCollectors = Collections.synchronizedList(new ArrayList());
        this.indicators = Collections.synchronizedList(new ArrayList());
        this.indicatorDataProvidersConfiguration = Collections.synchronizedList(new ArrayList());
    }

    public void addDataCollectorConfiguration(DataCollectorConfiguration dataCollectorConfiguration) {
        this.dataCollectors.add(dataCollectorConfiguration);
    }

    public void setIcon(String string) {
        this.iconPath = string;
    }

    public void setLongName(String string) {
        this.longName = string;
    }

    public void setDescription(String string) {
        this.shortDescription = string;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public String getID() {
        return this.id;
    }

    public void addIndicatorConfiguration(IndicatorConfiguration indicatorConfiguration) {
        this.indicators.add(indicatorConfiguration);
    }

    public void addIndicatorDataProviderConfiguration(IndicatorDataProviderConfiguration indicatorDataProviderConfiguration) {
        if (indicatorDataProviderConfiguration == null) {
            throw new NullPointerException("An attempt to add NULL IndicatorDataProviderConfiguration");
        }
        this.indicatorDataProvidersConfiguration.add(indicatorDataProviderConfiguration);
    }

    List<DataCollectorConfiguration> getDataCollectors() {
        return this.dataCollectors;
    }

    List<IndicatorDataProviderConfiguration> getIndicatorDataProviders() {
        return this.indicatorDataProvidersConfiguration;
    }

    List<IndicatorConfiguration> getIndicators() {
        return this.indicators;
    }

    String getShortName() {
        return this.shortName;
    }

    String getLongName() {
        return this.longName;
    }

    String getDescription() {
        return this.shortDescription;
    }

    boolean isVisible() {
        return this.visible;
    }

    static {
        DLightToolConfigurationAccessor.setDefault(new DLightToolConfigurationAccessorImpl());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DLightToolConfigurationAccessorImpl
    extends DLightToolConfigurationAccessor {
        private DLightToolConfigurationAccessorImpl() {
        }

        @Override
        public List<DataCollectorConfiguration> getDataCollectors(DLightToolConfiguration dLightToolConfiguration) {
            return dLightToolConfiguration.getDataCollectors();
        }

        @Override
        public List<IndicatorDataProviderConfiguration> getIndicatorDataProviders(DLightToolConfiguration dLightToolConfiguration) {
            return dLightToolConfiguration.getIndicatorDataProviders();
        }

        @Override
        public List<IndicatorConfiguration> getIndicators(DLightToolConfiguration dLightToolConfiguration) {
            return dLightToolConfiguration.getIndicators();
        }

        @Override
        public String getToolName(DLightToolConfiguration dLightToolConfiguration) {
            return dLightToolConfiguration.getShortName();
        }

        @Override
        public String getDetailedToolName(DLightToolConfiguration dLightToolConfiguration) {
            return dLightToolConfiguration.getLongName();
        }

        @Override
        public String getIconPath(DLightToolConfiguration dLightToolConfiguration) {
            return dLightToolConfiguration.iconPath;
        }

        @Override
        public String getToolDescription(DLightToolConfiguration dLightToolConfiguration) {
            return dLightToolConfiguration.getDescription();
        }
    }
}

