/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.spi.support;

import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.netbeans.modules.dlight.api.storage.types.TimeDuration;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.util.DLightExecutorService;

public final class TimerBasedVisualizerSupport
implements ComponentListener {
    private final Visualizer visualizer;
    private final TimeDuration refreshInterval;
    private Future future;
    private boolean isShown = true;

    public TimerBasedVisualizerSupport(Visualizer visualizer, TimeDuration timeDuration) {
        this.visualizer = visualizer;
        this.refreshInterval = timeDuration;
    }

    private final void startTimer() {
        if (this.future != null && !this.future.isCancelled()) {
            return;
        }
        this.future = DLightExecutorService.scheduleAtFixedRate((Runnable)new Runnable(){

            public void run() {
                TimerBasedVisualizerSupport.this.visualizer.refresh();
            }
        }, (long)this.refreshInterval.getValueIn(TimeUnit.MILLISECONDS), (TimeUnit)TimeUnit.MILLISECONDS, (String)("TimerBasedVisualizerSupport: timer for " + this.visualizer.toString()));
    }

    private final void stopTimer() {
        if (this.future != null) {
            this.future.cancel(false);
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        if (this.isShown) {
            return;
        }
        this.isShown = this.visualizer.getComponent().isShowing();
        if (this.isShown) {
            this.startTimer();
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.stopTimer();
        this.isShown = false;
    }

    public void start() {
        this.startTimer();
    }

    public void stop() {
        this.stopTimer();
    }
}

