/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.execute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.dataview.api.DataView;
import org.netbeans.modules.db.sql.execute.SQLExecutionLogger;
import org.netbeans.modules.db.sql.execute.SQLExecutionResult;
import org.netbeans.modules.db.sql.execute.SQLExecutionResults;
import org.netbeans.modules.db.sql.execute.StatementInfo;
import org.netbeans.modules.db.sql.history.SQLHistory;
import org.netbeans.modules.db.sql.history.SQLHistoryManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SQLExecuteHelper {
    public static final int DEFAULT_PAGE_SIZE = 20;
    private static final Logger LOGGER = Logger.getLogger(SQLExecuteHelper.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private static final FileObject USERDIR = FileUtil.getConfigRoot();

    public static SQLExecutionResults execute(String string, int n, int n2, DatabaseConnection databaseConnection, SQLExecutionLogger sQLExecutionLogger) {
        return SQLExecuteHelper.execute(string, n, n2, databaseConnection, sQLExecutionLogger, 20);
    }

    public static SQLExecutionResults execute(String string, int n, int n2, DatabaseConnection databaseConnection, SQLExecutionLogger sQLExecutionLogger, int n3) {
        boolean bl = false;
        List<StatementInfo> list = SQLExecuteHelper.getStatements(string, n, n2);
        ArrayList<SQLExecutionResult> arrayList = new ArrayList<SQLExecutionResult>();
        long l = 0L;
        String string2 = databaseConnection.getDatabaseURL();
        for (StatementInfo statementInfo : list) {
            bl = Thread.currentThread().isInterrupted();
            if (bl) break;
            String string3 = statementInfo.getSQL();
            SQLExecutionResult sQLExecutionResult = null;
            if (LOG) {
                LOGGER.log(Level.FINE, "Executing: " + string3);
            }
            DataView dataView = DataView.create((DatabaseConnection)databaseConnection, (String)string3, (int)n3);
            SQLHistoryManager.getInstance().saveSQL(new SQLHistory(string2, string3, new Date()));
            sQLExecutionResult = new SQLExecutionResult(statementInfo, dataView);
            boolean bl2 = false;
            for (Throwable throwable : dataView.getExceptions()) {
                if (!(throwable instanceof IllegalStateException)) continue;
                LOGGER.log(Level.INFO, throwable.getLocalizedMessage(), throwable);
                bl2 = true;
                break;
            }
            if (bl2) break;
            sQLExecutionLogger.log(sQLExecutionResult);
            l += sQLExecutionResult.getExecutionTime();
            arrayList.add(sQLExecutionResult);
        }
        if (!bl) {
            sQLExecutionLogger.finish(l);
        } else {
            if (LOG) {
                LOGGER.log(Level.FINE, "Execution cancelled");
            }
            sQLExecutionLogger.cancel();
        }
        SQLHistoryManager.getInstance().save(USERDIR);
        if (!bl) {
            return new SQLExecutionResults(arrayList);
        }
        return null;
    }

    private static List<StatementInfo> getStatements(String string, int n, int n2) {
        if (n == 0 && n2 == string.length() || n == n2) {
            List<StatementInfo> list = SQLExecuteHelper.split(string);
            if (n == 0 && n2 == string.length()) {
                return list;
            }
            for (StatementInfo statementInfo : list) {
                if (statementInfo.getRawStartOffset() > n || statementInfo.getRawEndOffset() < n2) continue;
                return Collections.singletonList(statementInfo);
            }
            return Collections.emptyList();
        }
        return SQLExecuteHelper.split(string.substring(n, n2));
    }

    public static List<StatementInfo> split(String string) {
        return new SQLSplitter(string).getStatements();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SQLSplitter {
        private static final int STATE_MEANINGFUL_TEXT = 0;
        private static final int STATE_MAYBE_LINE_COMMENT = 1;
        private static final int STATE_LINE_COMMENT = 2;
        private static final int STATE_MAYBE_BLOCK_COMMENT = 3;
        private static final int STATE_BLOCK_COMMENT = 4;
        private static final int STATE_MAYBE_END_BLOCK_COMMENT = 5;
        private static final int STATE_STRING = 6;
        private String sql;
        private int sqlLength;
        private StringBuffer statement = new StringBuffer();
        private List<StatementInfo> statements = new ArrayList<StatementInfo>();
        private int pos = 0;
        private int line = -1;
        private int column;
        private boolean wasEOL = true;
        private int rawStartOffset;
        private int startOffset;
        private int startLine;
        private int startColumn;
        private int endOffset;
        private int rawEndOffset;
        private int state = 0;
        private String delimiter = ";";
        private static final String DELIMITER_TOKEN = "delimiter";

        public SQLSplitter(String string) {
            assert (string != null);
            this.sql = string;
            this.sqlLength = string.length();
            this.parse();
        }

        private void parse() {
            this.checkDelimiterStatement();
            block9: while (this.pos < this.sqlLength) {
                char c = this.sql.charAt(this.pos);
                if (c == '\r') {
                    if (!LOG) continue;
                    LOGGER.log(Level.FINE, "The SQL string contained non-supported \r characters.");
                    continue;
                }
                this.nextColumn();
                switch (this.state) {
                    case 0: {
                        if (this.isDelimiter()) {
                            this.rawEndOffset = this.pos;
                            this.addStatement();
                            this.statement.setLength(0);
                            this.rawStartOffset = this.pos + this.delimiter.length();
                            this.pos += this.delimiter.length();
                            continue block9;
                        }
                        if (c == '-') {
                            this.state = 1;
                            break;
                        }
                        if (c == '/') {
                            this.state = 3;
                            break;
                        }
                        if (c == '#') {
                            this.state = 2;
                            break;
                        }
                        if (c != '\'') break;
                        this.state = 6;
                        break;
                    }
                    case 1: {
                        if (c == '-') {
                            this.state = 2;
                            break;
                        }
                        this.state = 0;
                        this.statement.append('-');
                        this.endOffset = this.pos;
                        break;
                    }
                    case 2: {
                        if (c != '\n') break;
                        this.state = 0;
                        break;
                    }
                    case 3: {
                        if (c == '*') {
                            this.state = 4;
                            break;
                        }
                        this.statement.append('/');
                        this.endOffset = this.pos;
                        if (c == '/') break;
                        this.state = 0;
                        break;
                    }
                    case 4: {
                        if (c != '*') break;
                        this.state = 5;
                        break;
                    }
                    case 5: {
                        if (c == '/') {
                            this.state = 0;
                            ++this.pos;
                            continue block9;
                        }
                        if (c == '*') break;
                        this.state = 4;
                        break;
                    }
                    case 6: {
                        if (c != '\'') break;
                        this.state = 0;
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                if (!(this.state != 0 && this.state != 6 || this.statement.length() <= 0 && Character.isWhitespace(c))) {
                    if (this.statement.length() == 0) {
                        if (this.checkDelimiterStatement()) continue;
                        this.startOffset = this.pos;
                        this.endOffset = this.pos;
                        this.startLine = this.line;
                        this.startColumn = this.column;
                    }
                    this.statement.append(c);
                    if (this.state == 6 || !Character.isWhitespace(c)) {
                        this.endOffset = this.pos + 1;
                    }
                }
                ++this.pos;
            }
            this.rawEndOffset = this.pos;
            this.addStatement();
        }

        private boolean checkDelimiterStatement() {
            int n;
            this.skipWhitespace();
            if (this.pos == this.sqlLength) {
                return false;
            }
            if (!this.isToken(DELIMITER_TOKEN)) {
                return false;
            }
            int n2 = DELIMITER_TOKEN.length();
            this.pos += n2;
            this.skipWhitespace();
            for (n = this.pos; n < this.sqlLength && !Character.isWhitespace(this.sql.charAt(n)); ++n) {
            }
            if (this.pos == n) {
                return false;
            }
            this.delimiter = this.sql.substring(this.pos, n);
            this.pos = n;
            this.statement.setLength(0);
            this.rawStartOffset = this.pos;
            return true;
        }

        private void skipWhitespace() {
            while (this.pos < this.sqlLength && Character.isWhitespace(this.sql.charAt(this.pos))) {
                this.nextColumn();
                ++this.pos;
            }
        }

        private boolean isDelimiter() {
            int n = this.delimiter.length();
            if (this.pos + n > this.sqlLength) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.delimiter.charAt(i) != this.sql.charAt(this.pos + i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private void nextColumn() {
            if (this.wasEOL) {
                ++this.line;
                this.column = 0;
                this.wasEOL = false;
            } else {
                ++this.column;
            }
            if (this.sql.charAt(this.pos) == '\n') {
                this.wasEOL = true;
            }
        }

        private boolean isToken(String string) {
            String string2;
            char c = this.sql.charAt(this.pos);
            if (Character.toUpperCase(c) != Character.toUpperCase(string.charAt(0))) {
                return false;
            }
            if (this.pos > 0 && !Character.isWhitespace(this.sql.charAt(this.pos - 1))) {
                return false;
            }
            if (this.sql.length() > this.pos + string.length() && Character.isLetterOrDigit(this.sql.charAt(this.pos + string.length()))) {
                return false;
            }
            try {
                string2 = this.sql.substring(this.pos, this.pos + string.length());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return false;
            }
            return string2.toUpperCase().equals(string.toUpperCase());
        }

        private void addStatement() {
            String string = this.statement.toString().trim();
            if (string.length() <= 0) {
                return;
            }
            StatementInfo statementInfo = new StatementInfo(string, this.rawStartOffset, this.startOffset, this.startLine, this.startColumn, this.endOffset, this.rawEndOffset);
            this.statements.add(statementInfo);
        }

        public List<StatementInfo> getStatements() {
            return Collections.unmodifiableList(this.statements);
        }
    }
}

