/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.loader;

import java.io.IOException;
import org.netbeans.modules.db.sql.loader.SQLEditorSupport;
import org.netbeans.modules.db.sql.loader.SQLNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class SQLDataObject
extends MultiDataObject {
    public SQLDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        CookieSet cookieSet = this.getCookieSet();
        final SQLEditorSupport sQLEditorSupport = new SQLEditorSupport(this);
        cookieSet.add((Node.Cookie)sQLEditorSupport);
        cookieSet.assign(SaveAsCapable.class, (Object[])new SaveAsCapable[]{new SaveAsCapable(){

            public void saveAs(FileObject fileObject, String string) throws IOException {
                sQLEditorSupport.saveAs(fileObject, string);
            }
        }});
    }

    protected Node createNodeDelegate() {
        return new SQLNode(this);
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    public boolean isConsole() {
        try {
            return "nbfs".equals(this.getPrimaryFile().getURL().getProtocol()) && !this.isTemplate();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return false;
        }
    }

    void addCookie(Node.Cookie cookie) {
        this.getCookieSet().add(cookie);
    }

    void removeCookie(Node.Cookie cookie) {
        this.getCookieSet().remove(cookie);
    }
}

