/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg;

import org.netbeans.microedition.svg.SVGAbstractButton;
import org.netbeans.microedition.svg.SVGForm;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;

public class SVGCheckBox
extends SVGAbstractButton {
    private static final String MARK = "mark";
    private static final String TEXT = "text";
    private static final String TITLE = "title";
    private static final String MARK_SUFFIX = "_mark";
    private static final String TITLE_SUFFIX = "_title";
    private SVGLocatableElement myMarkElement;
    private SVGLocatableElement myTextElement;
    private boolean isSelected;

    public SVGCheckBox(SVGForm form, String elemId) {
        super(form, elemId);
        this.initNestedElements();
        this.verify();
        this.setTraitSafely((SVGElement)this.myMarkElement, "visibility", "hidden");
        this.isSelected = false;
    }

    public void setSelected(boolean selected) {
        if (this.isSelected != selected) {
            this.setTraitSafely((SVGElement)this.myMarkElement, "visibility", selected ? "visible" : "hidden");
            this.isSelected = selected;
            this.fireActionPerformed();
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void pressButton() {
        this.form.activate(this);
        this.setSelected(!this.isSelected);
    }

    public String getText() {
        return this.myTextElement.getTrait("#text");
    }

    public void setText(String text) {
        this.setTraitSafely((SVGElement)this.myTextElement, "#text", text);
    }

    private void initNestedElements() {
        if (this.getElement().getId() != null) {
            this.myMarkElement = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + MARK_SUFFIX);
            this.myTextElement = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + TITLE_SUFFIX);
        }
        if (this.myMarkElement == null) {
            this.myMarkElement = (SVGLocatableElement)this.getNestedElementByMeta((SVGElement)this.getElement(), "type", MARK);
        }
        if (this.myTextElement == null) {
            this.myTextElement = (SVGLocatableElement)this.getNestedElementByMeta((SVGElement)this.getElement(), "type", TEXT);
        }
    }

    private void verify() {
        if (this.myMarkElement == null || this.myTextElement == null) {
            throw new IllegalArgumentException("Element with id=" + this.getElement().getId() + " couldn't be used for Checkbox." + " It doesn't have nested 'mark' or 'text' elements." + "See javadoc for SVG snippet format");
        }
    }
}

