/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.openide.modules.SpecificationVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UpdateUnitImpl {
    private String codeName;
    private UpdateElement installed;
    private List<UpdateElement> updates;
    private UpdateElement installedLocalization;
    private List<UpdateElement> localizationUpdates;
    private UpdateElement backup;
    private UpdateUnit updateUnit;
    private Logger err = Logger.getLogger(this.getClass().getName());

    public UpdateUnitImpl(String string) {
        this.codeName = string;
    }

    public void setUpdateUnit(UpdateUnit updateUnit) {
        assert (updateUnit != null) : "UpdateUnit cannot for " + this + " cannot be null.";
        this.updateUnit = updateUnit;
    }

    public UpdateUnit getUpdateUnit() {
        return this.updateUnit;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public UpdateElement getInstalled() {
        return this.installed;
    }

    public List<UpdateElement> getAvailableUpdates() {
        return this.identifyUpdates(this.getInstalled(), this.updates);
    }

    public UpdateElement getInstalledLocalization() {
        return this.installedLocalization;
    }

    public List<UpdateElement> getAvailableLocalizations() {
        return this.identifyLocalizationUpdates(this.installedLocalization, this.localizationUpdates);
    }

    public UpdateElement getBackup() {
        return this.backup;
    }

    public void addUpdate(UpdateElement updateElement) {
        int n;
        if (this.updates == null) {
            this.updates = new ArrayList<UpdateElement>();
        }
        if ((n = this.updates.indexOf(updateElement)) != -1) {
            this.updates.remove(updateElement);
        }
        this.updates.add(updateElement);
    }

    public void setInstalled(UpdateElement updateElement) {
        assert (this.installed == null);
        assert (updateElement != null);
        this.installed = updateElement;
    }

    public void setAsUninstalled() {
        assert (this.installed != null);
        this.installed = null;
    }

    public void updateInstalled(UpdateElement updateElement) {
        this.installed = null;
        this.setInstalled(updateElement);
    }

    public void addLocalizationUpdate(UpdateElement updateElement) {
        if (this.localizationUpdates == null) {
            this.localizationUpdates = new ArrayList<UpdateElement>();
        }
        assert (!this.localizationUpdates.contains(updateElement));
        this.localizationUpdates.add(updateElement);
    }

    public void setInstalledLocalization(UpdateElement updateElement) {
        assert (this.installedLocalization == null);
        this.installedLocalization = updateElement;
    }

    public void setBackup(UpdateElement updateElement) {
        assert (this.backup == null);
        this.backup = updateElement;
    }

    public boolean isPending() {
        return false;
    }

    public abstract UpdateManager.TYPE getType();

    protected List<UpdateElement> getUpdates() {
        return this.updates;
    }

    private List<UpdateElement> identifyUpdates(UpdateElement updateElement, List<UpdateElement> list) {
        List<UpdateElement> list2 = null;
        if (list != null && !list.isEmpty()) {
            if (updateElement == null) {
                if (list != null) {
                    list2 = list;
                }
            } else {
                String string = updateElement.getCodeName();
                ArrayList<UpdateElement> arrayList = new ArrayList<UpdateElement>();
                for (UpdateElement updateElement2 : list) {
                    String string2 = updateElement2.getSpecificationVersion();
                    String string3 = updateElement.getSpecificationVersion();
                    if (string2 != null && string3 == null) {
                        this.err.log(Level.FINE, "UpdateElement " + string + "[" + string3 + "] has update " + string + "[" + string2 + "]");
                        arrayList.add(updateElement2);
                        continue;
                    }
                    if (string2 == null || string3 == null || new SpecificationVersion(string2).compareTo((Object)new SpecificationVersion(string3)) <= 0) continue;
                    this.err.log(Level.FINE, "UpdateElement " + string + "[" + string3 + "] has update " + string + "[" + string2 + "]");
                    arrayList.add(updateElement2);
                }
                if (!arrayList.isEmpty()) {
                    list2 = arrayList;
                }
            }
        }
        if (list2 == null) {
            list2 = Collections.emptyList();
        } else if (list2.size() > 1) {
            Collections.sort(list2, new Comparator<UpdateElement>(){

                @Override
                public int compare(UpdateElement updateElement, UpdateElement updateElement2) {
                    String string = updateElement.getSpecificationVersion();
                    String string2 = updateElement2.getSpecificationVersion();
                    if (string == null) {
                        if (string2 == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (string2 == null) {
                        return 1;
                    }
                    return new SpecificationVersion(string2).compareTo((Object)new SpecificationVersion(string));
                }
            });
        }
        return list2;
    }

    private List<UpdateElement> identifyLocalizationUpdates(UpdateElement updateElement, List<UpdateElement> list) {
        ArrayList<UpdateElement> arrayList = null;
        if (list != null && !list.isEmpty()) {
            if (updateElement == null) {
                return list;
            }
            String string = updateElement.getCodeName();
            ArrayList<UpdateElement> arrayList2 = new ArrayList<UpdateElement>();
            for (UpdateElement updateElement2 : list) {
                if (updateElement2.getSpecificationVersion().compareTo(updateElement.getSpecificationVersion()) <= 0) continue;
                this.err.log(Level.FINE, "Module " + string + "[" + updateElement.getSpecificationVersion() + "] has update " + string + "[" + updateElement2.getSpecificationVersion() + "]");
                arrayList2.add(updateElement2);
            }
            if (!arrayList2.isEmpty()) {
                arrayList = arrayList2;
            }
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UpdateUnitImpl updateUnitImpl = (UpdateUnitImpl)object;
        if (!(this.codeName == updateUnitImpl.codeName || this.codeName != null && this.codeName.equals(updateUnitImpl.codeName))) {
            return false;
        }
        if (!(this.installed == updateUnitImpl.installed || this.installed != null && this.installed.equals(updateUnitImpl.installed))) {
            return false;
        }
        if (!(this.updates == updateUnitImpl.updates || this.updates != null && ((Object)this.updates).equals(updateUnitImpl.updates))) {
            return false;
        }
        if (!(this.installedLocalization == updateUnitImpl.installedLocalization || this.installedLocalization != null && this.installedLocalization.equals(updateUnitImpl.installedLocalization))) {
            return false;
        }
        if (!(this.localizationUpdates == updateUnitImpl.localizationUpdates || this.localizationUpdates != null && ((Object)this.localizationUpdates).equals(updateUnitImpl.localizationUpdates))) {
            return false;
        }
        return this.backup == updateUnitImpl.backup || this.backup != null && this.backup.equals(updateUnitImpl.backup);
    }

    public int hashCode() {
        int n = 7;
        n = 53 * n + (this.codeName != null ? this.codeName.hashCode() : 0);
        n = 53 * n + (this.installed != null ? this.installed.hashCode() : 0);
        n = 53 * n + (this.updates != null ? ((Object)this.updates).hashCode() : 0);
        n = 53 * n + (this.installedLocalization != null ? this.installedLocalization.hashCode() : 0);
        n = 53 * n + (this.localizationUpdates != null ? ((Object)this.localizationUpdates).hashCode() : 0);
        n = 53 * n + (this.backup != null ? this.backup.hashCode() : 0);
        return n;
    }
}

