/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.lib2.highlighting.HighlightingManager;
import org.netbeans.spi.editor.highlighting.HighlightAttributeValue;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.RequestProcessor;

public class NbToolTip
extends FileChangeAdapter {
    private static final Logger LOG = Logger.getLogger(NbToolTip.class.getName());
    private static final HashMap<String, WeakReference<NbToolTip>> mime2tip = new HashMap();
    private static final AtomicInteger lastRequestId = new AtomicInteger(0);
    private final String mimeType;
    private Annotation[] tipAnnotations;
    private static final RequestProcessor toolTipRP = new RequestProcessor("ToolTip-Evaluator", 1);
    private static volatile Reference<RequestProcessor.Task> lastToolTipTask = new WeakReference<Object>(null);

    static synchronized void buildToolTip(JTextComponent jTextComponent) {
        String string = NbEditorUtilities.getMimeType(jTextComponent.getDocument());
        NbToolTip nbToolTip = NbToolTip.getTip(string);
        nbToolTip.buildTip(jTextComponent);
    }

    private static int newRequestId() {
        return lastRequestId.incrementAndGet();
    }

    private static int getLastRequestId() {
        return lastRequestId.get();
    }

    private NbToolTip(String string) {
        this.mimeType = string;
    }

    private static NbToolTip getTip(String string) {
        NbToolTip nbToolTip;
        WeakReference<NbToolTip> weakReference = mime2tip.get(string);
        NbToolTip nbToolTip2 = nbToolTip = weakReference == null ? null : (NbToolTip)((Object)weakReference.get());
        if (nbToolTip == null) {
            nbToolTip = new NbToolTip(string);
            mime2tip.put(string, new WeakReference<NbToolTip>(nbToolTip));
        }
        return nbToolTip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Annotation[] getTipAnnotations() {
        FileObject fileObject = NbToolTip.class;
        synchronized (NbToolTip.class) {
            Annotation[] annotationArray = this.tipAnnotations;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (annotationArray != null) return annotationArray;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Searching for tooltip annotations for mimeType = '" + this.mimeType + "'");
            }
            fileObject = FileUtil.getConfigFile((String)("Editors/" + this.mimeType + "/ToolTips"));
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("tooltip annotation folder = '" + fileObject + "'");
            }
            if (fileObject != null) {
                Object object;
                ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
                Enumeration enumeration = fileObject.getChildren(false);
                while (enumeration.hasMoreElements()) {
                    object = (FileObject)enumeration.nextElement();
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("tooltip annotation fileobject=" + object);
                    }
                    try {
                        DataObject dataObject = DataObject.find((FileObject)object);
                        InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("tooltip annotation instanceCookie=" + instanceCookie);
                        }
                        if (instanceCookie == null) continue;
                        Object object2 = instanceCookie.instanceCreate();
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("tooltip annotation instance=" + object2);
                        }
                        if (!(object2 instanceof Annotation)) continue;
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Found tooltip annotation = " + object2 + ", class = " + object2.getClass() + " for mimeType = '" + this.mimeType + "'");
                        }
                        arrayList.add((Annotation)object2);
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        LOG.log(Level.FINE, null, dataObjectNotFoundException);
                    }
                    catch (IOException iOException) {
                        LOG.log(Level.FINE, null, iOException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        LOG.log(Level.FINE, null, classNotFoundException);
                    }
                }
                annotationArray = arrayList.toArray(new Annotation[arrayList.size()]);
                object = NbToolTip.class;
                synchronized (NbToolTip.class) {
                    this.tipAnnotations = annotationArray;
                    // ** MonitorExit[var5_7 /* !! */ ] (shouldn't be in output)
                    fileObject.addFileChangeListener((FileChangeListener)this);
                    return annotationArray;
                }
            }
            Class<NbToolTip> clazz = NbToolTip.class;
            synchronized (NbToolTip.class) {
                this.tipAnnotations = new Annotation[0];
                // ** MonitorExit[var3_5] (shouldn't be in output)
                return annotationArray;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTip(JTextComponent jTextComponent) {
        EditorCookie editorCookie;
        DataObject dataObject;
        ToolTipSupport toolTipSupport;
        EditorUI editorUI = Utilities.getEditorUI((JTextComponent)jTextComponent);
        ToolTipSupport toolTipSupport2 = toolTipSupport = editorUI == null ? null : editorUI.getToolTipSupport();
        if (toolTipSupport == null) {
            return;
        }
        String string = jTextComponent.getUI().getToolTipText(jTextComponent, toolTipSupport.getLastMouseEvent().getPoint());
        if (string != null) {
            return;
        }
        Annotation[] annotationArray = this.getTipAnnotations();
        BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
        if (baseDocument != null && (dataObject = NbEditorUtilities.getDataObject((Document)baseDocument)) != null && dataObject.isValid() && (editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)) != null) {
            StyledDocument styledDocument = editorCookie.getDocument();
            if (styledDocument != baseDocument) {
                return;
            }
            baseDocument.readLock();
            try {
                BaseKit baseKit;
                Point point = toolTipSupport.getLastMouseEvent().getPoint();
                int n = NbToolTip.getOffsetForPoint(point, jTextComponent, baseDocument);
                if (n >= 0 && (baseKit = Utilities.getKit((JTextComponent)jTextComponent)) instanceof NbEditorKit) {
                    int n2;
                    HighlightsSequence highlightsSequence;
                    Object object = null;
                    Line.Part part = null;
                    Annotation[] annotationArray2 = null;
                    AnnotationDesc annotationDesc = null;
                    HighlightsContainer highlightsContainer = (HighlightsContainer)jTextComponent.getClientProperty("TooltipHighlightsContainer");
                    if (highlightsContainer == null) {
                        highlightsContainer = HighlightingManager.getInstance().getHighlights(jTextComponent, null);
                        jTextComponent.putClientProperty("TooltipHighlightsContainer", highlightsContainer);
                    }
                    if ((highlightsSequence = highlightsContainer.getHighlights(n, n + 1)).moveNext()) {
                        object = highlightsSequence.getAttributes().getAttribute(EditorStyleConstants.Tooltip);
                    }
                    if (annotationArray != null) {
                        Line line;
                        n2 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n);
                        int n3 = n - Utilities.getRowStart((JTextComponent)jTextComponent, (int)n);
                        Line.Set set = editorCookie.getLineSet();
                        if (set != null && (line = set.getCurrent(n2)) != null && (part = line.createPart(n3, 0)) != null) {
                            annotationDesc = baseDocument.getAnnotations().getActiveAnnotation(n2);
                            if (annotationDesc != null && (n < annotationDesc.getOffset() || n >= annotationDesc.getOffset() + annotationDesc.getLength())) {
                                annotationDesc = null;
                            }
                            annotationArray2 = annotationArray;
                        }
                    }
                    if (part != null && annotationArray2 != null || object != null) {
                        n2 = NbToolTip.newRequestId();
                        RequestProcessor.Task task = lastToolTipTask.get();
                        if (task != null) {
                            task.cancel();
                        }
                        lastToolTipTask = new WeakReference<RequestProcessor.Task>(toolTipRP.post((Runnable)new Request(annotationDesc, annotationArray2, part, n, object, toolTipSupport, jTextComponent, (AbstractDocument)baseDocument, (NbEditorKit)baseKit, n2)));
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                LOG.log(Level.FINE, null, badLocationException);
            }
            finally {
                baseDocument.readUnlock();
            }
        }
    }

    private static int getOffsetForPoint(Point point, JTextComponent jTextComponent, BaseDocument baseDocument) throws BadLocationException {
        if (point.x >= 0 && point.y >= 0) {
            int n = jTextComponent.viewToModel(point);
            Rectangle rectangle = jTextComponent.modelToView(n);
            EditorUI editorUI = Utilities.getEditorUI((JTextComponent)jTextComponent);
            if (editorUI != null && rectangle.y == point.y / editorUI.getLineHeight() * editorUI.getLineHeight() && n < Utilities.getRowEnd((BaseDocument)baseDocument, (int)n)) {
                return n;
            }
        }
        return -1;
    }

    private static class Request
    implements Runnable,
    PropertyChangeListener,
    DocumentListener {
        private ToolTipSupport tts;
        private final Annotation[] annos;
        private final AnnotationDesc annoDesc;
        private final Line.Part linePart;
        private final JTextComponent component;
        private final AbstractDocument doc;
        private final NbEditorKit kit;
        private final int offset;
        private final Object tooltipAttributeValue;
        private final int requestId;
        private boolean documentModified;

        Request(AnnotationDesc annotationDesc, Annotation[] annotationArray, Line.Part part, int n, Object object, ToolTipSupport toolTipSupport, JTextComponent jTextComponent, AbstractDocument abstractDocument, NbEditorKit nbEditorKit, int n2) {
            this.annoDesc = annotationDesc;
            this.annos = annotationArray;
            this.linePart = part;
            this.tts = toolTipSupport;
            this.component = jTextComponent;
            this.doc = abstractDocument;
            this.kit = nbEditorKit;
            this.offset = n;
            this.tooltipAttributeValue = object;
            this.requestId = n2;
        }

        public void run() {
            String string;
            if (this.tts == null) {
                return;
            }
            if (this.tts == null || this.tts.getStatus() == 0) {
                return;
            }
            if (!this.isRequestValid()) {
                return;
            }
            if (this.tts != null) {
                this.tts.addPropertyChangeListener((PropertyChangeListener)this);
            }
            if ((string = this.resolveTooltipText()) != null && string.length() > 0 && this.isRequestValid()) {
                Utilities.runInEventDispatchThread((Runnable)new Runnable(){

                    public void run() {
                        ToolTipSupport toolTipSupport = Request.this.tts;
                        if (toolTipSupport != null) {
                            toolTipSupport.setToolTipText(string);
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String resolveTooltipText() {
            String string;
            block22: {
                this.kit.toolTipAnnotationsLock(this.doc);
                try {
                    this.doc.readLock();
                    if (!this.isRequestValid()) {
                        String string2 = null;
                        return string2;
                    }
                    string = null;
                    if (this.annos != null) {
                        int n;
                        for (n = 0; n < this.annos.length; ++n) {
                            this.annos[n].attach((Annotatable)this.linePart);
                        }
                        if (this.annoDesc != null) {
                            string = this.annoDesc.getShortDescription();
                            this.annoDesc.addPropertyChangeListener((PropertyChangeListener)this);
                        } else {
                            for (n = 0; n < this.annos.length; ++n) {
                                String string3 = this.annos[n].getShortDescription();
                                if (string3 != null) {
                                    string = string3;
                                }
                                this.annos[n].addPropertyChangeListener((PropertyChangeListener)this);
                            }
                        }
                    }
                    if (string == null) break block22;
                    String string4 = string;
                    return string4;
                    finally {
                        this.doc.readUnlock();
                    }
                }
                finally {
                    this.kit.toolTipAnnotationsUnlock(this.doc);
                }
            }
            if (!this.isRequestValid()) {
                return null;
            }
            string = null;
            if (this.tooltipAttributeValue != null) {
                if (this.tooltipAttributeValue instanceof String) {
                    string = (String)this.tooltipAttributeValue;
                } else if (this.tooltipAttributeValue instanceof HighlightAttributeValue) {
                    String string5;
                    string = string5 = (String)((HighlightAttributeValue)this.tooltipAttributeValue).getValue(this.component, (Document)this.doc, EditorStyleConstants.Tooltip, this.offset, this.offset + 1);
                } else {
                    LOG.fine("Invalid '" + EditorStyleConstants.Tooltip + "' attribute value " + this.tooltipAttributeValue);
                }
            }
            return string;
        }

        private boolean isRequestValid() {
            return NbToolTip.getLastRequestId() == this.requestId && !this.documentModified && this.isDocumentValid();
        }

        private boolean isDocumentValid() {
            EditorCookie editorCookie;
            DataObject dataObject = NbEditorUtilities.getDataObject(this.doc);
            if (dataObject != null && (editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)) != null) {
                StyledDocument styledDocument;
                try {
                    styledDocument = editorCookie.openDocument();
                }
                catch (IOException iOException) {
                    styledDocument = null;
                }
                return styledDocument == this.doc;
            }
            return false;
        }

        private void dismiss() {
            if (this.tts != null) {
                this.tts.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.tts = null;
            if (this.annoDesc != null) {
                this.annoDesc.removePropertyChangeListener((PropertyChangeListener)this);
            } else if (this.annos != null) {
                for (int i = 0; i < this.annos.length; ++i) {
                    this.annos[i].removePropertyChangeListener((PropertyChangeListener)this);
                    this.annos[i].detach();
                }
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("shortDescription".equals(string) || "shortDescription".equals(string)) {
                if (propertyChangeEvent.getNewValue() != null) {
                    final String string2 = (String)propertyChangeEvent.getNewValue();
                    Utilities.runInEventDispatchThread((Runnable)new Runnable(){

                        public void run() {
                            ToolTipSupport toolTipSupport = Request.this.tts;
                            if (toolTipSupport != null) {
                                toolTipSupport.setToolTipText(string2);
                            }
                        }
                    });
                }
            } else if ("status".equals(string) && (Integer)propertyChangeEvent.getNewValue() == 0) {
                this.dismiss();
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.documentModified = true;
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.documentModified = true;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

