/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.refactoring.rename;

import java.text.MessageFormat;
import java.util.List;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.web.refactoring.WebXmlRefactoring;
import org.netbeans.modules.web.refactoring.rename.RenameItem;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseWebXmlRename
extends WebXmlRefactoring {
    public BaseWebXmlRename(FileObject fileObject, WebApp webApp) {
        super(fileObject, webApp);
    }

    protected abstract AbstractRefactoring getRefactoring();

    protected abstract List<RenameItem> getRenameItems();

    @Override
    public final Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Problem problem = null;
        Problem problem2 = null;
        for (RenameItem renameItem : this.getRenameItems()) {
            String string = renameItem.getNewFqn();
            String string2 = renameItem.getOldFqn();
            if (renameItem.getProblem() != null) {
                if (problem == null) {
                    problem2 = problem = renameItem.getProblem();
                    continue;
                }
                problem2.setNext(renameItem.getProblem());
                problem2 = renameItem.getProblem();
                continue;
            }
            for (Servlet servlet : this.getServlets(string2)) {
                refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new ServletRenameElement(string, string2, this.webModel, this.webDD, servlet));
            }
            for (Listener listener : this.getListeners(string2)) {
                refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new ListenerRenameElement(string, string2, this.webModel, this.webDD, listener));
            }
            for (Filter filter : this.getFilters(string2)) {
                refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new FilterRenameElement(string, string2, this.webModel, this.webDD, filter));
            }
            for (EjbRef ejbRef : this.getEjbRefs(string2, true)) {
                refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new EjbRemoteRefRenameElement(string, string2, this.webModel, this.webDD, ejbRef));
            }
            for (EjbRef ejbRef : this.getEjbRefs(string2, false)) {
                refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new EjbHomeRefRenameElement(string, string2, this.webModel, this.webDD, ejbRef));
            }
            for (EjbLocalRef ejbLocalRef : this.getEjbLocalRefs(string2, false)) {
                refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new EjbLocalRefRenameElement(string, string2, this.webModel, this.webDD, ejbLocalRef));
            }
            for (EjbLocalRef ejbLocalRef : this.getEjbLocalRefs(string2, true)) {
                refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new EjbLocalHomeRefRenameElement(string, string2, this.webModel, this.webDD, ejbLocalRef));
            }
        }
        return problem;
    }

    private static class EjbLocalHomeRefRenameElement
    extends WebRenameElement {
        private EjbLocalRef ejbLocalRef;

        public EjbLocalHomeRefRenameElement(String string, String string2, WebApp webApp, FileObject fileObject, EjbLocalRef ejbLocalRef) {
            super(string, string2, webApp, fileObject);
            this.ejbLocalRef = ejbLocalRef;
        }

        protected void doChange() {
            this.ejbLocalRef.setLocalHome(this.newName);
        }

        public String getDisplayText() {
            Object[] objectArray = new Object[]{this.getParentFile().getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(BaseWebXmlRename.class, (String)"TXT_WebXmlRefLocalHomeRename"), objectArray);
        }

        protected void undo() {
            this.ejbLocalRef.setLocalHome(this.oldName);
        }
    }

    private static class EjbLocalRefRenameElement
    extends WebRenameElement {
        private EjbLocalRef ejbLocalRef;

        public EjbLocalRefRenameElement(String string, String string2, WebApp webApp, FileObject fileObject, EjbLocalRef ejbLocalRef) {
            super(string, string2, webApp, fileObject);
            this.ejbLocalRef = ejbLocalRef;
        }

        protected void doChange() {
            this.ejbLocalRef.setLocal(this.newName);
        }

        public String getDisplayText() {
            Object[] objectArray = new Object[]{this.getParentFile().getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(BaseWebXmlRename.class, (String)"TXT_WebXmlRefLocalRename"), objectArray);
        }

        protected void undo() {
            this.ejbLocalRef.setLocal(this.oldName);
        }
    }

    private static class EjbRemoteRefRenameElement
    extends WebRenameElement {
        private EjbRef ejbRef;

        public EjbRemoteRefRenameElement(String string, String string2, WebApp webApp, FileObject fileObject, EjbRef ejbRef) {
            super(string, string2, webApp, fileObject);
            this.ejbRef = ejbRef;
        }

        protected void doChange() {
            this.ejbRef.setRemote(this.newName);
        }

        public String getDisplayText() {
            Object[] objectArray = new Object[]{this.getParentFile().getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(BaseWebXmlRename.class, (String)"TXT_WebXmlRefRemoteRename"), objectArray);
        }

        protected void undo() {
            this.ejbRef.setRemote(this.oldName);
        }
    }

    private static class EjbHomeRefRenameElement
    extends WebRenameElement {
        private EjbRef ejbRef;

        public EjbHomeRefRenameElement(String string, String string2, WebApp webApp, FileObject fileObject, EjbRef ejbRef) {
            super(string, string2, webApp, fileObject);
            this.ejbRef = ejbRef;
        }

        protected void doChange() {
            this.ejbRef.setHome(this.newName);
        }

        public String getDisplayText() {
            Object[] objectArray = new Object[]{this.getParentFile().getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(BaseWebXmlRename.class, (String)"TXT_WebXmlRefHomeRename"), objectArray);
        }

        protected void undo() {
            this.ejbRef.setHome(this.oldName);
        }
    }

    private static class ListenerRenameElement
    extends WebRenameElement {
        private Listener listener;

        public ListenerRenameElement(String string, String string2, WebApp webApp, FileObject fileObject, Listener listener) {
            super(string, string2, webApp, fileObject);
            this.listener = listener;
        }

        protected void doChange() {
            this.listener.setListenerClass(this.newName);
        }

        public String getDisplayText() {
            Object[] objectArray = new Object[]{this.getParentFile().getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(BaseWebXmlRename.class, (String)"TXT_WebXmlListenerRename"), objectArray);
        }

        protected void undo() {
            this.listener.setListenerClass(this.oldName);
        }
    }

    private static class FilterRenameElement
    extends WebRenameElement {
        private Filter filter;

        public FilterRenameElement(String string, String string2, WebApp webApp, FileObject fileObject, Filter filter) {
            super(string, string2, webApp, fileObject);
            this.filter = filter;
        }

        protected void doChange() {
            this.filter.setFilterClass(this.newName);
        }

        public String getDisplayText() {
            Object[] objectArray = new Object[]{this.getParentFile().getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(BaseWebXmlRename.class, (String)"TXT_WebXmlFilterRename"), objectArray);
        }

        protected void undo() {
            this.filter.setFilterClass(this.oldName);
        }
    }

    private static class ServletRenameElement
    extends WebRenameElement {
        private Servlet servlet;

        public ServletRenameElement(String string, String string2, WebApp webApp, FileObject fileObject, Servlet servlet) {
            super(string, string2, webApp, fileObject);
            this.servlet = servlet;
        }

        protected void doChange() {
            this.servlet.setServletClass(this.newName);
        }

        public String getDisplayText() {
            Object[] objectArray = new Object[]{this.getParentFile().getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(BaseWebXmlRename.class, (String)"TXT_WebXmlServletRename"), objectArray);
        }

        protected void undo() {
            this.servlet.setServletClass(this.oldName);
        }
    }

    private static abstract class WebRenameElement
    extends WebXmlRefactoring.WebRefactoringElement {
        protected String oldName;
        protected String newName;

        public WebRenameElement(String string, String string2, WebApp webApp, FileObject fileObject) {
            super(webApp, fileObject);
            this.newName = string;
            this.oldName = string2;
        }

        protected String getName() {
            return this.oldName;
        }
    }
}

