/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.reader;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.netbeans.modules.cnd.dwarfdump.Magic;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.ATE;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.ATTR;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.FORM;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.LANG;
import org.netbeans.modules.cnd.dwarfdump.reader.ElfReader;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfAbbriviationTableSection;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfArangesSection;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfAttribute;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfDebugInfoSection;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfLineInfoSection;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfMacroInfoSection;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfNameLookupTableSection;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfRelaDebugInfoSection;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;
import org.netbeans.modules.cnd.dwarfdump.section.StringTableSection;

public class DwarfReader
extends ElfReader {
    public DwarfReader(String string, RandomAccessFile randomAccessFile, Magic magic, long l, long l2) throws IOException {
        super(string, randomAccessFile, magic, l, l2);
        this.getSection(".debug_str");
    }

    public Object readAttrValue(DwarfAttribute dwarfAttribute) throws IOException {
        Object object = this.readForm(dwarfAttribute.valueForm);
        if (dwarfAttribute.attrName.equals((Object)ATTR.DW_AT_language)) {
            return LANG.get(((Number)object).intValue());
        }
        if (dwarfAttribute.attrName.equals((Object)ATTR.DW_AT_encoding)) {
            return ATE.get(((Byte)object).byteValue());
        }
        if (dwarfAttribute.attrName.equals((Object)ATTR.DW_AT_decl_line)) {
            return ((Number)object).intValue();
        }
        return object;
    }

    public Object readForm(FORM fORM) throws IOException {
        if (fORM.equals((Object)FORM.DW_FORM_addr)) {
            return this.read(new byte[this.getAddressSize()]);
        }
        if (fORM.equals((Object)FORM.DW_FORM_block2)) {
            return this.read(new byte[this.readShort()]);
        }
        if (fORM.equals((Object)FORM.DW_FORM_block4)) {
            return this.read(new byte[this.readInt()]);
        }
        if (fORM.equals((Object)FORM.DW_FORM_data2)) {
            return this.readShort();
        }
        if (fORM.equals((Object)FORM.DW_FORM_data4)) {
            return this.readInt();
        }
        if (fORM.equals((Object)FORM.DW_FORM_data8)) {
            return this.readLong();
        }
        if (fORM.equals((Object)FORM.DW_FORM_string)) {
            return this.readString();
        }
        if (fORM.equals((Object)FORM.DW_FORM_block)) {
            return this.read(new byte[this.readUnsignedLEB128()]);
        }
        if (fORM.equals((Object)FORM.DW_FORM_block1)) {
            return this.read(new byte[this.readUnsignedByte()]);
        }
        if (fORM.equals((Object)FORM.DW_FORM_data1)) {
            return this.readByte();
        }
        if (fORM.equals((Object)FORM.DW_FORM_flag)) {
            return this.readBoolean();
        }
        if (fORM.equals((Object)FORM.DW_FORM_sdata)) {
            return this.readSignedLEB128();
        }
        if (fORM.equals((Object)FORM.DW_FORM_strp)) {
            return ((StringTableSection)this.getSection(".debug_str")).getString(this.readInt());
        }
        if (fORM.equals((Object)FORM.DW_FORM_udata)) {
            return this.readUnsignedLEB128();
        }
        if (fORM.equals((Object)FORM.DW_FORM_ref_addr)) {
            return this.read(new byte[this.getAddressSize()]);
        }
        if (fORM.equals((Object)FORM.DW_FORM_ref1)) {
            return this.read(new byte[this.readUnsignedByte()]);
        }
        if (fORM.equals((Object)FORM.DW_FORM_ref2)) {
            return this.read(new byte[2]);
        }
        if (fORM.equals((Object)FORM.DW_FORM_ref4)) {
            return this.readInt();
        }
        if (fORM.equals((Object)FORM.DW_FORM_ref8)) {
            return this.readLong();
        }
        if (fORM.equals((Object)FORM.DW_FORM_ref_udata)) {
            return this.read(new byte[this.readUnsignedLEB128()]);
        }
        if (fORM.equals((Object)FORM.DW_FORM_indirect)) {
            return this.readForm(FORM.get(this.readUnsignedLEB128()));
        }
        throw new IOException("unknown type " + (Object)((Object)fORM));
    }

    ElfSection initSection(Integer n, String string) {
        if (string.equals(".debug_str")) {
            return new StringTableSection((ElfReader)this, n);
        }
        if (string.equals(".debug_aranges")) {
            return new DwarfArangesSection(this, (int)n);
        }
        if (string.equals(".debug_info")) {
            return new DwarfDebugInfoSection(this, (int)n);
        }
        if (string.equals(".rela.debug_info")) {
            return new DwarfRelaDebugInfoSection(this, (int)n);
        }
        if (string.equals(".debug_abbrev")) {
            return new DwarfAbbriviationTableSection(this, n);
        }
        if (string.equals(".debug_line")) {
            return new DwarfLineInfoSection(this, (int)n);
        }
        if (string.equals(".debug_macinfo")) {
            return new DwarfMacroInfoSection(this, (int)n);
        }
        if (string.equals(".debug_pubnames")) {
            return new DwarfNameLookupTableSection(this, (int)n);
        }
        return null;
    }
}

