/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.compilers;

import java.io.File;
import org.netbeans.modules.cnd.api.compilers.ToolchainManager;
import org.netbeans.modules.cnd.api.utils.Path;
import org.netbeans.modules.cnd.compilers.impl.ToolchainManagerImpl;
import org.openide.util.Utilities;

public final class CompilerSetUtils {
    private static String cygwinBase;
    private static String msysBase;

    private CompilerSetUtils() {
    }

    public static String getCygwinBase() {
        if (cygwinBase == null) {
            Object object;
            ToolchainManagerImpl toolchainManagerImpl = ToolchainManager.getImpl();
            ToolchainManager.ToolchainDescriptor toolchainDescriptor = toolchainManagerImpl.getToolchain("Cygwin", 3);
            if (toolchainDescriptor != null && (object = toolchainManagerImpl.getBaseFolder(toolchainDescriptor, 3)) != null) {
                cygwinBase = ((String)object).substring(0, ((String)object).length() - 4).replace("\\", "/");
            }
            if (cygwinBase == null) {
                for (String string : Path.getPath()) {
                    if (!(string = string.toLowerCase().replace("\\", "/")).contains("cygwin")) continue;
                    if (string.endsWith("/")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    if (string.toLowerCase().endsWith("/usr/bin")) {
                        cygwinBase = string.substring(0, string.length() - 8);
                        break;
                    }
                    if (!string.toLowerCase().endsWith("/bin")) continue;
                    cygwinBase = string.substring(0, string.length() - 4);
                    break;
                }
            }
        }
        return cygwinBase;
    }

    public static String getMSysBase() {
        if (msysBase == null && Utilities.isWindows()) {
            ToolchainManagerImpl toolchainManagerImpl = ToolchainManager.getImpl();
            for (ToolchainManager.ToolchainDescriptor object : toolchainManagerImpl.getToolchains(3)) {
                String string;
                if (object == null || (string = toolchainManagerImpl.getCommandFolder(object, 3)) == null) continue;
                msysBase = string.substring(0, string.length() - 4).replace("\\", "/");
                break;
            }
            if (msysBase == null) {
                for (String string : Path.getPath()) {
                    String string2 = string.toLowerCase().replace("\\", "/");
                    if (!string2.contains("/msys/1.0") || !string2.toLowerCase().contains("/bin")) continue;
                    msysBase = string2.substring(0, string2.length() - 4);
                    break;
                }
            }
        }
        return msysBase;
    }

    static String getPlatformName(int n) {
        switch (n) {
            case 2: {
                return "linux";
            }
            case 0: {
                return "sun_sparc";
            }
            case 1: {
                return "sun_intel";
            }
            case 3: {
                return "windows";
            }
            case 4: {
                return "mac";
            }
        }
        return "none";
    }

    public static int computeLocalPlatform() {
        String string = System.getProperty("os.name");
        if (string.equals("SunOS")) {
            return System.getProperty("os.arch").equals("x86") ? 1 : 0;
        }
        if (string.startsWith("Windows ")) {
            return 3;
        }
        if (string.toLowerCase().contains("linux")) {
            return 2;
        }
        if (string.toLowerCase().contains("mac") || string.startsWith("Darwin")) {
            return 4;
        }
        return 5;
    }

    static String findCommand(String string) {
        String string2;
        String string3 = Path.findCommand(string);
        if (string3 == null && (string2 = CompilerSetUtils.getMSysBase()) != null) {
            string3 = CompilerSetUtils.findCommand(string, string2 + "/bin");
        }
        return string3;
    }

    static String findCommand(String string, String string2) {
        String string3 = null;
        if (string.length() > 0) {
            File file;
            File file2;
            if (Utilities.isWindows() && !string.endsWith(".exe")) {
                string3 = string + ".exe";
            }
            if ((file2 = new File(string2, string)).exists()) {
                return file2.getAbsolutePath();
            }
            if (Utilities.isWindows() && string.endsWith(".exe") && (file = new File(string2, string + ".lnk")).exists()) {
                return file2.getAbsolutePath();
            }
            if (string3 != null) {
                file2 = new File(string2, string3);
                if (file2.exists()) {
                    return file2.getAbsolutePath();
                }
                file = new File(string2, string3 + ".lnk");
                if (file.exists()) {
                    return file2.getAbsolutePath();
                }
            }
        }
        return null;
    }
}

