/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.builds;

import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.util.WeakSet;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

@Deprecated
public class OutputWindowOutputStream
extends OutputStream {
    private static final ErrorManager errMgr = ErrorManager.getDefault().getInstance("org.netbeans.modules.cnd");
    private OutputWriter writer;
    private StringBuffer buffer = new StringBuffer(1000);
    private boolean hadFirst = false;
    private HyperlinkFactory factory = new HyperlinkFactory();
    private static final Set<Hyperlink> hyperlinks = new WeakSet();

    public OutputWindowOutputStream(OutputWriter outputWriter) {
        this.writer = outputWriter;
    }

    public void close() throws IOException {
        this.flush();
        this.writer.close();
    }

    public void flush() throws IOException {
        this.flushLines();
        if (this.buffer.length() > 0) {
            this.writer.print(this.buffer.toString());
            this.buffer.setLength(0);
        }
        this.writer.flush();
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.buffer.append(new String(byArray, n, n2));
        this.flushLines();
    }

    public void write(int n) throws IOException {
        this.buffer.append((char)n);
        if ((char)n == '\n') {
            this.flushLines();
        }
    }

    private void flushLines() throws IOException {
        block0: while (true) {
            int n = this.buffer.length();
            for (int i = 0; i < n; ++i) {
                if (this.buffer.charAt(i) != '\n') continue;
                int n2 = i;
                if (n2 > 0 && this.buffer.charAt(n2 - 1) == '\r') {
                    --n2;
                }
                this.flushLine(this.buffer.substring(0, n2));
                this.buffer.delete(0, i + 1);
                continue block0;
            }
            break;
        }
    }

    private void flushLine(String string) throws IOException {
        Hyperlink hyperlink;
        if (!this.hadFirst) {
            this.hadFirst = true;
            if (string.trim().length() == 0) {
                return;
            }
        }
        if ((hyperlink = this.factory.create(string)) != null) {
            this.writer.println(hyperlink.getMessage(), (OutputListener)hyperlink);
        } else {
            this.writer.println(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void detachAllAnnotations() {
        Set<Hyperlink> set = hyperlinks;
        synchronized (set) {
            Iterator<Hyperlink> iterator = hyperlinks.iterator();
            while (iterator.hasNext()) {
                iterator.next().destroy();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HyperlinkFactory
    implements Comparator<String> {
        private Map<String, FileSystem> fss0 = new HashMap<String, FileSystem>();
        private SortedMap<String, FileSystem> fss = new TreeMap<String, FileSystem>(this);
        private static PrintWriter debugwriter = null;

        public HyperlinkFactory() {
            FileObject fileObject = FileUtil.getConfigRoot();
            FileSystem fileSystem = null;
            try {
                fileSystem = fileObject.getFileSystem();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
            }
            File file = FileUtil.toFile((FileObject)fileObject);
            if (file != null) {
                String string = file.getAbsolutePath();
                if (!string.endsWith(File.separator)) {
                    string = string + File.separator;
                }
                if (file != null) {
                    this.fss0.put(string, fileSystem);
                    this.fss.put(string, fileSystem);
                }
            }
            this.fss0 = null;
        }

        public Hyperlink create(String string) {
            for (Map.Entry<String, FileSystem> entry : this.fss.entrySet()) {
                String string2;
                int n;
                String string3 = entry.getKey();
                if (!string.startsWith(string3) && !string.replace('/', File.separatorChar).startsWith(string3) || (n = string.indexOf(58, string3.length())) == -1) continue;
                String string4 = string.substring(string3.length(), n).replace(File.separatorChar, '/');
                FileSystem fileSystem = entry.getValue();
                FileObject fileObject = fileSystem.findResource(string4);
                if (fileObject == null) continue;
                int n2 = -1;
                int n3 = -1;
                int n4 = -1;
                int n5 = -1;
                int n6 = n + 1;
                int n7 = string.indexOf(58, n + 1);
                if (n7 != -1) {
                    try {
                        n2 = Integer.parseInt(string.substring(n + 1, n7).trim()) - 1;
                        n6 = n7 + 1;
                        int n8 = string.indexOf(58, n7 + 1);
                        if (n8 != -1) {
                            n3 = Integer.parseInt(string.substring(n7 + 1, n8).trim()) - 1;
                            n6 = n8 + 1;
                            int n9 = string.indexOf(58, n8 + 1);
                            if (n9 != -1) {
                                n4 = Integer.parseInt(string.substring(n8 + 1, n9).trim()) - 1;
                                n6 = n9 + 1;
                                int n10 = string.indexOf(58, n9 + 1);
                                if (n10 != -1) {
                                    n5 = Integer.parseInt(string.substring(n9 + 1, n10).trim()) - 1;
                                    n6 = n10 + 1;
                                }
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((string2 = string.substring(n6).trim()).length() == 0) {
                    string2 = null;
                }
                Hyperlink hyperlink = new Hyperlink(fileObject, n2, n3, n4, n5, string2);
                return hyperlink;
            }
            return null;
        }

        private static void debug(String string) {
            if (debugwriter == null) {
                try {
                    debugwriter = new PrintWriter(new FileWriter("/dev/tty"));
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                    return;
                }
            }
            debugwriter.println("[owos]: " + string);
            debugwriter.flush();
        }

        @Override
        public int compare(String string, String string2) {
            FileSystem fileSystem = this.fss0.get(string);
            FileSystem fileSystem2 = this.fss0.get(string2);
            int n = string2.length() - string.length();
            if (n != 0) {
                return n;
            }
            return System.identityHashCode(fileSystem) - System.identityHashCode(fileSystem2);
        }
    }

    private static final class Hyperlink
    extends Annotation
    implements OutputListener,
    PropertyChangeListener {
        private FileObject file;
        private int line1;
        private int col1;
        private int line2;
        private int col2;
        private String message;
        private boolean dead = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Hyperlink(FileObject fileObject, int n, int n2, int n3, int n4, String string) {
            this.file = fileObject;
            this.line1 = n;
            this.col1 = n2;
            this.line2 = n3;
            this.col2 = n4;
            this.message = string;
            Set set = hyperlinks;
            synchronized (set) {
                hyperlinks.add(this);
            }
        }

        void destroy() {
            this.doDetach();
            this.dead = true;
        }

        public String getMessage() {
            String string;
            String string2 = this.file.getPath();
            String string3 = string = this.message != null ? this.message : NbBundle.getMessage(OutputWindowOutputStream.class, (String)"ERR_unknown");
            if (this.line1 == -1) {
                return NbBundle.getMessage(OutputWindowOutputStream.class, (String)"MSG_err", (Object)string2, (Object)string);
            }
            if (this.col1 == -1) {
                return NbBundle.getMessage(OutputWindowOutputStream.class, (String)"MSG_err_line", (Object)string2, (Object)string, (Object)(this.line1 + 1));
            }
            if (this.line2 == -1 || this.col2 == -1 || this.line1 == this.line2 && this.col1 == this.col2) {
                return NbBundle.getMessage(OutputWindowOutputStream.class, (String)"MSG_err_line_col", (Object[])new Object[]{string2, string, this.line1 + 1, this.col1 + 1});
            }
            if (this.line1 == this.line2) {
                return NbBundle.getMessage(OutputWindowOutputStream.class, (String)"MSG_err_line_col_col", (Object[])new Object[]{string2, string, this.line1 + 1, this.col1 + 1, this.col2 + 1});
            }
            return NbBundle.getMessage(OutputWindowOutputStream.class, (String)"MSG_err_line_col_line_col", (Object[])new Object[]{string2, string, this.line1 + 1, this.col1 + 1, this.line2 + 1, this.col2 + 1});
        }

        public void outputLineAction(OutputEvent outputEvent) {
            System.err.println("outputLineAction: " + outputEvent.getLine());
            if (this.dead) {
                return;
            }
            if (!this.file.isValid()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (this.message != null) {
                StatusDisplayer.getDefault().setStatusText(this.message);
            }
            try {
                DataObject dataObject = DataObject.find((FileObject)this.file);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie != null) {
                    if (this.line1 == -1) {
                        editorCookie.open();
                    } else {
                        editorCookie.openDocument();
                        errMgr.log("opened document for " + this.file);
                        Line line = editorCookie.getLineSet().getOriginal(this.line1);
                        if (!line.isDeleted()) {
                            this.attachAsNeeded(line, editorCookie);
                            if (this.col1 == -1) {
                                line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                            } else {
                                line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, this.col1);
                            }
                        }
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify(16, (Throwable)dataObjectNotFoundException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                ErrorManager.getDefault().notify(16, (Throwable)indexOutOfBoundsException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(16, (Throwable)iOException);
            }
        }

        public void outputLineSelected(OutputEvent outputEvent) {
            System.err.println("outputLineSelected: " + outputEvent.getLine());
            if (this.dead) {
                return;
            }
            if (!this.file.isValid()) {
                return;
            }
            try {
                DataObject dataObject = DataObject.find((FileObject)this.file);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie != null) {
                    Line line;
                    if (editorCookie.getDocument() == null) {
                        errMgr.log("no document for " + this.file);
                        return;
                    }
                    errMgr.log("got document for " + this.file);
                    if (this.line1 != -1 && !(line = editorCookie.getLineSet().getOriginal(this.line1)).isDeleted()) {
                        this.attachAsNeeded(line, editorCookie);
                        if (this.col1 == -1) {
                            line.show(Line.ShowOpenType.NONE, Line.ShowVisibilityType.NONE);
                        } else {
                            line.show(Line.ShowOpenType.NONE, Line.ShowVisibilityType.NONE, this.col1);
                        }
                    }
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify(16, (Throwable)dataObjectNotFoundException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                ErrorManager.getDefault().notify(16, (Throwable)indexOutOfBoundsException);
            }
        }

        private synchronized void attachAsNeeded(Line line, EditorCookie editorCookie) {
            if (this.getAttachedAnnotatable() == null) {
                Line line2;
                boolean bl = errMgr.isLoggable(0);
                String string = line.getText();
                System.err.println("attachAsNeeded: " + string);
                if (bl) {
                    errMgr.log("Attaching to line " + line.getDisplayName() + " text=`" + string + "' line1=" + this.line1 + " line2=" + this.line2 + " col1=" + this.col1 + " col2=" + this.col2);
                }
                if (string != null && (this.line2 == -1 || this.line1 == this.line2) && this.col1 != -1) {
                    if (bl) {
                        errMgr.log("\tfits on one line");
                    }
                    if (this.col2 != -1 && this.col2 >= this.col1 && this.col2 < string.length()) {
                        if (bl) {
                            errMgr.log("\tspecified section of the line");
                        }
                        line2 = line.createPart(this.col1, this.col2 - this.col1 + 1);
                    } else if (this.col1 < string.length()) {
                        if (bl) {
                            errMgr.log("\tspecified column to end of line");
                        }
                        line2 = line.createPart(this.col1, string.length() - this.col1);
                    } else {
                        if (bl) {
                            errMgr.log("\tcolumn numbers are bogus");
                        }
                        line2 = line;
                    }
                } else {
                    if (bl) {
                        errMgr.log("\tmultiple lines, something wrong with line, or no column given");
                    }
                    line2 = line;
                }
                this.attach((Annotatable)line2);
                line2.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private synchronized void doDetach() {
            Annotatable annotatable = this.getAttachedAnnotatable();
            if (annotatable != null) {
                if (errMgr.isLoggable(0)) {
                    errMgr.log("Detaching from " + annotatable + " `" + annotatable.getText() + "'");
                }
                annotatable.removePropertyChangeListener((PropertyChangeListener)this);
                this.detach();
            }
        }

        public void outputLineCleared(OutputEvent outputEvent) {
            this.doDetach();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.dead) {
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            if (string == null || string.equals("text") || string.equals("deleted")) {
                if (errMgr.isLoggable(0)) {
                    errMgr.log("Received Annotatable property change: " + string);
                }
                this.doDetach();
            }
        }

        public String getAnnotationType() {
            return "org-apache-tools-ant-module-error";
        }

        public String getShortDescription() {
            return this.message;
        }

        public String toString() {
            return "Hyperlink[" + this.file + ":" + this.line1 + ":" + this.col1 + ":" + this.line2 + ":" + this.col2 + "]";
        }
    }
}

