/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.execution.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.ToolchainManager;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.execution.ErrorParserProvider;
import org.netbeans.modules.cnd.execution.impl.ErrorParser;
import org.netbeans.modules.cnd.execution.impl.OutputListenerImpl;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;

public final class GCCErrorParser
extends ErrorParser {
    private final List<Pattern> GCC_ERROR_SCANNER = new ArrayList<Pattern>();
    private final List<Pattern> patterns = new ArrayList<Pattern>();
    private Pattern GCC_DIRECTORY_ENTER;
    private Pattern GCC_DIRECTORY_LEAVE;
    private Pattern GCC_DIRECTORY_CD;
    private Pattern GCC_DIRECTORY_MAKE_ALL;
    private Pattern GCC_STACK_HEADER;
    private Pattern GCC_STACK_NEXT;
    private Stack<FileObject> relativesTo = new Stack();
    private Stack<Integer> relativesLevel = new Stack();
    private ArrayList<StackIncludeItem> errorInludes = new ArrayList();
    private boolean isEntered;

    public GCCErrorParser(CompilerSet.CompilerFlavor compilerFlavor, ExecutionEnvironment executionEnvironment, FileObject fileObject) {
        super(executionEnvironment, fileObject);
        this.relativesTo.push(fileObject);
        this.relativesLevel.push(0);
        this.isEntered = false;
        this.init(compilerFlavor);
    }

    private void init(CompilerSet.CompilerFlavor compilerFlavor) {
        ToolchainManager.ScannerDescriptor scannerDescriptor = compilerFlavor.getToolchainDescriptor().getScanner();
        if (scannerDescriptor.getEnterDirectoryPattern() != null) {
            this.GCC_DIRECTORY_ENTER = Pattern.compile(scannerDescriptor.getEnterDirectoryPattern());
            this.patterns.add(this.GCC_DIRECTORY_ENTER);
        }
        if (scannerDescriptor.getLeaveDirectoryPattern() != null) {
            this.GCC_DIRECTORY_LEAVE = Pattern.compile(scannerDescriptor.getLeaveDirectoryPattern());
            this.patterns.add(this.GCC_DIRECTORY_LEAVE);
        }
        if (scannerDescriptor.getChangeDirectoryPattern() != null) {
            this.GCC_DIRECTORY_CD = Pattern.compile(scannerDescriptor.getChangeDirectoryPattern());
            this.patterns.add(this.GCC_DIRECTORY_CD);
        }
        if (scannerDescriptor.getChangeDirectoryPattern() != null) {
            this.GCC_DIRECTORY_MAKE_ALL = Pattern.compile(scannerDescriptor.getMakeAllInDirectoryPattern());
            this.patterns.add(this.GCC_DIRECTORY_MAKE_ALL);
        }
        if (scannerDescriptor.getStackHeaderPattern() != null && scannerDescriptor.getStackHeaderPattern() != null) {
            this.GCC_STACK_HEADER = Pattern.compile(scannerDescriptor.getStackHeaderPattern());
            this.patterns.add(this.GCC_STACK_HEADER);
            this.GCC_STACK_NEXT = Pattern.compile(scannerDescriptor.getStackHeaderPattern());
            this.patterns.add(this.GCC_STACK_NEXT);
        }
        for (ToolchainManager.ScannerPattern scannerPattern : scannerDescriptor.getPatterns()) {
            Pattern pattern = Pattern.compile(scannerPattern.getPattern());
            this.GCC_ERROR_SCANNER.add(pattern);
            this.patterns.add(pattern);
        }
    }

    private void popPath() {
        if (this.relativesTo.size() > 1) {
            this.relativesTo.pop();
        }
    }

    private void popLevel() {
        if (this.relativesLevel.size() > 1) {
            this.relativesLevel.pop();
        }
    }

    public ErrorParserProvider.Result handleLine(String string) throws IOException {
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(string);
            boolean bl = matcher.find();
            if (!bl || matcher.start() != 0) continue;
            return this.handleLine(string, matcher);
        }
        return null;
    }

    private ErrorParserProvider.Result handleLine(String string, Matcher matcher) throws IOException {
        if (matcher.pattern() == this.GCC_DIRECTORY_ENTER || matcher.pattern() == this.GCC_DIRECTORY_LEAVE) {
            String string2 = matcher.group(1);
            int n = string2 == null ? 0 : Integer.valueOf(string2);
            int n2 = this.relativesLevel.peek();
            String fileObject = matcher.group(2);
            if (n > n2) {
                this.isEntered = true;
                this.relativesLevel.push(n);
                this.isEntered = true;
            } else if (n == n2) {
                this.isEntered = !this.isEntered;
            } else {
                this.isEntered = false;
                this.popLevel();
            }
            if (this.isEntered) {
                FileObject fileObject2;
                if (!IpeUtils.isPathAbsolute(fileObject) && this.relativeTo != null && this.relativeTo.isFolder()) {
                    fileObject = this.relativeTo.getURL().getPath() + File.separator + fileObject;
                }
                if ((fileObject2 = this.resolveFile(fileObject)) != null) {
                    this.relativesTo.push(fileObject2);
                }
                return ErrorParserProvider.NO_RESULT;
            }
            this.popPath();
            return ErrorParserProvider.NO_RESULT;
        }
        if (matcher.pattern() == this.GCC_DIRECTORY_CD) {
            FileObject fileObject;
            String string4 = matcher.group(1);
            if (!IpeUtils.isPathAbsolute(string4) && this.relativeTo != null && this.relativeTo.isFolder()) {
                string4 = this.relativeTo.getURL().getPath() + File.separator + string4;
            }
            if ((fileObject = this.resolveFile(string4)) != null) {
                this.relativesTo.push(fileObject);
            }
            return ErrorParserProvider.NO_RESULT;
        }
        if (matcher.pattern() == this.GCC_DIRECTORY_MAKE_ALL) {
            FileObject fileObject = this.relativesTo.peek();
            String string5 = matcher.group(1);
            if (!IpeUtils.isPathAbsolute(string5) && fileObject != null && fileObject.isFolder()) {
                string5 = fileObject.getURL().getPath() + File.separator + string5;
            }
            if ((fileObject = this.resolveFile(string5)) != null) {
                this.relativesTo.push(fileObject);
            }
            return ErrorParserProvider.NO_RESULT;
        }
        if (matcher.pattern() == this.GCC_STACK_HEADER) {
            ErrorParserProvider.Results results = new ErrorParserProvider.Results();
            for (StackIncludeItem object : this.errorInludes) {
                results.add(object.line, null);
            }
            this.errorInludes.clear();
            try {
                FileObject fileObject;
                String string6 = matcher.group(1);
                Integer fileObject3 = Integer.valueOf(matcher.group(2));
                FileObject fileObject4 = this.relativesTo.peek();
                if (fileObject4 != null && (fileObject = this.resolveRelativePath(fileObject4, string6)) != null) {
                    this.errorInludes.add(new StackIncludeItem(fileObject, string, fileObject3 - 1));
                    return results;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.errorInludes.add(new StackIncludeItem(null, string, 0));
            return results;
        }
        if (matcher.pattern() == this.GCC_STACK_NEXT) {
            try {
                FileObject fileObject;
                String string7 = matcher.group(1);
                Integer n = Integer.valueOf(matcher.group(2));
                FileObject object = this.relativesTo.peek();
                if (object != null && (fileObject = this.resolveRelativePath(object, string7)) != null) {
                    this.errorInludes.add(new StackIncludeItem(fileObject, string, n - 1));
                    return new ErrorParserProvider.Results();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.errorInludes.add(new StackIncludeItem(null, string, 0));
            return new ErrorParserProvider.Results();
        }
        if (this.GCC_ERROR_SCANNER.contains(matcher.pattern())) {
            ErrorParserProvider.Results results = new ErrorParserProvider.Results();
            try {
                String string8 = matcher.group(1);
                Integer n = Integer.valueOf(matcher.group(2));
                FileObject fileObject = this.relativesTo.peek();
                if (fileObject != null) {
                    boolean bl;
                    FileObject fileObject5 = this.resolveRelativePath(fileObject, string8);
                    boolean bl2 = bl = matcher.group(3).indexOf("error") != -1;
                    if (fileObject5 != null) {
                        for (StackIncludeItem stackIncludeItem : this.errorInludes) {
                            if (stackIncludeItem.fo != null) {
                                results.add(stackIncludeItem.line, new OutputListenerImpl(stackIncludeItem.fo, stackIncludeItem.lineNumber, bl));
                                continue;
                            }
                            results.add(stackIncludeItem.line, null);
                        }
                        this.errorInludes.clear();
                        results.add(string, new OutputListenerImpl(fileObject5, n - 1, bl));
                        return results;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            for (StackIncludeItem stackIncludeItem : this.errorInludes) {
                results.add(stackIncludeItem.line, null);
            }
            this.errorInludes.clear();
            results.add(string, null);
            return results;
        }
        throw new IllegalArgumentException("Unknown pattern: " + matcher.pattern().pattern());
    }

    private static class StackIncludeItem {
        private FileObject fo;
        private String line;
        private int lineNumber;

        private StackIncludeItem(FileObject fileObject, String string, int n) {
            this.fo = fileObject;
            this.line = string;
            this.lineNumber = n;
        }
    }
}

