/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.execution41.org.openide.loaders;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.builds.ImportUtils;
import org.netbeans.modules.cnd.execution41.org.openide.cookies.ArgumentsCookie;
import org.netbeans.modules.cnd.execution41.org.openide.cookies.ExecCookie;
import org.netbeans.modules.cnd.execution41.org.openide.execution.Executor;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionSupport
implements ExecCookie,
ArgumentsCookie {
    private static final String EA_EXECUTOR = "NetBeansAttrExecutor";
    private static final String EA_ARGUMENTS = "NetBeansAttrArguments";
    private static final String EA_ENVIRONMENT_VARIABLES = "NetBeansAttrEnvironment";
    public static final String PROP_FILE_PARAMS = "params";
    public static final String PROP_EXECUTION = "execution";
    private MultiDataObject.Entry entry;
    protected static final String READONLY_ATTRIBUTES = "readOnlyAttrs";

    public ExecutionSupport(MultiDataObject.Entry entry) {
        this.entry = entry;
    }

    protected MultiDataObject.Entry getEntry() {
        return this.entry;
    }

    @Override
    public void start() {
        Executor executor = ExecutionSupport.getExecutor(this.entry);
        if (executor == null) {
            executor = this.defaultExecutor();
        }
        try {
            executor.execute((DataObject)this.entry.getDataObject());
        }
        catch (IOException iOException) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    if (ExecutionSupport.this.startFailed(iOException)) {
                        ExecutionSupport.this.start();
                    }
                }
            });
        }
    }

    protected boolean startFailed(IOException iOException) {
        return false;
    }

    protected Executor defaultExecutor() {
        return Executor.getDefault();
    }

    public static void setExecutor(MultiDataObject.Entry entry, Executor executor) throws IOException {
    }

    public static Executor getExecutor(MultiDataObject.Entry entry) {
        return null;
    }

    @Override
    public void setArguments(String[] stringArray) throws IOException {
        this.entry.getFile().setAttribute(EA_ARGUMENTS, (Object)stringArray);
    }

    public static void setArguments(MultiDataObject.Entry entry, String[] stringArray) throws IOException {
        entry.getFile().setAttribute(EA_ARGUMENTS, (Object)stringArray);
    }

    @Override
    public String[] getArguments() {
        return ExecutionSupport.getArguments(this.entry);
    }

    public static String[] getArguments(MultiDataObject.Entry entry) {
        Object object = entry.getFile().getAttribute(EA_ARGUMENTS);
        if (object != null && object instanceof String[]) {
            return (String[])object;
        }
        return new String[0];
    }

    public void setEnvironmentVariables(String[] stringArray) throws IOException {
        this.entry.getFile().setAttribute(EA_ENVIRONMENT_VARIABLES, (Object)stringArray);
    }

    public String[] getEnvironmentVariables() {
        Object object = this.entry.getFile().getAttribute(EA_ENVIRONMENT_VARIABLES);
        if (object != null && object instanceof String[]) {
            return (String[])object;
        }
        return new String[0];
    }

    public void addProperties(Sheet.Set set) {
        set.put(this.createParamsProperty(PROP_FILE_PARAMS, ExecutionSupport.getString("PROP_fileParams"), ExecutionSupport.getString("HINT_fileParams")));
        set.put(this.createExecutorProperty());
    }

    protected PropertySupport<String> createParamsProperty(String string, String string2, String string3) {
        PropertySupport.ReadWrite<String> readWrite = new PropertySupport.ReadWrite<String>(string, String.class, string2, string3){

            public String getValue() {
                String[] stringArray = ExecutionSupport.this.getArguments();
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuilder.append(stringArray[i]).append(' ');
                }
                return stringBuilder.toString();
            }

            public void setValue(String string) throws InvocationTargetException {
                if (string != null) {
                    try {
                        ExecutionSupport.this.setArguments(new String[]{string});
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                try {
                    ExecutionSupport.this.setArguments(null);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean canWrite() {
                Boolean bl = (Boolean)ExecutionSupport.this.entry.getFile().getAttribute(ExecutionSupport.READONLY_ATTRIBUTES);
                return bl == null ? false : bl == false;
            }
        };
        readWrite.setValue("oneline", (Object)Boolean.TRUE);
        return readWrite;
    }

    private PropertySupport<Executor> createExecutorProperty() {
        return new PropertySupport.ReadWrite<Executor>(PROP_EXECUTION, Executor.class, ExecutionSupport.getString("PROP_execution"), ExecutionSupport.getString("HINT_execution")){

            public Executor getValue() {
                Executor executor = ExecutionSupport.getExecutor(ExecutionSupport.this.entry);
                if (executor == null) {
                    return ExecutionSupport.this.defaultExecutor();
                }
                return executor;
            }

            public void setValue(Executor executor) throws InvocationTargetException {
                try {
                    ExecutionSupport.setExecutor(ExecutionSupport.this.entry, executor);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
            }

            public boolean canWrite() {
                Boolean bl = (Boolean)ExecutionSupport.this.entry.getFile().getAttribute(ExecutionSupport.READONLY_ATTRIBUTES);
                return bl == null ? false : bl == false;
            }
        };
    }

    protected PropertySupport<String> createEnvironmentProperty(String string, String string2, String string3) {
        PropertySupport.ReadWrite<String> readWrite = new PropertySupport.ReadWrite<String>(string, String.class, string2, string3){

            public String getValue() {
                String[] stringArray = ExecutionSupport.this.getEnvironmentVariables();
                List<String> list = new ArrayList<String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    list.add(stringArray[i]);
                }
                list = ImportUtils.quoteList(list);
                StringBuilder stringBuilder = new StringBuilder();
                for (String string : list) {
                    stringBuilder.append(string).append(' ');
                }
                return stringBuilder.toString();
            }

            public void setValue(String string) throws InvocationTargetException {
                if (string != null) {
                    try {
                        List<String> list = ImportUtils.parseEnvironment(string);
                        ExecutionSupport.this.setEnvironmentVariables(list.toArray(new String[list.size()]));
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                try {
                    ExecutionSupport.this.setEnvironmentVariables(null);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean canWrite() {
                return ExecutionSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
        return readWrite;
    }

    static String getString(String string) {
        return NbBundle.getMessage(Executor.class, (String)string);
    }
}

