/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.builds.MakeExecSupport;
import org.netbeans.modules.cnd.makewizard.BaseDirectoryPanel;
import org.netbeans.modules.cnd.makewizard.BasicFlagsPanel;
import org.netbeans.modules.cnd.makewizard.BuildOutputPanel;
import org.netbeans.modules.cnd.makewizard.CompilerOptionsPanel;
import org.netbeans.modules.cnd.makewizard.CompilerPathPanel;
import org.netbeans.modules.cnd.makewizard.CreateTargetsPanel;
import org.netbeans.modules.cnd.makewizard.CustomTargetPanel;
import org.netbeans.modules.cnd.makewizard.MakeTargetPanel;
import org.netbeans.modules.cnd.makewizard.MakefileData;
import org.netbeans.modules.cnd.makewizard.MakefileGenerator;
import org.netbeans.modules.cnd.makewizard.MakefileIncludesPanel;
import org.netbeans.modules.cnd.makewizard.MakefileReviewPanel;
import org.netbeans.modules.cnd.makewizard.MakefileSourcesPanel;
import org.netbeans.modules.cnd.makewizard.MakefileWizardDescriptorPanel;
import org.netbeans.modules.cnd.makewizard.MakefileWizardEvent;
import org.netbeans.modules.cnd.makewizard.MakefileWizardListener;
import org.netbeans.modules.cnd.makewizard.MakefileWizardPanel;
import org.netbeans.modules.cnd.makewizard.PlatformTypePanel;
import org.netbeans.modules.cnd.makewizard.SelectPreferencesPanel;
import org.netbeans.modules.cnd.makewizard.StandardLibsPanel;
import org.netbeans.modules.cnd.makewizard.TargetData;
import org.netbeans.modules.cnd.makewizard.TargetNamePanel;
import org.netbeans.modules.cnd.makewizard.UserLibsPanel;
import org.netbeans.modules.cnd.settings.MakeSettings;
import org.openide.WizardDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakefileWizard
implements TemplateWizard.Iterator {
    private static Vector<MakefileWizardListener> listenerList = null;
    protected TemplateWizard wd;
    protected Object[] panels;
    private WizardDescriptor.Panel currentPanel;
    protected Object[] normalPanels;
    protected LinkedList<Object> complexPanels;
    private MakefileData makefileData;
    private static MakefileWizard makefileWizard;
    private String title;
    private int index;
    private int virtIndex;
    private int addIdx;
    private JButton nextButton;
    private JButton finishButton;
    private JButton cancelButton;
    private String finishLabel;
    private int finishMnemonic;
    private boolean finishEnabled;
    private boolean haveCompilerFlags;
    private PropertyChangeListener listener = null;
    private WizardDescriptor.Panel targetChooserDescriptorPanel;
    private WizardDescriptor.Panel baseDirectoryDescriptorPanel;
    private WizardDescriptor.Panel targetNameDescriptorPanel;
    private WizardDescriptor.Panel makefileSourcesDescriptorPanel;
    private WizardDescriptor.Panel selectPreferencesDescriptorPanel;
    private WizardDescriptor.Panel platformTypeDescriptorPanel;
    private WizardDescriptor.Panel createTargetsDescriptorPanel;
    private WizardDescriptor.Panel buildOutputDescriptorPanel;
    private WizardDescriptor.Panel makefileIncludesDescriptorPanel;
    private WizardDescriptor.Panel standardLibsDescriptorPanel;
    private WizardDescriptor.Panel userLibsDescriptorPanel;
    private WizardDescriptor.Panel compilerOptionsDescriptorPanel;
    private WizardDescriptor.Panel basicFlagsDescriptorPanel;
    private WizardDescriptor.Panel compilerPathDescriptorPanel;
    private WizardDescriptor.Panel makefileReviewDescriptorPanel;
    private final transient Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public MakefileWizard() {
        makefileWizard = this;
        String string = NbBundle.getBundle(MakefileWizard.class).getString("LBL_MakefileWizardTitle");
        this.setTitle(string);
        this.makefileData = new MakefileData();
    }

    private void initPanels() {
        this.targetChooserDescriptorPanel = this.wd.targetChooser();
        this.baseDirectoryDescriptorPanel = new MakefileWizardDescriptorPanel(new BaseDirectoryPanel(this), "base_directory");
        this.targetNameDescriptorPanel = new MakefileWizardDescriptorPanel(new TargetNamePanel(this), "target_name");
        this.makefileSourcesDescriptorPanel = new MakefileWizardDescriptorPanel(new MakefileSourcesPanel(this), "source_files");
        this.selectPreferencesDescriptorPanel = new MakefileWizardDescriptorPanel(new SelectPreferencesPanel(this), "compiling_preference");
        this.createTargetsDescriptorPanel = new MakefileWizardDescriptorPanel(new CreateTargetsPanel(this), "list_of_targets");
        this.platformTypeDescriptorPanel = new MakefileWizardDescriptorPanel(new PlatformTypePanel(this), "type_and_platform");
        this.buildOutputDescriptorPanel = new MakefileWizardDescriptorPanel(new BuildOutputPanel(this), "build_output");
        this.makefileIncludesDescriptorPanel = new MakefileWizardDescriptorPanel(new MakefileIncludesPanel(this), "include_directories");
        this.standardLibsDescriptorPanel = new MakefileWizardDescriptorPanel(new StandardLibsPanel(this), "standard_libraries");
        this.userLibsDescriptorPanel = new MakefileWizardDescriptorPanel(new UserLibsPanel(this), "libraries");
        this.basicFlagsDescriptorPanel = new MakefileWizardDescriptorPanel(new BasicFlagsPanel(this), "basic_options");
        this.compilerPathDescriptorPanel = new MakefileWizardDescriptorPanel(new CompilerPathPanel(this), "compiler_paths");
        this.compilerOptionsDescriptorPanel = new MakefileWizardDescriptorPanel(new CompilerOptionsPanel(this), "advanced_options");
        this.makefileReviewDescriptorPanel = new MakefileWizardDescriptorPanel(new MakefileReviewPanel(this), "review_makefile");
        this.normalPanels = new WizardDescriptor.Panel[]{this.targetChooserDescriptorPanel, this.platformTypeDescriptorPanel, this.targetNameDescriptorPanel, this.makefileSourcesDescriptorPanel, this.selectPreferencesDescriptorPanel, this.makefileReviewDescriptorPanel};
        this.complexPanels = new LinkedList();
        this.complexPanels.addLast(this.targetChooserDescriptorPanel);
        this.complexPanels.addLast(this.platformTypeDescriptorPanel);
        this.complexPanels.addLast(this.baseDirectoryDescriptorPanel);
        this.complexPanels.addLast(this.createTargetsDescriptorPanel);
        this.complexPanels.addLast(this.makefileReviewDescriptorPanel);
        this.panels = this.complexToArray();
        this.currentPanel = this.targetChooserDescriptorPanel;
        this.addIdx = 4;
        this.haveCompilerFlags = false;
        this.nextButton = null;
        this.finishButton = null;
        this.cancelButton = null;
        this.finishEnabled = false;
    }

    public TemplateWizard getTemplateWizard() {
        return this.wd;
    }

    public final MakefileData getMakefileData() {
        return this.makefileData;
    }

    public final void setTitle(String string) {
        this.title = string;
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    public JButton getFinishButton() {
        return this.finishButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public String getFinishLabel() {
        return this.finishLabel;
    }

    public int getFinishMnemonic() {
        return this.finishMnemonic;
    }

    public int getCurrentTargetKey() {
        int n = -1;
        if (this.makefileData.getMakefileType() < 4) {
            n = 0;
        } else {
            for (int i = 0; i < this.panels.length; ++i) {
                if (this.panels[i] instanceof StepHeader) {
                    n = ((StepHeader)this.panels[i]).getKey();
                }
                if (i == this.index) break;
            }
        }
        return n;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        WizardDescriptor.Panel panel = this.currentPanel;
        return panel;
    }

    public String name() {
        Object[] objectArray = new Object[]{this.index + 1, this.panels.length};
        MessageFormat messageFormat = new MessageFormat(NbBundle.getBundle(WizardDescriptor.class).getString("CTL_ArrayIteratorName"));
        return messageFormat.format(objectArray);
    }

    public void updateStateHack() {
        if (this.wd != null) {
            this.wd.setTitleFormat(new MessageFormat("{0}"));
        }
    }

    public void updateState() {
        this.fireChangeEvent();
    }

    private String[] getSteps() {
        String[] stringArray = new String[this.panels.length + 1];
        StepHeader stepHeader = null;
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        stringArray[0] = this.wd.templateChooser().getComponent().getName();
        for (int i = 0; i < this.panels.length; ++i) {
            if (this.panels[i] instanceof StepHeader) {
                if (i < this.index) {
                    ++n4;
                }
                stepHeader = (StepHeader)this.panels[i];
                stringArray[n++] = stepHeader.getTitle();
                n2 = stepHeader.getNum();
                if (this.index < i || this.index > i + stepHeader.getNum()) continue;
                n3 = stepHeader.getNum();
                continue;
            }
            if (n2-- > 0) {
                if (n3-- <= 0) continue;
                if (i < this.index) {
                    ++n4;
                }
                stringArray[n++] = NbBundle.getMessage(this.getClass(), (String)"FMT_TARGET_PANEL", (Object)"    ", (Object)((WizardDescriptor.Panel)this.panels[i]).getComponent().getName());
                continue;
            }
            stringArray[n++] = ((WizardDescriptor.Panel)this.panels[i]).getComponent().getName();
            if (i >= this.index) continue;
            ++n4;
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        this.virtIndex = n4;
        return stringArray2;
    }

    public void updatePanels(int n) {
        this.panels = n >= 4 ? this.complexToArray() : this.normalPanels;
        ((JPanel)this.currentPanel.getComponent()).putClientProperty("WizardPanel_contentData", this.getSteps());
        this.updateState();
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public synchronized void nextPanel() {
        if (this.panels[++this.index] instanceof StepHeader) {
            ++this.index;
        }
        this.currentPanel = (WizardDescriptor.Panel)this.panels[this.index];
        this.updatePanels(this.makefileData.getMakefileType());
        ((JPanel)this.currentPanel.getComponent()).putClientProperty("WizardPanel_contentSelectedIndex", this.virtIndex);
    }

    public synchronized void previousPanel() {
        if (this.index == 0) {
            throw new NoSuchElementException();
        }
        if (this.panels[--this.index] instanceof StepHeader) {
            --this.index;
        }
        this.currentPanel = (WizardDescriptor.Panel)this.panels[this.index];
        this.updatePanels(this.makefileData.getMakefileType());
        ((JPanel)this.currentPanel.getComponent()).putClientProperty("WizardPanel_contentSelectedIndex", this.virtIndex);
    }

    private Object[] complexToArray() {
        Object[] objectArray = new Object[this.complexPanels.size()];
        ListIterator listIterator = this.complexPanels.listIterator();
        for (int i = 0; i < this.complexPanels.size(); ++i) {
            objectArray[i] = listIterator.next();
        }
        return objectArray;
    }

    public boolean targetExists(int n) {
        for (int i = 0; i < this.complexPanels.size(); ++i) {
            Object object = this.complexPanels.get(i);
            if (!(object instanceof StepHeader) || ((StepHeader)object).getKey() != n) continue;
            return true;
        }
        return false;
    }

    public int addTarget(int n, String string, int n2) {
        boolean bl = false;
        int n3 = 0;
        switch (n) {
            case 5: {
                bl = true;
                n3 = 6;
                this.complexPanels.add(this.addIdx++, new TargetHeader(string, n, n3 - 1, n2));
                this.complexPanels.add(this.addIdx++, this.buildOutputDescriptorPanel);
                this.complexPanels.add(this.addIdx++, this.makefileSourcesDescriptorPanel);
                this.complexPanels.add(this.addIdx++, this.makefileIncludesDescriptorPanel);
                this.complexPanels.add(this.addIdx++, this.standardLibsDescriptorPanel);
                this.complexPanels.add(this.addIdx++, this.userLibsDescriptorPanel);
                break;
            }
            case 6: {
                bl = true;
                n3 = 4;
                this.complexPanels.add(this.addIdx++, new TargetHeader(string, n, n3 - 1, n2));
                this.complexPanels.add(this.addIdx++, this.buildOutputDescriptorPanel);
                this.complexPanels.add(this.addIdx++, this.makefileSourcesDescriptorPanel);
                this.complexPanels.add(this.addIdx++, this.makefileIncludesDescriptorPanel);
                break;
            }
            case 7: {
                bl = true;
                n3 = 5;
                this.complexPanels.add(this.addIdx++, new TargetHeader(string, n, n3 - 1, n2));
                this.complexPanels.add(this.addIdx++, this.buildOutputDescriptorPanel);
                this.complexPanels.add(this.addIdx++, this.makefileSourcesDescriptorPanel);
                this.complexPanels.add(this.addIdx++, this.makefileIncludesDescriptorPanel);
                this.complexPanels.add(this.addIdx++, this.userLibsDescriptorPanel);
                break;
            }
            case 8: {
                this.complexPanels.add(this.addIdx++, new TargetHeader(string, n, 1, n2));
                this.complexPanels.add(this.addIdx++, new MakefileWizardDescriptorPanel(new MakeTargetPanel(this), "recursive_make"));
                break;
            }
            case 9: {
                this.complexPanels.add(this.addIdx++, new TargetHeader(string, n, 1, n2));
                this.complexPanels.add(this.addIdx++, new MakefileWizardDescriptorPanel(new CustomTargetPanel(this), "custom_make"));
            }
        }
        if (bl && !this.haveCompilerFlags) {
            this.complexPanels.add(this.addIdx, new StepHeader(NbBundle.getBundle(this.getClass()).getString("FMT_COMP_PREFS"), 3, -1));
            this.complexPanels.add(this.addIdx + 1, this.basicFlagsDescriptorPanel);
            this.complexPanels.add(this.addIdx + 2, this.compilerOptionsDescriptorPanel);
            this.complexPanels.add(this.addIdx + 3, this.compilerPathDescriptorPanel);
            this.haveCompilerFlags = true;
            n3 += 4;
        }
        this.updatePanels(n);
        return n3;
    }

    public void deleteTarget(int n) {
        this.deleteTarget(n, true);
    }

    public void deleteTarget(int n, boolean bl) {
        boolean bl2 = false;
        for (int i = 0; i < this.complexPanels.size(); ++i) {
            TargetHeader targetHeader;
            if (!(this.complexPanels.get(i) instanceof TargetHeader) || n != (targetHeader = (TargetHeader)this.complexPanels.get(i)).getKey()) continue;
            for (int j = 0; j <= targetHeader.getNum(); ++j) {
                this.complexPanels.remove(i);
                bl2 = true;
            }
            this.addIdx -= targetHeader.getNum() + 1;
            break;
        }
        if (bl2 && bl) {
            this.updatePanels(this.getMakefileData().getMakefileType());
        }
    }

    public void changeTarget(int n, String string, int n2) {
        boolean bl = false;
        for (int i = 0; i < this.complexPanels.size(); ++i) {
            TargetHeader targetHeader;
            if (!(this.complexPanels.get(i) instanceof TargetHeader) || n != (targetHeader = (TargetHeader)this.complexPanels.get(i)).getKey()) continue;
            if (n2 != targetHeader.getType()) {
                this.deleteTarget(n, false);
                int n3 = this.addIdx;
                this.addIdx = i;
                int n4 = this.addTarget(n2, string, n);
                this.addIdx = n3 + n4;
            } else {
                targetHeader.setName(string);
                targetHeader.setTitle(NbBundle.getMessage(this.getClass(), (String)"FMT_TARGET_CREATE", (Object)string));
            }
            bl = true;
            break;
        }
        if (bl) {
            this.updatePanels(this.getMakefileData().getMakefileType());
        }
    }

    public ArrayList validateAllData() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = -1;
        for (int i = 0; i < this.panels.length; ++i) {
            if (this.panels[i] instanceof WizardDescriptor.Panel && ((WizardDescriptor.Panel)this.panels[i]).getComponent() instanceof MakefileWizardPanel) {
                ((MakefileWizardPanel)((WizardDescriptor.Panel)this.panels[i]).getComponent()).validateData(arrayList, n);
                continue;
            }
            if (!(this.panels[i] instanceof StepHeader)) continue;
            n = ((StepHeader)this.panels[i]).getKey();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            iterator.next().stateChanged((ChangeEvent)object);
        }
    }

    public boolean onFinish() {
        TargetData targetData;
        MakefileGenerator makefileGenerator = new MakefileGenerator(this.makefileData);
        List<TargetData> list = this.getMakefileData().getTargetList();
        if (list.size() > 1 && !(targetData = list.get(1)).isComplex()) {
            for (int i = list.size() - 1; i > 0; --i) {
                list.remove(i);
            }
        }
        boolean bl = makefileGenerator.generate();
        return bl;
    }

    public void executeWizard() {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object;
                if (MakefileWizard.this.index == 0) {
                    MakefileWizard.this.finishButton.setEnabled(false);
                }
                if (propertyChangeEvent.getPropertyName().equals("value") && ((object = propertyChangeEvent.getNewValue()) == WizardDescriptor.FINISH_OPTION || object == WizardDescriptor.CANCEL_OPTION) && object == WizardDescriptor.FINISH_OPTION) {
                    if (MakefileWizard.this.hasNext()) {
                        MakefileWizard.this.index = MakefileWizard.this.panels.length - 2;
                        MakefileWizard.this.nextPanel();
                        MakefileWizard.this.nextButton.setEnabled(false);
                    }
                    MakefileWizard.this.updateStateHack();
                }
            }
        };
        this.index = 0;
        this.currentPanel = (WizardDescriptor.Panel)this.panels[this.index];
        this.setupWizardButtons((WizardDescriptor)this.wd);
        this.updatePanels(this.getMakefileData().getMakefileType());
        ((JPanel)this.currentPanel.getComponent()).putClientProperty("WizardPanel_contentSelectedIndex", 0);
        this.wd.addPropertyChangeListener(this.listener);
    }

    public void unexecuteWizard() {
        if (this.listener != null) {
            this.wd.removePropertyChangeListener(this.listener);
            this.listener = null;
        }
    }

    private void setupWizardButtons(WizardDescriptor wizardDescriptor) {
        Object[] objectArray = wizardDescriptor.getOptions();
        wizardDescriptor.setOptions(new Object[]{WizardDescriptor.NEXT_OPTION, WizardDescriptor.FINISH_OPTION, WizardDescriptor.CANCEL_OPTION});
        Object[] objectArray2 = wizardDescriptor.getOptions();
        if (objectArray2 != null && objectArray2.length == 3) {
            this.nextButton = (JButton)objectArray2[0];
            this.finishButton = (JButton)objectArray2[1];
            this.finishLabel = this.finishButton.getText();
            this.finishMnemonic = this.finishButton.getMnemonic();
            this.cancelButton = (JButton)objectArray2[2];
        }
        wizardDescriptor.setOptions(objectArray);
        this.setFinishClosingEnabled(false);
    }

    private void unsetupWizardButtons(WizardDescriptor wizardDescriptor) {
        this.setFinishClosingEnabled(true);
    }

    public void setFinishClosingEnabled(boolean bl) {
        if (bl) {
            this.wd.setClosingOptions(new Object[]{this.finishButton, this.cancelButton});
        } else {
            this.wd.setClosingOptions(new Object[]{this.cancelButton});
        }
    }

    public void setFinishEnabled(boolean bl) {
        this.finishButton.setEnabled(bl);
    }

    public static final MakefileWizard getMakefileWizard() {
        return makefileWizard;
    }

    public static void showWizard() {
        makefileWizard = new MakefileWizard();
        makefileWizard.executeWizard();
    }

    public void initialize(TemplateWizard templateWizard) {
        this.wd = templateWizard;
        this.initPanels();
        this.executeWizard();
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.unexecuteWizard();
        this.unsetupWizardButtons((WizardDescriptor)templateWizard);
        this.wd = null;
    }

    public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException {
        boolean bl;
        Object object;
        MakeExecSupport makeExecSupport;
        int n;
        String string;
        DataFolder dataFolder = templateWizard.getTargetFolder();
        DataObject dataObject = templateWizard.getTemplate();
        DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, string = (n = this.getMakefileData().getMakefileName().lastIndexOf(File.separatorChar)) >= 0 ? this.getMakefileData().getMakefileName().substring(n + 1) : this.getMakefileData().getMakefileName());
        if (dataObject2 != null && (makeExecSupport = (MakeExecSupport)dataObject2.getCookie(MakeExecSupport.class)) != null) {
            Object object2;
            makeExecSupport.addMakeTargets("all");
            object = this.getMakefileData().getTargetList();
            block9: for (int i = 0; i < object.size(); ++i) {
                object2 = (TargetData)object.get(i);
                switch (((TargetData)object2).getTargetType()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: {
                        if (((TargetData)object2).getOutputDirectory() != null && ((TargetData)object2).getOutputDirectory().length() > 0) {
                            makeExecSupport.addMakeTargets(((TargetData)object2).getOutputDirectory() + "/" + ((TargetData)object2).getName());
                            continue block9;
                        }
                        makeExecSupport.addMakeTargets(((TargetData)object2).getName());
                        continue block9;
                    }
                    case 8: 
                    case 9: {
                        makeExecSupport.addMakeTargets(((TargetData)object2).getName());
                    }
                }
            }
            makeExecSupport.addMakeTargets("clean");
            String string2 = this.getMakefileData().getMakefileDirName();
            object2 = this.getMakefileData().getBaseDirectory();
            String string3 = string2.equals(object2) ? "." : IpeUtils.getRelativePath(string2, (String)object2);
            makeExecSupport.setBuildDirectory(string3);
            String string4 = dataObject2.getPrimaryFile().getFileSystem().getDisplayName() + File.separator + dataObject2.getPrimaryFile().getPath();
            String string5 = string3;
            int n2 = string4.lastIndexOf(File.separatorChar);
            if (n2 >= 0) {
                string5 = IpeUtils.toAbsolutePath(string4.substring(0, n2), string5);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            block10: for (int i = 0; i < object.size(); ++i) {
                TargetData targetData = (TargetData)object.get(i);
                String string6 = targetData.getOutputDirectory();
                if (string6 == null || string6.length() == 0) {
                    string6 = ".";
                }
                switch (targetData.getTargetType()) {
                    case 1: 
                    case 5: {
                        String string7 = null;
                        string7 = targetData.getName().charAt(0) == File.separatorChar ? targetData.getName() : (string6.charAt(0) == File.separatorChar ? string6 + File.separator + targetData.getName() : string5 + File.separator + string6 + File.separator + targetData.getName());
                        arrayList2.add(string7);
                    }
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: {
                        arrayList.add(targetData.getName());
                        continue block10;
                    }
                    case 8: 
                    case 9: {
                        makeExecSupport.addMakeTargets(targetData.getName());
                    }
                }
            }
            MakefileWizardEvent makefileWizardEvent = new MakefileWizardEvent(this, MakefileWizardEvent.MAKEFILE_NEW, string4, this.getMakefileData().getBaseDirectory(), MakeSettings.getDefault().getDefaultMakeCommand(), arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray(new String[arrayList2.size()]));
            MakefileWizard.fireMakefileWizardEvent(makefileWizardEvent);
        }
        if (bl = this.onFinish()) {
            object = (OpenCookie)dataObject2.getCookie(OpenCookie.class);
            if (object != null) {
                object.open();
            }
        } else {
            System.err.println("errors generating makefile...");
        }
        return Collections.singleton(dataObject2);
    }

    private String dirPath(FileObject fileObject, String string) {
        if (fileObject.getParent() != null && fileObject.getParent().getName() != null && fileObject.getParent().getName().length() > 0) {
            string = fileObject.getParent().getName() + File.separatorChar + string;
            return this.dirPath(fileObject.getParent(), string);
        }
        return string;
    }

    public void initDirPaths() {
        String string = null;
        try {
            DataFolder dataFolder = this.getTemplateWizard().getTargetFolder();
            FileObject fileObject = dataFolder.getPrimaryFile();
            string = FileUtil.toFile((FileObject)fileObject).getPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getMakefileData().setBaseDirectory(string);
        this.getMakefileData().setMakefileDirName(string);
    }

    private String uniqDefaultName(String string, String string2) {
        String string3 = string2;
        File file = new File(string + File.separator + string3);
        int n = 1;
        while (file.exists()) {
            string3 = string2 + "_" + n++;
            file = new File(string + File.separator + string3);
        }
        return string3;
    }

    public void initMakefileName() {
        MakefileData makefileData = this.getMakefileData();
        String string = this.getTemplateWizard().getTargetName();
        String string2 = IpeUtils.trimSlashes(makefileData.getMakefileDirName());
        if (string == null) {
            string = this.uniqDefaultName(string2, "Makefile");
        }
        String string3 = string2 + File.separator + string;
        String string4 = null;
        string4 = string2.equals(makefileData.getBaseDirectory()) || ".".equals(string2) || string2.length() == 0 ? string : string3;
        makefileData.setMakefileName(string4);
    }

    protected static void fireMakefileWizardEvent(MakefileWizardEvent makefileWizardEvent) {
        Vector<MakefileWizardListener> vector = MakefileWizard.getListenerList();
        for (int i = vector.size() - 1; i >= 0; --i) {
            vector.elementAt(i).makefileCreated(makefileWizardEvent);
        }
    }

    private static Vector<MakefileWizardListener> getListenerList() {
        if (listenerList == null) {
            listenerList = new Vector(0);
        }
        return listenerList;
    }

    public static void addMakefileWizardListener(MakefileWizardListener makefileWizardListener) {
        MakefileWizard.getListenerList().add(makefileWizardListener);
    }

    public static void removeMakefileWizardListener(MakefileWizardListener makefileWizardListener) {
        MakefileWizard.getListenerList().remove(makefileWizardListener);
    }

    private class TargetHeader
    extends StepHeader {
        private String name;
        private int type;

        public TargetHeader(String string, int n, int n2, int n3) {
            super(null, n2, n3);
            this.name = string;
            this.type = n;
            this.setTitle(NbBundle.getMessage(this.getClass(), (String)"FMT_TARGET_CREATE", (Object)string));
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int n) {
            this.type = n;
        }
    }

    private class StepHeader {
        private String title;
        private int num;
        private int key;

        public StepHeader(String string, int n, int n2) {
            this.title = string;
            this.num = n;
            this.key = n2;
        }

        public String getTitle() {
            return this.title;
        }

        protected void setTitle(String string) {
            this.title = string;
        }

        public int getNum() {
            return this.num;
        }

        protected void setNum(int n) {
            this.num = n;
        }

        public int getKey() {
            return this.key;
        }

        protected void setKey(int n) {
            this.key = n;
        }
    }
}

