/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makewizard.MakefileWizard;
import org.netbeans.modules.cnd.makewizard.MakefileWizardPanel;
import org.netbeans.modules.cnd.makewizard.StdLib;
import org.netbeans.modules.cnd.makewizard.StdLibFlags;
import org.netbeans.modules.cnd.makewizard.TargetData;

public class StandardLibsPanel
extends MakefileWizardPanel {
    static final long serialVersionUID = -1354448784992649011L;
    private JLabel libsLabel;
    private JPanel mainPanel;
    private JPanel currentCheckBoxPanel;
    private JPanel solarisCheckBoxPanel;
    private JPanel linuxCheckBoxPanel;
    private JPanel macosxCheckBoxPanel;
    private JCheckBox[] solarisCheckBoxes;
    private JCheckBox[] linuxCheckBoxes;
    private JCheckBox[] macosxCheckBoxes;
    private JComboBox linkModeCB;
    private int key;
    private boolean initialized;

    public StandardLibsPanel(MakefileWizard makefileWizard) {
        super(makefileWizard);
        String string = new String(this.getString("LBL_StandardLibsPanel"));
        this.setSubTitle(string);
        this.getAccessibleContext().setAccessibleDescription(string);
        this.initialized = false;
    }

    private void create() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        this.mainPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        this.mainPanel.setLayout(new GridBagLayout());
        this.libsLabel = new JLabel(this.getString("LBL_StdLibs"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        this.mainPanel.add((Component)this.libsLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(this.getString("LBL_LinkMode"));
        jLabel.setDisplayedMnemonic(this.getString("MNEM_LinkMode").charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.linkModeCB = new JComboBox();
        jLabel.setLabelFor(this.linkModeCB);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        jPanel2.add((Component)this.linkModeCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        this.mainPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel.add(this.mainPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(jPanel);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    private void addCheckBoxPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        this.mainPanel.add((Component)jPanel, gridBagConstraints);
    }

    private void removeCheckBoxPanel(JPanel jPanel) {
        if (jPanel != null) {
            this.mainPanel.remove(jPanel);
        }
    }

    private JPanel getCheckBoxPanel() {
        JPanel jPanel;
        if (this.getMakefileData().getMakefileOS() == 0) {
            if (this.solarisCheckBoxPanel == null) {
                StdLib[] stdLibArray = this.getMakefileData().getCurrentTarget().getStdLibFlags().getSolarisStdLibs();
                this.solarisCheckBoxes = new JCheckBox[stdLibArray.length];
                this.solarisCheckBoxPanel = this.constructCheckBoxPanel(stdLibArray, this.solarisCheckBoxes);
            }
            jPanel = this.solarisCheckBoxPanel;
        } else if (this.getMakefileData().getMakefileOS() == 4) {
            if (this.macosxCheckBoxPanel == null) {
                StdLib[] stdLibArray = this.getMakefileData().getCurrentTarget().getStdLibFlags().getMacOSXStdLibs();
                this.macosxCheckBoxes = new JCheckBox[stdLibArray.length];
                this.macosxCheckBoxPanel = this.constructCheckBoxPanel(stdLibArray, this.macosxCheckBoxes);
            }
            jPanel = this.macosxCheckBoxPanel;
        } else {
            if (this.linuxCheckBoxPanel == null) {
                StdLib[] stdLibArray = this.getMakefileData().getCurrentTarget().getStdLibFlags().getLinuxStdLibs();
                this.linuxCheckBoxes = new JCheckBox[stdLibArray.length];
                this.linuxCheckBoxPanel = this.constructCheckBoxPanel(stdLibArray, this.linuxCheckBoxes);
            }
            jPanel = this.linuxCheckBoxPanel;
        }
        return jPanel;
    }

    private JCheckBox[] getCheckBoxes() {
        if (this.getMakefileData().getMakefileOS() == 0) {
            return this.solarisCheckBoxes;
        }
        if (this.getMakefileData().getMakefileOS() == 4) {
            return this.macosxCheckBoxes;
        }
        return this.linuxCheckBoxes;
    }

    private JPanel constructCheckBoxPanel(StdLib[] stdLibArray, JCheckBox[] jCheckBoxArray) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        for (int i = 0; i < stdLibArray.length; ++i) {
            jCheckBoxArray[i] = new JCheckBox(stdLibArray[i].getName());
            jCheckBoxArray[i].setMnemonic(stdLibArray[i].getMnemonic());
            jPanel.add((Component)jCheckBoxArray[i], gridBagConstraints);
        }
        return jPanel;
    }

    public void addNotify() {
        TargetData targetData = this.getMakefileData().getCurrentTarget();
        StdLibFlags stdLibFlags = targetData.getStdLibFlags();
        StdLib[] stdLibArray = this.getMakefileData().getMakefileOS() == 0 ? stdLibFlags.getSolarisStdLibs() : (this.getMakefileData().getMakefileOS() == 4 ? stdLibFlags.getMacOSXStdLibs() : stdLibFlags.getLinuxStdLibs());
        this.key = targetData.getKey();
        if (!this.initialized) {
            this.create();
            this.initialized = true;
        }
        if (this.getCheckBoxPanel() != this.currentCheckBoxPanel) {
            this.removeCheckBoxPanel(this.currentCheckBoxPanel);
            this.currentCheckBoxPanel = this.getCheckBoxPanel();
            this.addCheckBoxPanel(this.currentCheckBoxPanel);
        }
        IpeUtils.requestFocus(this.getCheckBoxes()[0]);
        if (targetData.containsXdFiles()) {
            stdLibFlags.motif.setUsed(true);
            stdLibFlags.socketnsl.setUsed(true);
            stdLibFlags.genlib.setUsed(true);
        }
        for (int i = 0; i < stdLibArray.length; ++i) {
            this.getCheckBoxes()[i].setSelected(stdLibArray[i].isUsed());
        }
        this.linkModeCB.removeAllItems();
        if (this.getMakefileData().getToolset() == 0) {
            this.linkModeCB.addItem(this.getString("CB_Static_Sun"));
            this.linkModeCB.addItem(this.getString("CB_Dynamic_Sun"));
        } else {
            this.linkModeCB.addItem(this.getString("CB_Static_GNU"));
            this.linkModeCB.addItem(this.getString("CB_Dynamic_GNU"));
        }
        this.linkModeCB.setSelectedIndex(stdLibFlags.getLinkType());
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        TargetData targetData = this.getMakefileData().getTarget(this.key);
        StdLibFlags stdLibFlags = targetData.getStdLibFlags();
        StdLib[] stdLibArray = this.getMakefileData().getMakefileOS() == 0 ? stdLibFlags.getSolarisStdLibs() : (this.getMakefileData().getMakefileOS() == 4 ? stdLibFlags.getMacOSXStdLibs() : stdLibFlags.getLinuxStdLibs());
        for (int i = 0; i < stdLibArray.length; ++i) {
            stdLibArray[i].setUsed(this.getCheckBoxes()[i].isSelected());
        }
        stdLibFlags.setLinkType(this.linkModeCB.getSelectedIndex());
    }
}

