/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript;

import org.mozilla.nb.javascript.Callable;
import org.mozilla.nb.javascript.Context;
import org.mozilla.nb.javascript.GeneratedClassLoader;
import org.mozilla.nb.javascript.Script;
import org.mozilla.nb.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SecurityController {
    private static SecurityController global;

    static SecurityController global() {
        return global;
    }

    public static boolean hasGlobal() {
        return global != null;
    }

    public static void initGlobal(SecurityController securityController) {
        if (securityController == null) {
            throw new IllegalArgumentException();
        }
        if (global != null) {
            throw new SecurityException("Cannot overwrite already installed global SecurityController");
        }
        global = securityController;
    }

    public abstract GeneratedClassLoader createClassLoader(ClassLoader var1, Object var2);

    public static GeneratedClassLoader createLoader(ClassLoader classLoader, Object object) {
        GeneratedClassLoader generatedClassLoader;
        SecurityController securityController;
        Context context = Context.getContext();
        if (classLoader == null) {
            classLoader = context.getApplicationClassLoader();
        }
        if ((securityController = context.getSecurityController()) == null) {
            generatedClassLoader = context.createClassLoader(classLoader);
        } else {
            Object object2 = securityController.getDynamicSecurityDomain(object);
            generatedClassLoader = securityController.createClassLoader(classLoader, object2);
        }
        return generatedClassLoader;
    }

    public static Class<?> getStaticSecurityDomainClass() {
        SecurityController securityController = Context.getContext().getSecurityController();
        return securityController == null ? null : securityController.getStaticSecurityDomainClassInternal();
    }

    public Class<?> getStaticSecurityDomainClassInternal() {
        return null;
    }

    public abstract Object getDynamicSecurityDomain(Object var1);

    public Object callWithDomain(Object object, Context context, final Callable callable, Scriptable scriptable, final Scriptable scriptable2, final Object[] objectArray) {
        return this.execWithDomain(context, scriptable, new Script(){

            public Object exec(Context context, Scriptable scriptable) {
                return callable.call(context, scriptable, scriptable2, objectArray);
            }
        }, object);
    }

    public Object execWithDomain(Context context, Scriptable scriptable, Script script, Object object) {
        throw new IllegalStateException("callWithDomain should be overridden");
    }
}

