/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript.optimizer;

import org.mozilla.nb.javascript.CompilerEnvirons;
import org.mozilla.nb.javascript.FunctionNode;
import org.mozilla.nb.javascript.JavaAdapter;
import org.mozilla.nb.javascript.ObjToIntMap;
import org.mozilla.nb.javascript.Parser;
import org.mozilla.nb.javascript.ScriptOrFnNode;
import org.mozilla.nb.javascript.ScriptRuntime;
import org.mozilla.nb.javascript.optimizer.Codegen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassCompiler {
    private String mainMethodClassName;
    private CompilerEnvirons compilerEnv;
    private Class<?> targetExtends;
    private Class<?>[] targetImplements;

    public ClassCompiler(CompilerEnvirons compilerEnvirons) {
        if (compilerEnvirons == null) {
            throw new IllegalArgumentException();
        }
        this.compilerEnv = compilerEnvirons;
        this.mainMethodClassName = "org.mozilla.nb.javascript.optimizer.OptRuntime";
    }

    public void setMainMethodClass(String string) {
        this.mainMethodClassName = string;
    }

    public String getMainMethodClass() {
        return this.mainMethodClassName;
    }

    public CompilerEnvirons getCompilerEnv() {
        return this.compilerEnv;
    }

    public Class<?> getTargetExtends() {
        return this.targetExtends;
    }

    public void setTargetExtends(Class<?> clazz) {
        this.targetExtends = clazz;
    }

    public Class<?>[] getTargetImplements() {
        return this.targetImplements == null ? null : (Class[])this.targetImplements.clone();
    }

    public void setTargetImplements(Class<?>[] classArray) {
        this.targetImplements = classArray == null ? null : (Class[])classArray.clone();
    }

    protected String makeAuxiliaryClassName(String string, String string2) {
        return string + string2;
    }

    public Object[] compileToClassFiles(String string, String string2, int n, String string3) {
        Parser parser = new Parser(this.compilerEnv, this.compilerEnv.getErrorReporter());
        ScriptOrFnNode scriptOrFnNode = parser.parse(string, string2, n);
        String string4 = parser.getEncodedSource();
        Class<?> clazz = this.getTargetExtends();
        Class<?>[] classArray = this.getTargetImplements();
        boolean bl = classArray == null && clazz == null;
        String string5 = bl ? string3 : this.makeAuxiliaryClassName(string3, "1");
        Codegen codegen = new Codegen();
        codegen.setMainMethodClass(this.mainMethodClassName);
        byte[] byArray = codegen.compileToClassFile(this.compilerEnv, string5, scriptOrFnNode, string4, false);
        if (bl) {
            return new Object[]{string5, byArray};
        }
        int n2 = scriptOrFnNode.getFunctionCount();
        ObjToIntMap objToIntMap = new ObjToIntMap(n2);
        for (int i = 0; i != n2; ++i) {
            FunctionNode functionNode = scriptOrFnNode.getFunctionNode(i);
            String string6 = functionNode.getFunctionName();
            if (string6 == null || string6.length() == 0) continue;
            objToIntMap.put(string6, functionNode.getParamCount());
        }
        if (clazz == null) {
            clazz = ScriptRuntime.ObjectClass;
        }
        byte[] byArray2 = JavaAdapter.createAdapterCode(objToIntMap, string3, clazz, classArray, string5);
        return new Object[]{string3, byArray2, string5, byArray};
    }
}

