/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript.optimizer;

import org.mozilla.nb.javascript.Callable;
import org.mozilla.nb.javascript.Context;
import org.mozilla.nb.javascript.ContextAction;
import org.mozilla.nb.javascript.ContextFactory;
import org.mozilla.nb.javascript.JavaScriptException;
import org.mozilla.nb.javascript.NativeFunction;
import org.mozilla.nb.javascript.NativeGenerator;
import org.mozilla.nb.javascript.NativeIterator;
import org.mozilla.nb.javascript.Script;
import org.mozilla.nb.javascript.ScriptRuntime;
import org.mozilla.nb.javascript.Scriptable;
import org.mozilla.nb.javascript.ScriptableObject;

public final class OptRuntime
extends ScriptRuntime {
    public static final Double zeroObj = new Double(0.0);
    public static final Double oneObj = new Double(1.0);
    public static final Double minusOneObj = new Double(-1.0);

    public static Object call0(Callable callable, Scriptable scriptable, Context context, Scriptable scriptable2) {
        return callable.call(context, scriptable2, scriptable, ScriptRuntime.emptyArgs);
    }

    public static Object call1(Callable callable, Scriptable scriptable, Object object, Context context, Scriptable scriptable2) {
        return callable.call(context, scriptable2, scriptable, new Object[]{object});
    }

    public static Object call2(Callable callable, Scriptable scriptable, Object object, Object object2, Context context, Scriptable scriptable2) {
        return callable.call(context, scriptable2, scriptable, new Object[]{object, object2});
    }

    public static Object callN(Callable callable, Scriptable scriptable, Object[] objectArray, Context context, Scriptable scriptable2) {
        return callable.call(context, scriptable2, scriptable, objectArray);
    }

    public static Object callName(Object[] objectArray, String string, Context context, Scriptable scriptable) {
        Callable callable = OptRuntime.getNameFunctionAndThis(string, context, scriptable);
        Scriptable scriptable2 = OptRuntime.lastStoredScriptable(context);
        return callable.call(context, scriptable, scriptable2, objectArray);
    }

    public static Object callName0(String string, Context context, Scriptable scriptable) {
        Callable callable = OptRuntime.getNameFunctionAndThis(string, context, scriptable);
        Scriptable scriptable2 = OptRuntime.lastStoredScriptable(context);
        return callable.call(context, scriptable, scriptable2, ScriptRuntime.emptyArgs);
    }

    public static Object callProp0(Object object, String string, Context context, Scriptable scriptable) {
        Callable callable = OptRuntime.getPropFunctionAndThis(object, string, context);
        Scriptable scriptable2 = OptRuntime.lastStoredScriptable(context);
        return callable.call(context, scriptable, scriptable2, ScriptRuntime.emptyArgs);
    }

    public static Object add(Object object, double d) {
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(null);
        }
        if (!(object instanceof String)) {
            return OptRuntime.wrapDouble(OptRuntime.toNumber(object) + d);
        }
        return ((String)object).concat(OptRuntime.toString(d));
    }

    public static Object add(double d, Object object) {
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(null);
        }
        if (!(object instanceof String)) {
            return OptRuntime.wrapDouble(OptRuntime.toNumber(object) + d);
        }
        return OptRuntime.toString(d).concat((String)object);
    }

    public static Object elemIncrDecr(Object object, double d, Context context, int n) {
        return ScriptRuntime.elemIncrDecr(object, new Double(d), context, n);
    }

    public static Object[] padStart(Object[] objectArray, int n) {
        Object[] objectArray2 = new Object[objectArray.length + n];
        System.arraycopy(objectArray, 0, objectArray2, n, objectArray.length);
        return objectArray2;
    }

    public static void initFunction(NativeFunction nativeFunction, int n, Scriptable scriptable, Context context) {
        ScriptRuntime.initFunction(context, scriptable, nativeFunction, n, false);
    }

    public static Object callSpecial(Context context, Callable callable, Scriptable scriptable, Object[] objectArray, Scriptable scriptable2, Scriptable scriptable3, int n, String string, int n2) {
        return ScriptRuntime.callSpecial(context, callable, scriptable, objectArray, scriptable2, scriptable3, n, string, n2);
    }

    public static Object newObjectSpecial(Context context, Object object, Object[] objectArray, Scriptable scriptable, Scriptable scriptable2, int n) {
        return ScriptRuntime.newSpecial(context, object, objectArray, scriptable, n);
    }

    public static Double wrapDouble(double d) {
        if (d == 0.0) {
            if (1.0 / d > 0.0) {
                return zeroObj;
            }
        } else {
            if (d == 1.0) {
                return oneObj;
            }
            if (d == -1.0) {
                return minusOneObj;
            }
            if (d != d) {
                return NaNobj;
            }
        }
        return new Double(d);
    }

    static String encodeIntArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        char[] cArray = new char[1 + n * 2];
        cArray[0] = '\u0001';
        for (int i = 0; i != n; ++i) {
            int n2 = nArray[i];
            int n3 = 1 + i * 2;
            cArray[n3] = (char)(n2 >>> 16);
            cArray[n3 + 1] = (char)n2;
        }
        return new String(cArray);
    }

    private static int[] decodeIntArray(String string, int n) {
        if (n == 0) {
            if (string != null) {
                throw new IllegalArgumentException();
            }
            return null;
        }
        if (string.length() != 1 + n * 2 && string.charAt(0) != '\u0001') {
            throw new IllegalArgumentException();
        }
        int[] nArray = new int[n];
        for (int i = 0; i != n; ++i) {
            int n2 = 1 + i * 2;
            nArray[i] = string.charAt(n2) << 16 | string.charAt(n2 + 1);
        }
        return nArray;
    }

    public static Scriptable newArrayLiteral(Object[] objectArray, String string, int n, Context context, Scriptable scriptable) {
        int[] nArray = OptRuntime.decodeIntArray(string, n);
        return OptRuntime.newArrayLiteral(objectArray, nArray, context, scriptable);
    }

    public static void main(final Script script, final String[] stringArray) {
        ContextFactory.getGlobal().call(new ContextAction(){

            public Object run(Context context) {
                ScriptableObject scriptableObject = ScriptRuntime.getGlobal(context);
                Object[] objectArray = new Object[stringArray.length];
                System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
                Scriptable scriptable = context.newArray((Scriptable)scriptableObject, objectArray);
                scriptableObject.defineProperty("arguments", scriptable, 2);
                script.exec(context, scriptableObject);
                return null;
            }
        });
    }

    public static void throwStopIteration(Object object) {
        throw new JavaScriptException(NativeIterator.getStopIterationObject((Scriptable)object), "", 0);
    }

    public static Scriptable createNativeGenerator(NativeFunction nativeFunction, Scriptable scriptable, Scriptable scriptable2, int n, int n2) {
        return new NativeGenerator(scriptable, nativeFunction, new GeneratorState(scriptable2, n, n2));
    }

    public static Object[] getGeneratorStackState(Object object) {
        GeneratorState generatorState = (GeneratorState)object;
        if (generatorState.stackState == null) {
            generatorState.stackState = new Object[generatorState.maxStack];
        }
        return generatorState.stackState;
    }

    public static Object[] getGeneratorLocalsState(Object object) {
        GeneratorState generatorState = (GeneratorState)object;
        if (generatorState.localsState == null) {
            generatorState.localsState = new Object[generatorState.maxLocals];
        }
        return generatorState.localsState;
    }

    public static class GeneratorState {
        static final String CLASS_NAME = "org/mozilla/nb/javascript/optimizer/OptRuntime$GeneratorState";
        public int resumptionPoint;
        static final String resumptionPoint_NAME = "resumptionPoint";
        static final String resumptionPoint_TYPE = "I";
        public Scriptable thisObj;
        static final String thisObj_NAME = "thisObj";
        static final String thisObj_TYPE = "Lorg/mozilla/nb/javascript/Scriptable;";
        Object[] stackState;
        Object[] localsState;
        int maxLocals;
        int maxStack;

        GeneratorState(Scriptable scriptable, int n, int n2) {
            this.thisObj = scriptable;
            this.maxLocals = n;
            this.maxStack = n2;
        }
    }
}

