/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.debugging;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.debugging.DebuggingView;
import org.netbeans.modules.debugger.jpda.ui.debugging.FiltersDescriptor;
import org.netbeans.modules.debugger.jpda.ui.debugging.TapPanel;
import org.netbeans.modules.debugger.jpda.ui.debugging.ThreadsHistoryAction;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingNodeModel;
import org.openide.awt.DropDownButtonFactory;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoPanel
extends JPanel {
    private static final int PANEL_HEIGHT = 40;
    private static final int FILTERS = 0;
    private static final int HITS = 1;
    private static final int DEADLOCKS = 2;
    private static final int DEADLOCKS_BY_DEBUGGER = 3;
    private static final int STEP_BRKP = 4;
    private Color hitsPanelColor;
    private Color deadlockPanelColor;
    private Color filterPanelColor;
    private Color stepBrkpColor;
    private int tapPanelMinimumHeight;
    private TapPanel tapPanel;
    private Item[] items;
    private JButton arrowButton;
    private JPopupMenu arrowMenu;
    private Map<JPDAThread, JMenuItem> threadToMenuItem = new HashMap<JPDAThread, JMenuItem>();
    private JPDAThread debuggerDeadlockThread;
    private WeakReference<JPDADebugger> stepBrkpDebuggerRef;
    private DebuggingView debuggingView;
    private JPanel deadlocksInnerPanel;
    private JLabel deadlocksLabel;
    private JPanel debuggerDeadlocksInnerPanel;
    private JLabel debuggerDeadlocksLabel;
    private JPanel emptyPanel;
    private JPanel emptyPanel1;
    private JPanel emptyPanel2;
    private JPanel hitsInnerPanel;
    private JLabel hitsLabel;
    private JLabel infoIcon;
    private JLabel infoIcon1;
    private JLabel infoIcon2;
    private JLabel infoIcon3;
    private JButton resumeDebuggerDeadlockButton;
    private JLabel resumeDebuggerDeadlockLabel;
    private JButton stepBrkpIgnoreButton;
    private JPanel stepBrkpInnerPanel;
    private JLabel stepBrkpLabel;

    public InfoPanel(TapPanel tapPanel, DebuggingView debuggingView) {
        this.tapPanel = tapPanel;
        this.debuggingView = debuggingView;
        this.filterPanelColor = tapPanel.getBackground();
        this.deadlockPanelColor = this.hitsPanelColor = DebuggingView.hitsColor;
        this.stepBrkpColor = this.hitsPanelColor;
        this.tapPanelMinimumHeight = tapPanel.getMinimumHeight();
        this.initComponents();
        this.items = new Item[5];
        this.items[0] = new Item(this.filterPanelColor, 40, this.createFilterToolBar());
        this.items[1] = new Item(this.hitsPanelColor, 40, this.hitsInnerPanel);
        this.items[2] = new Item(this.hitsPanelColor, 40, this.deadlocksInnerPanel);
        this.items[3] = new Item(this.deadlockPanelColor, 80, this.debuggerDeadlocksInnerPanel);
        this.items[4] = new Item(this.stepBrkpColor, 80, this.stepBrkpInnerPanel);
        this.items[0].getPanel().setBorder(new EmptyBorder(1, 2, 1, 5));
        this.arrowButton = this.createArrowButton();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.hitsInnerPanel.add((Component)this.arrowButton, gridBagConstraints);
        this.removeAll();
        this.items[0].makeVisible(false, true, null);
        this.items[1].makeInvisible();
        this.items[2].makeInvisible();
        this.items[3].makeInvisible();
        this.items[4].makeInvisible();
        for (int i = this.items.length - 1; i >= 0; --i) {
            this.add(this.items[i].scrollPane);
            if (i <= 0) continue;
            this.add(this.items[i].separator);
        }
    }

    void clearBreakpointHits() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoPanel.this.arrowMenu.removeAll();
                InfoPanel.this.threadToMenuItem.clear();
                InfoPanel.this.hideHitsPanel();
            }
        });
    }

    void removeBreakpointHit(final JPDAThread jPDAThread, final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JMenuItem jMenuItem = (JMenuItem)InfoPanel.this.threadToMenuItem.remove(jPDAThread);
                if (jMenuItem == null) {
                    return;
                }
                InfoPanel.this.arrowMenu.remove(jMenuItem);
                InfoPanel.this.setHitsText(n);
                if (n == 0) {
                    InfoPanel.this.hideHitsPanel();
                }
            }
        });
    }

    void addBreakpointHit(final JPDAThread jPDAThread, final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (InfoPanel.this.threadToMenuItem.get(jPDAThread) != null) {
                    return;
                }
                JMenuItem jMenuItem = InfoPanel.this.createMenuItem(jPDAThread);
                InfoPanel.this.threadToMenuItem.put(jPDAThread, jMenuItem);
                InfoPanel.this.arrowMenu.add(jMenuItem);
                InfoPanel.this.setHitsText(n);
                if (n == 1) {
                    InfoPanel.this.showHitsPanel();
                }
            }
        });
    }

    void setBreakpointHits(final List<JPDAThread> list) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoPanel.this.arrowMenu.removeAll();
                InfoPanel.this.threadToMenuItem.clear();
                for (JPDAThread jPDAThread : list) {
                    JMenuItem jMenuItem = InfoPanel.this.createMenuItem(jPDAThread);
                    InfoPanel.this.threadToMenuItem.put(jPDAThread, jMenuItem);
                    InfoPanel.this.arrowMenu.add(jMenuItem);
                }
                if (list.size() == 0) {
                    InfoPanel.this.hideHitsPanel();
                } else {
                    InfoPanel.this.setHitsText(list.size());
                    InfoPanel.this.showHitsPanel();
                }
            }
        });
    }

    public void recomputeMenuItems(final List<JPDAThread> list) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoPanel.this.arrowMenu.removeAll();
                InfoPanel.this.threadToMenuItem.clear();
                for (JPDAThread jPDAThread : list) {
                    JMenuItem jMenuItem = InfoPanel.this.createMenuItem(jPDAThread);
                    InfoPanel.this.threadToMenuItem.put(jPDAThread, jMenuItem);
                    InfoPanel.this.arrowMenu.add(jMenuItem);
                }
            }
        });
    }

    private JMenuItem createMenuItem(final JPDAThread jPDAThread) {
        JMenuItem jMenuItem;
        ImageIcon imageIcon;
        Object object;
        String string;
        try {
            string = DebuggingNodeModel.getDisplayName(jPDAThread, false);
            object = jPDAThread.getClass().getMethod("getDebugger", new Class[0]);
            imageIcon = (JPDADebugger)((Method)object).invoke((Object)jPDAThread, new Object[0]);
            object = imageIcon.getClass().getMethod("getSession", new Class[0]);
            jMenuItem = (Session)((Method)object).invoke((Object)imageIcon, new Object[0]);
            Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
            if (jMenuItem != session) {
                String string2 = NbBundle.getMessage(ThreadsHistoryAction.class, (String)"CTL_Session", (Object)jMenuItem.getName());
                string = string.charAt(0) + string2 + ", " + string.substring(1);
            }
        }
        catch (Exception exception) {
            string = jPDAThread.getName();
        }
        object = Utilities.loadImage((String)DebuggingNodeModel.getIconBase(jPDAThread));
        imageIcon = object != null ? new ImageIcon((Image)object) : null;
        jMenuItem = new JMenuItem(string, imageIcon);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoPanel.this.debuggingView.makeThreadCurrent(jPDAThread);
            }
        });
        return jMenuItem;
    }

    private void setHitsText(int n) {
        String string = n == 1 ? NbBundle.getMessage(InfoPanel.class, (String)"LBL_OneNewHit") : NbBundle.getMessage(InfoPanel.class, (String)"LBL_NewHits", (Object)n);
        this.hitsLabel.setText(string);
    }

    void setShowDeadlock(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (bl) {
                    InfoPanel.this.showDeadlocksPanel();
                } else {
                    InfoPanel.this.hideDeadlocksPanel();
                }
            }
        });
    }

    void setShowThreadLocks(final JPDAThread jPDAThread, final List<JPDAThread> list) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (list != null) {
                    InfoPanel.this.showDebuggerDeadlockPanel(jPDAThread, list);
                } else {
                    InfoPanel.this.hideDebuggerDeadlockPanel();
                }
            }
        });
    }

    void setShowStepBrkp(final JPDADebugger jPDADebugger, final JPDAThread jPDAThread, final JPDABreakpoint jPDABreakpoint) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (jPDABreakpoint != null) {
                    InfoPanel.this.showStepBrkpPanel(jPDADebugger, jPDAThread, jPDABreakpoint);
                } else {
                    InfoPanel.this.hideStepBrkpPanel();
                }
            }
        });
    }

    private void hidePanel(int n) {
        int n2;
        Item item = this.items[n];
        if (!item.isVisible()) {
            return;
        }
        item.makeInvisible();
        boolean bl = true;
        for (n2 = n + 1; n2 < this.items.length; ++n2) {
            if (!this.items[n2].isVisible()) continue;
            bl = false;
            break;
        }
        if (bl) {
            for (n2 = n - 1; n2 >= 0; --n2) {
                if (!this.items[n2].isVisible()) continue;
                this.items[n2].setTop(true);
                break;
            }
        }
    }

    private void showPanel(int n) {
        Item item = this.items[n];
        if (item.isVisible()) {
            return;
        }
        boolean bl = true;
        for (int i = n + 1; i < this.items.length; ++i) {
            if (!this.items[i].isVisible()) continue;
            bl = false;
            break;
        }
        Item item2 = null;
        if (bl) {
            for (int i = n - 1; i >= 0; --i) {
                if (!this.items[i].isVisible()) continue;
                item2 = this.items[i];
                break;
            }
        }
        item.makeVisible(true, bl, item2);
    }

    private void hideHitsPanel() {
        this.hidePanel(1);
    }

    private void showHitsPanel() {
        this.showPanel(1);
    }

    private void hideDeadlocksPanel() {
        this.hidePanel(2);
    }

    private void showDeadlocksPanel() {
        this.showPanel(2);
    }

    private void hideDebuggerDeadlockPanel() {
        this.hidePanel(3);
    }

    private boolean isInStep(JPDAThread jPDAThread) {
        try {
            Method method = jPDAThread.getClass().getMethod("isInStep", new Class[0]);
            return (Boolean)method.invoke((Object)jPDAThread, new Object[0]);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return false;
        }
    }

    private void showDebuggerDeadlockPanel(JPDAThread jPDAThread, List<JPDAThread> list) {
        String string;
        String string2;
        this.debuggerDeadlockThread = jPDAThread;
        int n = list.size();
        if (n == 1) {
            String string3;
            if (this.isInStep(jPDAThread)) {
                string2 = "InfoPanel.debuggerDeadlocksLabelThread.text";
                string3 = "InfoPanel.resumeDebuggerDeadlockButtonThread.tooltip";
            } else {
                string2 = "InfoPanel.debuggerDeadlocksLabelThread.Method.text";
                string3 = "InfoPanel.resumeDebuggerDeadlockButtonThread.Method.tooltip";
            }
            string = "InfoPanel.resumeDebuggerDeadlockLabelThread.text";
            this.debuggerDeadlocksLabel.setToolTipText(null);
            this.resumeDebuggerDeadlockButton.setToolTipText(NbBundle.getMessage(InfoPanel.class, (String)string3, (Object)list.get(0).getName()));
        } else {
            String string4;
            if (this.isInStep(jPDAThread)) {
                string2 = "InfoPanel.debuggerDeadlocksLabel.text";
                string4 = "InfoPanel.resumeDebuggerDeadlockButton.tooltip";
            } else {
                string2 = "InfoPanel.debuggerDeadlocksLabel.Method.text";
                string4 = "InfoPanel.resumeDebuggerDeadlockButton.Method.tooltip";
            }
            string = "InfoPanel.resumeDebuggerDeadlockLabel.text";
            StringBuilder stringBuilder = new StringBuilder(list.get(0).getName());
            for (int i = 1; i < list.size(); ++i) {
                stringBuilder.append(", ");
                stringBuilder.append(list.get(i).getName());
            }
            String string5 = stringBuilder.toString();
            this.debuggerDeadlocksLabel.setToolTipText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.debuggerDeadlocksLabel.tooltip", (Object)string5));
            this.resumeDebuggerDeadlockButton.setToolTipText(NbBundle.getMessage(InfoPanel.class, (String)string4, (Object)string5));
        }
        this.debuggerDeadlocksLabel.setText(NbBundle.getMessage(InfoPanel.class, (String)string2, (Object)list.get(0).getName()));
        this.resumeDebuggerDeadlockLabel.setText(NbBundle.getMessage(InfoPanel.class, (String)string));
        if (this.items[2].isVisible()) {
            return;
        }
        this.showPanel(3);
    }

    private void hideStepBrkpPanel() {
        this.hidePanel(4);
    }

    private void showStepBrkpPanel(JPDADebugger jPDADebugger, JPDAThread jPDAThread, JPDABreakpoint jPDABreakpoint) {
        this.stepBrkpDebuggerRef = new WeakReference<JPDADebugger>(jPDADebugger);
        String string = NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.stepBrkpLabel.text", (Object)jPDAThread.getName());
        this.stepBrkpLabel.setText(string);
        this.stepBrkpLabel.setToolTipText(string);
        this.showPanel(4);
    }

    private JButton createArrowButton() {
        this.arrowMenu = new JPopupMenu();
        JButton jButton = DropDownButtonFactory.createDropDownButton((Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/jpda/resources/unvisited_bpkt_arrow_small_16.png", (boolean)false), (JPopupMenu)this.arrowMenu);
        jButton.setPreferredSize(new Dimension(40, jButton.getPreferredSize().height));
        jButton.setMaximumSize(new Dimension(40, jButton.getPreferredSize().height));
        jButton.setFocusable(false);
        jButton.setOpaque(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (InfoPanel.this.arrowMenu.getComponentCount() > 0) {
                    Component component = InfoPanel.this.arrowMenu.getComponent(0);
                    for (Map.Entry entry : InfoPanel.this.threadToMenuItem.entrySet()) {
                        if (entry.getValue() != component) continue;
                        InfoPanel.this.debuggingView.makeThreadCurrent((JPDAThread)entry.getKey());
                    }
                }
            }
        });
        return jButton;
    }

    private JToolBar createFilterToolBar() {
        int n;
        FiltersDescriptor filtersDescriptor = FiltersDescriptor.getInstance();
        NoBorderToolBar noBorderToolBar = new NoBorderToolBar();
        noBorderToolBar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        noBorderToolBar.setFloatable(false);
        noBorderToolBar.setBorderPainted(false);
        noBorderToolBar.setOpaque(false);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            noBorderToolBar.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        int n2 = filtersDescriptor.getFilterCount();
        ArrayList<JToggleButton> arrayList = new ArrayList<JToggleButton>(n2);
        JToggleButton jToggleButton = null;
        for (n = 0; n < n2; ++n) {
            jToggleButton = this.createToggle(filtersDescriptor, n);
            arrayList.add(jToggleButton);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            JToggleButton jToggleButton2 = (JToggleButton)arrayList.get(n);
            jToggleButton2.addActionListener(new ToggleButtonActionListener(n));
            noBorderToolBar.add(jToggleButton2);
            if (n == arrayList.size() - 1) continue;
            noBorderToolBar.addSeparator(new Dimension(3, 0));
        }
        return noBorderToolBar;
    }

    private JToggleButton createToggle(FiltersDescriptor filtersDescriptor, int n) {
        boolean bl = filtersDescriptor.isSelected(n);
        Icon icon = filtersDescriptor.getSelectedIcon(n);
        JToggleButton jToggleButton = new JToggleButton(icon, bl);
        jToggleButton.setMargin(new Insets(2, 2, 2, 2));
        jToggleButton.setToolTipText(filtersDescriptor.getTooltip(n));
        jToggleButton.setFocusable(false);
        filtersDescriptor.connectToggleButton(n, jToggleButton);
        return jToggleButton;
    }

    private void resumeThreadToFreeMonitor(JPDAThread jPDAThread) {
        try {
            Method method = jPDAThread.getClass().getMethod("resumeBlockingThreads", new Class[0]);
            method.invoke((Object)jPDAThread, new Object[0]);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    private void initComponents() {
        this.stepBrkpInnerPanel = new JPanel();
        this.infoIcon3 = new JLabel();
        this.stepBrkpLabel = new JLabel();
        this.stepBrkpIgnoreButton = new JButton();
        this.debuggerDeadlocksInnerPanel = new JPanel();
        this.infoIcon2 = new JLabel();
        this.debuggerDeadlocksLabel = new JLabel();
        this.resumeDebuggerDeadlockLabel = new JLabel();
        this.emptyPanel2 = new JPanel();
        this.resumeDebuggerDeadlockButton = new JButton();
        this.deadlocksInnerPanel = new JPanel();
        this.infoIcon1 = new JLabel();
        this.deadlocksLabel = new JLabel();
        this.emptyPanel1 = new JPanel();
        this.hitsInnerPanel = new JPanel();
        this.infoIcon = new JLabel();
        this.hitsLabel = new JLabel();
        this.emptyPanel = new JPanel();
        this.setLayout(new BoxLayout(this, 3));
        this.stepBrkpInnerPanel.setOpaque(false);
        this.stepBrkpInnerPanel.setLayout(new GridBagLayout());
        this.infoIcon3.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/debugger/jpda/resources/info_big.png")));
        this.infoIcon3.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.infoIcon3.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.stepBrkpInnerPanel.add((Component)this.infoIcon3, gridBagConstraints);
        this.stepBrkpLabel.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.stepBrkpLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.stepBrkpInnerPanel.add((Component)this.stepBrkpLabel, gridBagConstraints);
        this.stepBrkpIgnoreButton.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.stepBrkpIgnoreButton.text"));
        this.stepBrkpIgnoreButton.setToolTipText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.stepBrkpIgnoreButton.tooltip"));
        this.stepBrkpIgnoreButton.setMargin(new Insets(0, 3, 0, 3));
        this.stepBrkpIgnoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoPanel.this.stepBrkpIgnoreButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.stepBrkpInnerPanel.add((Component)this.stepBrkpIgnoreButton, gridBagConstraints);
        this.add(this.stepBrkpInnerPanel);
        this.debuggerDeadlocksInnerPanel.setOpaque(false);
        this.debuggerDeadlocksInnerPanel.setPreferredSize(new Dimension(0, 16));
        this.debuggerDeadlocksInnerPanel.setLayout(new GridBagLayout());
        this.infoIcon2.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/debugger/jpda/resources/wrong_pass.png")));
        this.infoIcon2.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.infoIcon2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.debuggerDeadlocksInnerPanel.add((Component)this.infoIcon2, gridBagConstraints);
        this.debuggerDeadlocksLabel.setForeground(UIManager.getDefaults().getColor("nb.errorForeground"));
        this.debuggerDeadlocksLabel.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.debuggerDeadlocksLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 9);
        this.debuggerDeadlocksInnerPanel.add((Component)this.debuggerDeadlocksLabel, gridBagConstraints);
        this.resumeDebuggerDeadlockLabel.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.resumeDebuggerDeadlockLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.debuggerDeadlocksInnerPanel.add((Component)this.resumeDebuggerDeadlockLabel, gridBagConstraints);
        this.emptyPanel2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.debuggerDeadlocksInnerPanel.add((Component)this.emptyPanel2, gridBagConstraints);
        this.resumeDebuggerDeadlockButton.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.resumeDebuggerDeadlockButton.text"));
        this.resumeDebuggerDeadlockButton.setMargin(new Insets(0, 3, 0, 3));
        this.resumeDebuggerDeadlockButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoPanel.this.resumeDebuggerDeadlockButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 9);
        this.debuggerDeadlocksInnerPanel.add((Component)this.resumeDebuggerDeadlockButton, gridBagConstraints);
        this.add(this.debuggerDeadlocksInnerPanel);
        this.deadlocksInnerPanel.setOpaque(false);
        this.deadlocksInnerPanel.setPreferredSize(new Dimension(0, 16));
        this.deadlocksInnerPanel.setLayout(new GridBagLayout());
        this.infoIcon1.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/debugger/jpda/resources/wrong_pass.png")));
        this.infoIcon1.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.infoIcon1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.deadlocksInnerPanel.add((Component)this.infoIcon1, gridBagConstraints);
        this.deadlocksLabel.setForeground(UIManager.getDefaults().getColor("nb.errorForeground"));
        this.deadlocksLabel.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.deadlocksLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.deadlocksInnerPanel.add((Component)this.deadlocksLabel, gridBagConstraints);
        this.emptyPanel1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.deadlocksInnerPanel.add((Component)this.emptyPanel1, gridBagConstraints);
        this.add(this.deadlocksInnerPanel);
        this.hitsInnerPanel.setOpaque(false);
        this.hitsInnerPanel.setLayout(new GridBagLayout());
        this.infoIcon.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/debugger/jpda/resources/info_big.png")));
        this.infoIcon.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.infoIcon.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.hitsInnerPanel.add((Component)this.infoIcon, gridBagConstraints);
        this.hitsLabel.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.hitsLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.hitsInnerPanel.add((Component)this.hitsLabel, gridBagConstraints);
        this.emptyPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.hitsInnerPanel.add((Component)this.emptyPanel, gridBagConstraints);
        this.add(this.hitsInnerPanel);
    }

    private void resumeDebuggerDeadlockButtonActionPerformed(ActionEvent actionEvent) {
        RequestProcessor requestProcessor;
        final JPDAThread jPDAThread = this.debuggerDeadlockThread;
        try {
            JPDADebugger jPDADebugger = (JPDADebugger)jPDAThread.getClass().getMethod("getDebugger", new Class[0]).invoke((Object)jPDAThread, new Object[0]);
            Session session = (Session)jPDADebugger.getClass().getMethod("getSession", new Class[0]).invoke((Object)jPDADebugger, new Object[0]);
            requestProcessor = (RequestProcessor)session.lookupFirst(null, RequestProcessor.class);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return;
        }
        requestProcessor.post(new Runnable(){

            public void run() {
                InfoPanel.this.resumeThreadToFreeMonitor(jPDAThread);
            }
        });
        this.hideDebuggerDeadlockPanel();
    }

    private void stepBrkpIgnoreButtonActionPerformed(ActionEvent actionEvent) {
        JPDADebugger jPDADebugger;
        if (this.stepBrkpDebuggerRef != null && (jPDADebugger = (JPDADebugger)this.stepBrkpDebuggerRef.get()) != null) {
            try {
                jPDADebugger.getClass().getMethod("resume", new Class[0]).invoke((Object)jPDADebugger, new Object[0]);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
    }

    private static class NoBorderToolBar
    extends JToolBar {
        public NoBorderToolBar() {
        }

        public NoBorderToolBar(int n) {
            super(n);
        }

        protected void paintComponent(Graphics graphics) {
        }
    }

    public class Item {
        private Color backgroundColor;
        private int preferredHeight;
        private JPanel topGapPanel;
        private JPanel bottomGapPanel;
        private JPanel outerPanel;
        private JComponent innerPanel;
        private JScrollPane scrollPane;
        private JPanel separator;
        private boolean animationRunning = false;
        private boolean isTop = false;

        Item(Color color, int n, JComponent jComponent) {
            this.backgroundColor = color;
            this.preferredHeight = n;
            this.innerPanel = jComponent;
            this.topGapPanel = this.createGapPanel();
            this.bottomGapPanel = this.createGapPanel();
            this.separator = this.createSeparator();
            this.outerPanel = new JPanel();
            this.outerPanel.setBackground(color);
            this.outerPanel.setLayout(new BorderLayout());
            this.outerPanel.add("North", this.topGapPanel);
            this.outerPanel.add("Center", jComponent);
            this.outerPanel.add("South", this.bottomGapPanel);
            this.outerPanel.setPreferredSize(new Dimension(0, n));
            this.scrollPane = new JScrollPane();
            this.scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.scrollPane.setPreferredSize(new Dimension(0, n));
            this.scrollPane.setVerticalScrollBarPolicy(21);
            this.scrollPane.setHorizontalScrollBarPolicy(31);
            this.scrollPane.setViewportView(this.outerPanel);
        }

        public JPanel getPanel() {
            return this.outerPanel;
        }

        public boolean isVisible() {
            return this.scrollPane.isVisible() || this.animationRunning;
        }

        private JPanel createGapPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            jPanel.setPreferredSize(new Dimension(0, InfoPanel.this.tapPanelMinimumHeight));
            return jPanel;
        }

        private JPanel createSeparator() {
            JPanel jPanel = new JPanel();
            jPanel.setBackground(UIManager.getDefaults().getColor("Separator.foreground"));
            jPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 1));
            jPanel.setMinimumSize(new Dimension(10, 1));
            jPanel.setPreferredSize(new Dimension(0, 1));
            return jPanel;
        }

        private synchronized void makeInvisible() {
            this.scrollPane.setVisible(false);
            this.separator.setVisible(false);
            if (this.animationRunning) {
                this.animationRunning = false;
            }
            this.setTop(this.isTop);
        }

        private synchronized void makeVisible(boolean bl, boolean bl2, Item item) {
            int n;
            if (this.animationRunning) {
                return;
            }
            int n2 = n = bl2 ? this.preferredHeight - InfoPanel.this.tapPanelMinimumHeight : this.preferredHeight;
            if (!bl) {
                this.setTop(bl2);
                if (bl2 && item != null) {
                    item.setTop(false);
                }
                this.scrollPane.setPreferredSize(new Dimension(0, n));
                this.outerPanel.setPreferredSize(new Dimension(0, n));
                this.scrollPane.setVisible(true);
                this.separator.setVisible(true);
            } else {
                this.scrollPane.setPreferredSize(new Dimension(0, 1));
                this.outerPanel.setPreferredSize(new Dimension(0, n));
                this.animationRunning = true;
                this.isTop = bl2;
                if (this.isTop && item != null) {
                    item.setTop(false);
                }
                this.topGapPanel.setVisible(!this.isTop);
                if (this.animationRunning) {
                    this.scrollPane.setVisible(true);
                    this.separator.setVisible(true);
                    InfoPanel.this.tapPanel.revalidate();
                }
                if (this.isTop) {
                    InfoPanel.this.tapPanel.setBackground(this.backgroundColor);
                }
                int n3 = 1;
                int n4 = 1;
                Timer timer = new Timer(20, null);
                timer.addActionListener(new AnimationTimerListener(timer, n3, n4));
                timer.setCoalesce(false);
                timer.start();
            }
        }

        private synchronized void setTop(boolean bl) {
            this.isTop = bl;
            if (bl) {
                this.topGapPanel.setVisible(false);
                if (!this.animationRunning) {
                    this.outerPanel.setPreferredSize(new Dimension(0, this.preferredHeight - InfoPanel.this.tapPanelMinimumHeight));
                    this.scrollPane.setPreferredSize(new Dimension(0, this.preferredHeight - InfoPanel.this.tapPanelMinimumHeight));
                }
                InfoPanel.this.tapPanel.setBackground(this.backgroundColor);
            } else {
                this.topGapPanel.setVisible(true);
                this.outerPanel.setPreferredSize(new Dimension(0, this.preferredHeight));
                this.scrollPane.setPreferredSize(new Dimension(0, this.preferredHeight));
            }
        }

        private class AnimationTimerListener
        implements ActionListener {
            private int delta;
            private int currHeight;
            private Timer animationTimer;
            private long time = 0L;

            public AnimationTimerListener(Timer timer, int n, int n2) {
                this.delta = n;
                this.currHeight = n2;
                this.animationTimer = timer;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                long l = System.nanoTime();
                int n2 = this.time > 0L ? this.delta * ((int)(l - this.time) / (this.animationTimer.getDelay() * 1000000) + 1) : this.delta;
                this.time = l;
                this.currHeight += n2;
                int n3 = n = Item.this.isTop ? Item.this.preferredHeight - InfoPanel.this.tapPanelMinimumHeight : Item.this.preferredHeight;
                if (this.currHeight > n) {
                    this.currHeight = n;
                }
                Item.this.scrollPane.setPreferredSize(new Dimension(0, this.currHeight));
                InfoPanel.this.revalidate();
                InfoPanel.this.doLayout();
                if (this.currHeight >= (Item.this.isTop ? Item.this.preferredHeight - InfoPanel.this.tapPanelMinimumHeight : Item.this.preferredHeight)) {
                    this.animationTimer.stop();
                    Item item = Item.this;
                    synchronized (item) {
                        Item.this.animationRunning = false;
                    }
                }
            }
        }
    }

    private static class ToggleButtonActionListener
    implements ActionListener {
        private int index;

        public ToggleButtonActionListener(int n) {
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
            FiltersDescriptor.getInstance().setSelected(this.index, jToggleButton.isSelected());
        }
    }
}

