/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.debugging;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.modules.debugger.jpda.ui.debugging.SwitcherTable;
import org.netbeans.modules.debugger.jpda.ui.debugging.SwitcherTableItem;
import org.netbeans.modules.debugger.jpda.ui.debugging.ThreadsHistoryAction;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class KeyboardPopupSwitcher
implements WindowFocusListener {
    private static final int TIME_TO_SHOW = 300;
    private static KeyboardPopupSwitcher instance;
    private static JDialog popup;
    private static boolean shown;
    private static Timer invokerTimer;
    private static AWTListener awtListener;
    private static boolean invokerTimerRunning;
    private static int hits;
    private static SwitcherTableItem[] items;
    private SwitcherTable pTable;
    private static int triggerKey;
    private static int reverseKey;
    private static int releaseKey;
    private static boolean cancelOnFocusLost;
    private int x;
    private int y;
    private boolean fwd = true;

    public static boolean processShortcut(KeyEvent keyEvent) {
        boolean bl;
        boolean bl2 = keyEvent.getKeyCode() == 9 && keyEvent.getModifiers() == 2;
        boolean bl3 = bl = keyEvent.getKeyCode() == 9 && keyEvent.getModifiers() == 3;
        if (KeyboardPopupSwitcher.isShown()) {
            assert (instance != null);
            instance.processKeyEvent(keyEvent);
            keyEvent.consume();
            return true;
        }
        if (bl2 || bl) {
            if (KeyboardPopupSwitcher.isAlive()) {
                KeyboardPopupSwitcher.processInterruption(keyEvent);
            }
            keyEvent.consume();
            return true;
        }
        if (keyEvent.getKeyCode() == 17 && KeyboardPopupSwitcher.isAlive()) {
            KeyboardPopupSwitcher.processInterruption(keyEvent);
            return true;
        }
        return false;
    }

    public static void selectItem(SwitcherTableItem[] switcherTableItemArray, int n, int n2, boolean bl) {
        KeyboardPopupSwitcher.selectItem(switcherTableItemArray, n, n2, bl, true);
    }

    public static void selectItem(SwitcherTableItem[] switcherTableItemArray, int n, int n2, boolean bl, boolean bl2) {
        if (invokerTimerRunning) {
            return;
        }
        items = switcherTableItemArray;
        releaseKey = n;
        triggerKey = n2;
        cancelOnFocusLost = bl2;
        invokerTimer = new Timer(300, new PopupInvoker(bl));
        invokerTimer.setRepeats(false);
        invokerTimer.start();
        invokerTimerRunning = true;
        awtListener = new AWTListener();
        Toolkit.getDefaultToolkit().addAWTEventListener(awtListener, 8L);
    }

    private static void cleanupInterrupter() {
        invokerTimerRunning = false;
        if (invokerTimer != null) {
            invokerTimer.stop();
        }
    }

    public static boolean isShown() {
        return shown;
    }

    private static boolean isAlive() {
        return invokerTimerRunning || shown;
    }

    private KeyboardPopupSwitcher(int n, boolean bl) {
        this.fwd = bl;
        this.pTable = new SwitcherTable(items);
        Dimension dimension = this.pTable.getPreferredSize();
        Rectangle rectangle = Utilities.getUsableScreenBounds();
        this.x = rectangle.x + (rectangle.width / 2 - dimension.width / 2);
        this.y = rectangle.y + (rectangle.height / 2 - dimension.height / 2);
        int n2 = this.pTable.getColumnCount();
        int n3 = this.pTable.getRowCount();
        assert (n2 > 0) : "There aren't any columns in the KeyboardPopupSwitcher's table";
        assert (n3 > 0) : "There aren't any rows in the KeyboardPopupSwitcher's table";
        this.changeTableSelection(n3 > n && n >= 0 ? n : n3 - 1, 0);
    }

    private void showPopup() {
        if (!KeyboardPopupSwitcher.isShown()) {
            InputMap inputMap = this.pTable.getInputMap(2);
            inputMap.put(KeyStroke.getKeyStroke(27, 512, true), "escape");
            inputMap.put(KeyStroke.getKeyStroke(27, 576, true), "escape");
            inputMap.put(KeyStroke.getKeyStroke(releaseKey, 0, true), "close");
            inputMap.put(KeyStroke.getKeyStroke(10, 0, false), "close");
            inputMap.put(KeyStroke.getKeyStroke(releaseKey, 64, true), "close");
            inputMap.put(KeyStroke.getKeyStroke(triggerKey, 512), "triggerKeyPressed");
            inputMap.put(KeyStroke.getKeyStroke(triggerKey, 576), "triggerKeyPressed");
            inputMap.put(KeyStroke.getKeyStroke(reverseKey, 512, true), "reverseKeyReleased");
            inputMap.put(KeyStroke.getKeyStroke(reverseKey, 512, false), "reverseKeyPressed");
            inputMap.put(KeyStroke.getKeyStroke(reverseKey, 576, false), "reverseKeyPressed");
            this.pTable.setInputMap(2, inputMap);
            this.pTable.setInputMap(0, inputMap);
            AbstractAction abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KeyboardPopupSwitcher.processShortcut(new KeyEvent((JComponent)actionEvent.getSource(), 402, actionEvent.getWhen(), actionEvent.getModifiers(), releaseKey, '\u0000'));
                }
            };
            AbstractAction abstractAction2 = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KeyboardPopupSwitcher.processShortcut(new KeyEvent((JComponent)actionEvent.getSource(), 402, actionEvent.getWhen(), actionEvent.getModifiers(), 27, '\u0000'));
                }
            };
            AbstractAction abstractAction3 = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KeyboardPopupSwitcher.processShortcut(new KeyEvent((JComponent)actionEvent.getSource(), 401, actionEvent.getWhen(), actionEvent.getModifiers(), triggerKey, '\u0000'));
                }
            };
            AbstractAction abstractAction4 = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KeyboardPopupSwitcher.processShortcut(new KeyEvent((JComponent)actionEvent.getSource(), 402, actionEvent.getWhen(), actionEvent.getModifiers(), reverseKey, '\u0000'));
                }
            };
            AbstractAction abstractAction5 = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KeyboardPopupSwitcher.processShortcut(new KeyEvent((JComponent)actionEvent.getSource(), 401, actionEvent.getWhen(), actionEvent.getModifiers(), reverseKey, '\u0000'));
                }
            };
            final ActionMap actionMap = this.pTable.getActionMap();
            actionMap.put("close", abstractAction);
            actionMap.put("escape", abstractAction2);
            actionMap.put("triggerKeyPressed", abstractAction3);
            actionMap.put("reverseKeyPressed", abstractAction5);
            actionMap.put("reverseKeyReleased", abstractAction4);
            actionMap.remove("selectNextRow");
            this.pTable.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    int n = mouseEvent.getButton();
                    int n2 = mouseEvent.getClickCount();
                    if (n == 1 && n2 == 2) {
                        actionMap.get("close").actionPerformed(new ActionEvent(mouseEvent.getSource(), mouseEvent.getID(), "close"));
                    }
                }

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }

                public void mouseExited(MouseEvent mouseEvent) {
                }
            });
            popup = new JDialog(WindowManager.getDefault().getMainWindow());
            popup.setUndecorated(true);
            popup.getContentPane().add(this.pTable);
            popup.setLocation(this.x, this.y);
            popup.pack();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    popup.addWindowFocusListener(KeyboardPopupSwitcher.this);
                }
            });
            popup.setVisible(true);
            shown = true;
        }
    }

    private static void processInterruption(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == releaseKey && keyEvent.getID() == 402) {
            KeyboardPopupSwitcher.cleanupInterrupter();
            hits = 0;
            ThreadsHistoryAction threadsHistoryAction = new ThreadsHistoryAction();
            threadsHistoryAction.actionPerformed(new ActionEvent(keyEvent.getSource(), 1001, "immediately", keyEvent.getModifiers()));
            keyEvent.consume();
        } else if (n == triggerKey && keyEvent.getModifiers() == 2 && keyEvent.getID() == 401) {
            keyEvent.consume();
            KeyboardPopupSwitcher.cleanupInterrupter();
            instance = new KeyboardPopupSwitcher(++hits + 1, true);
            instance.showPopup();
        }
    }

    private void processKeyEvent(KeyEvent keyEvent) {
        switch (keyEvent.getID()) {
            case 401: {
                int n = keyEvent.getKeyCode();
                if (n == reverseKey) {
                    this.fwd = false;
                } else if (n == triggerKey) {
                    int n2 = this.pTable.getRowCount() - 1;
                    int n3 = this.pTable.getColumnCount() - 1;
                    int n4 = this.pTable.getSelectedRow();
                    int n5 = this.pTable.getSelectedColumn();
                    int n6 = n4;
                    int n7 = n5;
                    if (this.fwd) {
                        if (n4 >= n2) {
                            n6 = 0;
                            n7 = n5 >= n3 ? 0 : ++n7;
                        } else if (this.pTable.getValueAt(++n6, n7) == null) {
                            n6 = 0;
                            n7 = 0;
                        }
                    } else if (n4 == 0) {
                        if (n5 == 0) {
                            n7 = n3;
                            n6 = this.pTable.getLastValidRow();
                        } else {
                            --n7;
                            n6 = n2;
                        }
                    } else {
                        --n6;
                    }
                    if (n6 >= 0 && n7 >= 0) {
                        this.changeTableSelection(n6, n7);
                    }
                }
                keyEvent.consume();
                break;
            }
            case 402: {
                int n = keyEvent.getKeyCode();
                if (n == reverseKey) {
                    this.fwd = true;
                    keyEvent.consume();
                    break;
                }
                if (n == 27) {
                    this.cancelSwitching();
                    break;
                }
                if (n != releaseKey) break;
                this.performSwitching();
            }
        }
    }

    private void changeTableSelection(int n, int n2) {
        this.pTable.changeSelection(n, n2, false, false);
        SwitcherTableItem switcherTableItem = this.pTable.getSelectedItem();
        if (switcherTableItem != null) {
            String string = switcherTableItem.getDescription();
            StatusDisplayer.getDefault().setStatusText(string != null ? string : "");
        }
    }

    private void cancelSwitching() {
        this.hideCurrentPopup();
        StatusDisplayer.getDefault().setStatusText("");
    }

    private void performSwitching() {
        SwitcherTableItem switcherTableItem;
        if (popup != null && (switcherTableItem = this.pTable.getSelectedItem()) != null) {
            switcherTableItem.activate();
        }
        this.cancelSwitching();
    }

    private synchronized void hideCurrentPopup() {
        if (popup != null) {
            SwingUtilities.invokeLater(new PopupHider(popup));
        }
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    public void windowLostFocus(WindowEvent windowEvent) {
        if (cancelOnFocusLost && windowEvent.getOppositeWindow() != popup) {
            this.cancelSwitching();
        }
    }

    static {
        reverseKey = 16;
        cancelOnFocusLost = true;
    }

    private static class AWTListener
    implements AWTEventListener {
        private AWTListener() {
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            if (!(aWTEvent instanceof KeyEvent)) {
                return;
            }
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            if (keyEvent.getKeyCode() == 18) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                KeyEvent keyEvent2 = new KeyEvent((Component)keyEvent.getSource(), 402, keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
                KeyboardPopupSwitcher.processInterruption(keyEvent2);
            }
        }
    }

    private class PopupHider
    implements Runnable {
        private JDialog toHide;

        public PopupHider(JDialog jDialog) {
            this.toHide = jDialog;
        }

        public void run() {
            this.toHide.setVisible(false);
            shown = false;
            hits = 0;
            this.toHide.removeWindowFocusListener(KeyboardPopupSwitcher.this);
        }
    }

    private static class PopupInvoker
    implements ActionListener {
        private boolean forward;

        public PopupInvoker(boolean bl) {
            this.forward = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(awtListener);
            if (invokerTimerRunning) {
                KeyboardPopupSwitcher.cleanupInterrupter();
                instance = new KeyboardPopupSwitcher(this.forward ? hits + 1 : items.length - hits - 1, this.forward);
                instance.showPopup();
            }
        }
    }
}

