/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.modules.debugger.jpda.ui.FixedWatchesManager;
import org.netbeans.modules.debugger.jpda.ui.WatchPanel;
import org.netbeans.modules.debugger.jpda.ui.models.WatchesNodeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class WatchesActionsProvider
implements NodeActionsProvider {
    static final Action NEW_WATCH_ACTION = new AbstractAction(NbBundle.getBundle(WatchesActionsProvider.class).getString("CTL_WatchAction_AddNew")){

        public void actionPerformed(ActionEvent actionEvent) {
            WatchesActionsProvider.newWatch();
        }
    };
    private final Action DELETE_ALL_ACTION = new AbstractAction(NbBundle.getBundle(WatchesActionsProvider.class).getString("CTL_WatchAction_DeleteAll")){

        public void actionPerformed(ActionEvent actionEvent) {
            DebuggerManager.getDebuggerManager().removeAllWatches();
            List list = WatchesActionsProvider.this.contextProvider.lookup("WatchesView", NodeActionsProviderFilter.class);
            FixedWatchesManager fixedWatchesManager = null;
            for (Object e : list) {
                if (!(e instanceof FixedWatchesManager)) continue;
                fixedWatchesManager = (FixedWatchesManager)e;
                break;
            }
            if (fixedWatchesManager != null) {
                fixedWatchesManager.deleteAllFixedWatches();
            }
        }
    };
    private static final Action DELETE_ACTION = Models.createAction((String)NbBundle.getBundle(WatchesActionsProvider.class).getString("CTL_WatchAction_Delete"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return !WatchesNodeModel.isEmptyWatch(object);
        }

        public void perform(Object[] objectArray) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                ((JPDAWatch)objectArray[i]).remove();
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private static final Action CUSTOMIZE_ACTION;
    private ContextProvider contextProvider;

    public WatchesActionsProvider(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return new Action[]{NEW_WATCH_ACTION, null, this.DELETE_ALL_ACTION};
        }
        if (object instanceof JPDAWatch) {
            return new Action[]{NEW_WATCH_ACTION, null, DELETE_ACTION, this.DELETE_ALL_ACTION, null, CUSTOMIZE_ACTION};
        }
        throw new UnknownTypeException(object);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return;
        }
        if (object instanceof JPDAWatch) {
            WatchesActionsProvider.customize((JPDAWatch)object);
            return;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }

    private static void customize(JPDAWatch jPDAWatch) {
        WatchPanel watchPanel = new WatchPanel(jPDAWatch.getExpression());
        JComponent jComponent = watchPanel.getPanel();
        ResourceBundle resourceBundle = NbBundle.getBundle(WatchesActionsProvider.class);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jComponent, MessageFormat.format(resourceBundle.getString("CTL_Edit_Watch_Dialog_Title"), jPDAWatch.getExpression()));
        dialogDescriptor.setHelpCtx(new HelpCtx("debug.customize.watch"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        dialog.dispose();
        if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
            return;
        }
        if (jComponent.getClientProperty("WatchCanceled") != null) {
            return;
        }
        jPDAWatch.setExpression(watchPanel.getExpression());
    }

    private static void newWatch() {
        WatchPanel watchPanel = new WatchPanel("");
        JComponent jComponent = watchPanel.getPanel();
        ResourceBundle resourceBundle = NbBundle.getBundle(WatchesActionsProvider.class);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jComponent, resourceBundle.getString("CTL_New_Watch_Dialog_Title"));
        dialogDescriptor.setHelpCtx(new HelpCtx("debug.new.watch"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        dialog.dispose();
        if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
            return;
        }
        if (jComponent.getClientProperty("WatchCanceled") != null) {
            return;
        }
        String string = watchPanel.getExpression();
        if (string == null || string.trim().length() == 0) {
            return;
        }
        DebuggerManager.getDebuggerManager().createWatch(string);
    }

    static {
        DELETE_ACTION.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        CUSTOMIZE_ACTION = Models.createAction((String)NbBundle.getBundle(WatchesActionsProvider.class).getString("CTL_WatchAction_Customize"), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object object) {
                return true;
            }

            public void perform(Object[] objectArray) {
                WatchesActionsProvider.customize((JPDAWatch)objectArray[0]);
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }
}

