/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.customizer.MakeCustomizer;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MakeCustomizerProvider
implements CustomizerProvider {
    private final Project project;
    private static final int OPTION_OK = 0;
    private static final int OPTION_CANCEL = 1;
    private static final int OPTION_APPLY = 2;
    public static final String COMMAND_OK = "OK";
    public static final String COMMAND_CANCEL = "CANCEL";
    public static final String COMMAND_APPLY = "APPLY";
    private DialogDescriptor dialogDescriptor;
    private Map<Project, Dialog> customizerPerProject = new WeakHashMap<Project, Dialog>();
    private ConfigurationDescriptorProvider projectDescriptorProvider;
    private String currentCommand;
    private final Set<ActionListener> actionListenerList = new HashSet<ActionListener>();
    private static ResourceBundle bundle;

    public MakeCustomizerProvider(Project project, ConfigurationDescriptorProvider configurationDescriptorProvider) {
        this.project = project;
        this.projectDescriptorProvider = configurationDescriptorProvider;
    }

    public void showCustomizer() {
        this.showCustomizer(null, null, null);
    }

    public void showCustomizer(Item item) {
        this.showCustomizer(null, item, null);
    }

    public void showCustomizer(Folder folder) {
        this.showCustomizer(null, null, folder);
    }

    public void showCustomizer(String string) {
        this.showCustomizer(string, null, null);
    }

    public void showCustomizer(final String string, final Item item, final Folder folder) {
        if (!this.projectDescriptorProvider.gotDescriptor() || this.projectDescriptorProvider.getConfigurationDescriptor().getConfs().size() == 0) {
            return;
        }
        RequestProcessor.Task task = RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                MakeCustomizerProvider.this.showCustomizerWorker(string, item, folder);
            }
        });
    }

    private void showCustomizerWorker(String string, Item item, Folder folder) {
        Object[] objectArray;
        if (this.customizerPerProject.containsKey(this.project) && (objectArray = this.customizerPerProject.get(this.project)).isShowing()) {
            objectArray.setVisible(true);
            return;
        }
        if (folder != null) {
            objectArray = this.projectDescriptorProvider.getConfigurationDescriptor().getConfs().getConfs();
            for (int i = 0; i < objectArray.length; ++i) {
                folder.getFolderConfiguration(objectArray[i]);
            }
        }
        this.projectDescriptorProvider.getConfigurationDescriptor().refreshRequiredLanguages();
        objectArray = new JButton[]{new JButton(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"LBL_Customizer_Ok_Option")), new JButton(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"LBL_Customizer_Cancel_Option")), new JButton(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"LBL_Customizer_Apply_Option"))};
        ((AbstractButton)objectArray[0]).setActionCommand(COMMAND_OK);
        ((JButton)objectArray[0]).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"ACSD_Customizer_Ok_Option"));
        ((AbstractButton)objectArray[1]).setActionCommand(COMMAND_CANCEL);
        ((JButton)objectArray[1]).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"ACSD_Customizer_Cancel_Option"));
        ((AbstractButton)objectArray[2]).setActionCommand(COMMAND_APPLY);
        ((JButton)objectArray[2]).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"ACSD_Customizer_Apply_Option"));
        ((JButton)objectArray[0]).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"AD_MakeCustomizerProviderOk"));
        ((JButton)objectArray[1]).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"AD_MakeCustomizerProviderCancel"));
        ((JButton)objectArray[2]).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"AD_MakeCustomizerProviderApply"));
        ((AbstractButton)objectArray[2]).setMnemonic(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"MNE_Customizer_Apply_Option").charAt(0));
        ConfigurationDescriptor configurationDescriptor = this.projectDescriptorProvider.getConfigurationDescriptor().cloneProjectDescriptor();
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        arrayList.add((JComponent)objectArray[0]);
        MakeCustomizer makeCustomizer = new MakeCustomizer(this.project, string, configurationDescriptor, item, folder, arrayList);
        OptionListener optionListener = new OptionListener(this.project, this.projectDescriptorProvider.getConfigurationDescriptor(), configurationDescriptor, makeCustomizer, folder, item);
        ((AbstractButton)objectArray[0]).addActionListener(optionListener);
        ((AbstractButton)objectArray[1]).addActionListener(optionListener);
        ((AbstractButton)objectArray[2]).addActionListener(optionListener);
        String string2 = null;
        string2 = item != null ? MessageFormat.format(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"LBL_File_Customizer_Title"), item.getFile().getName()) : (folder != null ? MessageFormat.format(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"LBL_Folder_Customizer_Title"), folder.getName()) : MessageFormat.format(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"LBL_Project_Customizer_Title"), ProjectUtils.getInformation((Project)this.project).getDisplayName()));
        this.dialogDescriptor = new DialogDescriptor((Object)makeCustomizer, string2, true, objectArray, objectArray[0], 0, null, null);
        this.dialogDescriptor.setClosingOptions(new Object[]{objectArray[0], objectArray[1]});
        makeCustomizer.setDialogDescriptor(this.dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        this.customizerPerProject.put(this.project, dialog);
        this.currentCommand = COMMAND_CANCEL;
        dialog.setVisible(true);
        if (this.currentCommand.equals(COMMAND_CANCEL)) {
            this.fireActionEvent(new ActionEvent(this.project, 0, this.currentCommand));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(ActionListener actionListener) {
        Set<ActionListener> set = this.actionListenerList;
        synchronized (set) {
            this.actionListenerList.add(actionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionListener(ActionListener actionListener) {
        Set<ActionListener> set = this.actionListenerList;
        synchronized (set) {
            this.actionListenerList.remove(actionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionEvent(ActionEvent actionEvent) {
        Iterator<ActionListener> iterator;
        Set<ActionListener> set = this.actionListenerList;
        synchronized (set) {
            iterator = new HashSet<ActionListener>(this.actionListenerList).iterator();
        }
        while (iterator.hasNext()) {
            iterator.next().actionPerformed(actionEvent);
        }
    }

    private static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(MakeCustomizerProvider.class);
        }
        return bundle.getString(string);
    }

    private class OptionListener
    implements ActionListener {
        private Project project;
        private ConfigurationDescriptor projectDescriptor;
        private ConfigurationDescriptor clonedProjectdescriptor;
        private MakeCustomizer makeCustomizer;
        private Folder folder;
        private Item item;

        OptionListener(Project project, ConfigurationDescriptor configurationDescriptor, ConfigurationDescriptor configurationDescriptor2, MakeCustomizer makeCustomizer, Folder folder, Item item) {
            this.project = project;
            this.projectDescriptor = configurationDescriptor;
            this.clonedProjectdescriptor = configurationDescriptor2;
            this.makeCustomizer = makeCustomizer;
            this.folder = folder;
            this.item = item;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MakeCustomizerProvider.this.currentCommand = actionEvent.getActionCommand();
            if (MakeCustomizerProvider.this.currentCommand.equals(MakeCustomizerProvider.COMMAND_OK) || MakeCustomizerProvider.this.currentCommand.equals(MakeCustomizerProvider.COMMAND_APPLY)) {
                Object object;
                Object object2;
                int n;
                int n2 = this.projectDescriptor.getVersion();
                if (n2 < (n = 62)) {
                    object2 = MakeCustomizerProvider.getString("UPGRADE_TXT");
                    object = new NotifyDescriptor.Confirmation(object2, MakeCustomizerProvider.getString("UPGRADE_DIALOG_TITLE"), 0);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)object) != NotifyDescriptor.YES_OPTION) {
                        return;
                    }
                    this.projectDescriptor.setVersion(n);
                }
                this.makeCustomizer.save();
                object2 = ((MakeConfigurationDescriptor)this.projectDescriptor).getSourceRoots();
                object = ((MakeConfigurationDescriptor)this.clonedProjectdescriptor).getSourceRoots();
                Configuration configuration = this.projectDescriptor.getConfs().getActive();
                Configuration configuration2 = this.clonedProjectdescriptor.getConfs().getActive();
                this.projectDescriptor.assign(this.clonedProjectdescriptor);
                this.projectDescriptor.setModified();
                this.projectDescriptor.save();
                ((MakeConfigurationDescriptor)this.projectDescriptor).checkForChangedItems(this.project, this.folder, this.item);
                ((MakeConfigurationDescriptor)this.projectDescriptor).checkForChangedSourceRoots((List<String>)object2, (List<String>)object);
                ((MakeConfigurationDescriptor)this.projectDescriptor).checkConfigurations(configuration, configuration2);
            }
            if (MakeCustomizerProvider.this.currentCommand.equals(MakeCustomizerProvider.COMMAND_APPLY)) {
                this.makeCustomizer.refresh();
            }
            if (!MakeCustomizerProvider.this.currentCommand.equals(MakeCustomizerProvider.COMMAND_CANCEL)) {
                MakeCustomizerProvider.this.fireActionEvent(new ActionEvent(this.project, 0, MakeCustomizerProvider.this.currentCommand));
            }
        }
    }
}

